/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.glassfish.grizzly.filterchain;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.hadoop.shaded.org.glassfish.grizzly.Appendable;
import org.apache.hadoop.shaded.org.glassfish.grizzly.Appender;
import org.apache.hadoop.shaded.org.glassfish.grizzly.Buffer;
import org.apache.hadoop.shaded.org.glassfish.grizzly.CompletionHandler;
import org.apache.hadoop.shaded.org.glassfish.grizzly.Connection;
import org.apache.hadoop.shaded.org.glassfish.grizzly.Context;
import org.apache.hadoop.shaded.org.glassfish.grizzly.Grizzly;
import org.apache.hadoop.shaded.org.glassfish.grizzly.IOEvent;
import org.apache.hadoop.shaded.org.glassfish.grizzly.ProcessorExecutor;
import org.apache.hadoop.shaded.org.glassfish.grizzly.ProcessorResult;
import org.apache.hadoop.shaded.org.glassfish.grizzly.ReadResult;
import org.apache.hadoop.shaded.org.glassfish.grizzly.WriteResult;
import org.apache.hadoop.shaded.org.glassfish.grizzly.asyncqueue.AsyncQueueEnabledTransport;
import org.apache.hadoop.shaded.org.glassfish.grizzly.asyncqueue.AsyncQueueWriter;
import org.apache.hadoop.shaded.org.glassfish.grizzly.asyncqueue.PushBackHandler;
import org.apache.hadoop.shaded.org.glassfish.grizzly.attributes.NullaryFunction;
import org.apache.hadoop.shaded.org.glassfish.grizzly.filterchain.ExecutorResolver;
import org.apache.hadoop.shaded.org.glassfish.grizzly.filterchain.Filter;
import org.apache.hadoop.shaded.org.glassfish.grizzly.filterchain.FilterChainContext;
import org.apache.hadoop.shaded.org.glassfish.grizzly.filterchain.FilterChainEvent;
import org.apache.hadoop.shaded.org.glassfish.grizzly.filterchain.FilterExecutor;
import org.apache.hadoop.shaded.org.glassfish.grizzly.filterchain.ForkAction;
import org.apache.hadoop.shaded.org.glassfish.grizzly.filterchain.InternalContextImpl;
import org.apache.hadoop.shaded.org.glassfish.grizzly.filterchain.InvokeAction;
import org.apache.hadoop.shaded.org.glassfish.grizzly.filterchain.ListFacadeFilterChain;
import org.apache.hadoop.shaded.org.glassfish.grizzly.filterchain.NextAction;
import org.apache.hadoop.shaded.org.glassfish.grizzly.filterchain.StopAction;
import org.apache.hadoop.shaded.org.glassfish.grizzly.filterchain.TransportFilter;
import org.apache.hadoop.shaded.org.glassfish.grizzly.impl.FutureImpl;
import org.apache.hadoop.shaded.org.glassfish.grizzly.memory.Buffers;
import org.apache.hadoop.shaded.org.glassfish.grizzly.utils.Futures;

public final class DefaultFilterChain
extends ListFacadeFilterChain {
    private final FiltersStateFactory filtersStateFactory = new FiltersStateFactory();
    private static final Logger LOGGER = Grizzly.logger(DefaultFilterChain.class);

    public DefaultFilterChain() {
        this((Collection<Filter>)new ArrayList<Filter>());
    }

    public DefaultFilterChain(Collection<Filter> initialFilters) {
        super(new ArrayList<Filter>(initialFilters));
    }

    @Override
    public ProcessorResult process(Context context) {
        if (this.isEmpty()) {
            return ProcessorResult.createComplete();
        }
        InternalContextImpl internalContext = (InternalContextImpl)context;
        FilterChainContext filterChainContext = internalContext.filterChainContext;
        if (filterChainContext.getOperation() == FilterChainContext.Operation.NONE) {
            IOEvent ioEvent = internalContext.getIoEvent();
            if (ioEvent != IOEvent.WRITE) {
                filterChainContext.setOperation(FilterChainContext.ioEvent2Operation(ioEvent));
            } else {
                Connection connection = context.getConnection();
                AsyncQueueEnabledTransport transport = (AsyncQueueEnabledTransport)((Object)connection.getTransport());
                AsyncQueueWriter writer = transport.getAsyncQueueIO().getWriter();
                return writer.processAsync(context).toProcessorResult();
            }
        }
        return this.execute(filterChainContext);
    }

    @Override
    public ProcessorResult execute(FilterChainContext ctx) {
        FilterExecutor executor = ExecutorResolver.resolve(ctx);
        if (ctx.getFilterIdx() == Integer.MIN_VALUE) {
            executor.initIndexes(ctx);
        }
        Connection connection = ctx.getConnection();
        FiltersState filtersState = this.obtainFiltersState(connection);
        int end = ctx.getEndIdx();
        try {
            do {
                FilterExecution execution = this.executeChainPart(ctx, executor, ctx.getFilterIdx(), end, filtersState);
                switch (execution.type) {
                    case 1: {
                        return ProcessorResult.createTerminate();
                    }
                    case 2: {
                        ctx = execution.getContext();
                        int idx = DefaultFilterChain.indexOfRemainder(filtersState, ctx.getOperation(), ctx.getStartIdx(), end);
                        if (idx != -1) {
                            ctx.setMessage(null);
                            ctx.setFilterIdx(idx);
                            return ProcessorResult.createRerun(ctx.internalContext);
                        }
                        return ProcessorResult.createReregister(ctx.internalContext);
                    }
                }
            } while (DefaultFilterChain.prepareRemainder(ctx, filtersState, ctx.getStartIdx(), end));
        }
        catch (Throwable e) {
            LOGGER.log(e instanceof IOException ? Level.FINE : Level.WARNING, "Exception during FilterChain execution", e);
            this.throwChain(ctx, executor, e);
            ctx.getConnection().closeSilently();
            return ProcessorResult.createError(e);
        }
        return ProcessorResult.createComplete();
    }

    protected final FilterExecution executeChainPart(FilterChainContext ctx, FilterExecutor executor, int start, int end, FiltersState filtersState) throws IOException {
        int i = start;
        int lastNextActionType = 0;
        NextAction lastNextAction = null;
        while (i != end) {
            Filter currentFilter = this.get(i);
            this.checkStoredMessage(ctx, filtersState, i);
            lastNextAction = this.executeFilter(executor, currentFilter, ctx);
            lastNextActionType = lastNextAction.type();
            if (lastNextActionType != 0) break;
            this.storeMessage(ctx, filtersState, FILTER_STATE_TYPE.REMAINDER, i, ((InvokeAction)lastNextAction).getRemainder(), null);
            i = executor.getNextFilter(ctx);
            ctx.setFilterIdx(i);
        }
        switch (lastNextActionType) {
            case 0: {
                this.notifyComplete(ctx);
                break;
            }
            case 1: {
                StopAction stopAction = (StopAction)lastNextAction;
                this.storeMessage(ctx, filtersState, FILTER_STATE_TYPE.INCOMPLETE, i, stopAction.getRemainder(), stopAction.getAppender());
                break;
            }
            case 5: {
                ForkAction forkAction = (ForkAction)lastNextAction;
                return FilterExecution.createReExecute(forkAction.getContext());
            }
            case 2: {
                return FilterExecution.createTerminate();
            }
        }
        return FilterExecution.createContinue();
    }

    protected NextAction executeFilter(FilterExecutor executor, Filter currentFilter, FilterChainContext ctx) throws IOException {
        NextAction nextNextAction;
        do {
            if (LOGGER.isLoggable(Level.FINEST)) {
                LOGGER.log(Level.FINE, "Execute filter. filter={0} context={1}", new Object[]{currentFilter, ctx});
            }
            nextNextAction = executor.execute(currentFilter, ctx);
            if (!LOGGER.isLoggable(Level.FINEST)) continue;
            LOGGER.log(Level.FINE, "after execute filter. filter={0} context={1} nextAction={2}", new Object[]{currentFilter, ctx, nextNextAction});
        } while (nextNextAction.type() == 4);
        return nextNextAction;
    }

    protected static boolean prepareRemainder(FilterChainContext ctx, FiltersState filtersState, int start, int end) {
        int idx = DefaultFilterChain.indexOfRemainder(filtersState, ctx.getOperation(), start, end);
        if (idx != -1) {
            ctx.setFilterIdx(idx);
            ctx.setMessage(null);
            return true;
        }
        return false;
    }

    protected static int indexOfRemainder(FiltersState filtersState, FilterChainContext.Operation operation, int start, int end) {
        int add = end - start > 0 ? 1 : -1;
        for (int i = end - add; i != start - add; i -= add) {
            FilterStateElement element = filtersState.getState(operation, i);
            if (element == null || element.getType() != FILTER_STATE_TYPE.REMAINDER) continue;
            return i;
        }
        return -1;
    }

    @Override
    public void read(Connection connection, CompletionHandler<ReadResult> completionHandler) {
        FilterChainContext context = this.obtainFilterChainContext(connection);
        context.setOperation(FilterChainContext.Operation.READ);
        context.getTransportContext().configureBlocking(true);
        try {
            ReadResult readResult = this.read(context);
            Futures.notifyResult(null, completionHandler, readResult);
        }
        catch (IOException e) {
            Futures.notifyFailure(null, completionHandler, e);
        }
    }

    @Override
    public ReadResult read(FilterChainContext context) throws IOException {
        Connection connection = context.getConnection();
        if (!context.getTransportContext().isBlocking()) {
            throw new IllegalStateException("FilterChain doesn't support standalone non blocking read. Please use Filter instead.");
        }
        FutureImpl future = Futures.createUnsafeFuture();
        context.operationCompletionHandler = Futures.toCompletionHandler(future);
        FilterExecutor executor = ExecutorResolver.resolve(context);
        FiltersState filtersState = this.obtainFiltersState(connection);
        do {
            if (!DefaultFilterChain.prepareRemainder(context, filtersState, 0, context.getEndIdx())) {
                context.setFilterIdx(0);
                context.setMessage(null);
            }
            this.executeChainPart(context, executor, context.getFilterIdx(), context.getEndIdx(), filtersState);
        } while (!future.isDone());
        try {
            FilterChainContext retContext = (FilterChainContext)future.get();
            ReadResult rr = ReadResult.create(connection);
            rr.setMessage(retContext.getMessage());
            rr.setSrcAddress(retContext.getAddress());
            future.recycle(false);
            return rr;
        }
        catch (ExecutionException e) {
            Throwable t = e.getCause();
            if (t instanceof IOException) {
                throw (IOException)t;
            }
            throw new IOException(t);
        }
        catch (InterruptedException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void write(Connection connection, Object dstAddress, Object message, CompletionHandler completionHandler, PushBackHandler pushBackHandler) {
        FilterChainContext context = this.obtainFilterChainContext(connection);
        context.transportFilterContext.completionHandler = completionHandler;
        context.transportFilterContext.pushBackHandler = pushBackHandler;
        context.setAddress(dstAddress);
        context.setMessage(message);
        context.setOperation(FilterChainContext.Operation.WRITE);
        ProcessorExecutor.execute(context.internalContext);
    }

    @Override
    public void flush(Connection connection, CompletionHandler<WriteResult> completionHandler) {
        FilterChainContext context = this.obtainFilterChainContext(connection);
        context.setOperation(FilterChainContext.Operation.EVENT);
        context.event = TransportFilter.createFlushEvent(completionHandler);
        ExecutorResolver.DOWNSTREAM_EXECUTOR_SAMPLE.initIndexes(context);
        ProcessorExecutor.execute(context.internalContext);
    }

    @Override
    public void fireEventDownstream(Connection connection, FilterChainEvent event, CompletionHandler<FilterChainContext> completionHandler) {
        FilterChainContext context = this.obtainFilterChainContext(connection);
        context.operationCompletionHandler = completionHandler;
        context.setOperation(FilterChainContext.Operation.EVENT);
        context.event = event;
        ExecutorResolver.DOWNSTREAM_EXECUTOR_SAMPLE.initIndexes(context);
        ProcessorExecutor.execute(context.internalContext);
    }

    @Override
    public void fireEventUpstream(Connection connection, FilterChainEvent event, CompletionHandler<FilterChainContext> completionHandler) {
        FilterChainContext context = this.obtainFilterChainContext(connection);
        context.operationCompletionHandler = completionHandler;
        context.setOperation(FilterChainContext.Operation.EVENT);
        context.event = event;
        ExecutorResolver.UPSTREAM_EXECUTOR_SAMPLE.initIndexes(context);
        ProcessorExecutor.execute(context.internalContext);
    }

    @Override
    public void fail(FilterChainContext context, Throwable failure) {
        this.throwChain(context, ExecutorResolver.resolve(context), failure);
    }

    private void throwChain(FilterChainContext ctx, FilterExecutor executor, Throwable exception) {
        int i;
        this.notifyFailure(ctx, exception);
        int endIdx = ctx.getStartIdx();
        if (ctx.getFilterIdx() == endIdx) {
            return;
        }
        do {
            i = executor.getPreviousFilter(ctx);
            ctx.setFilterIdx(i);
            this.get(i).exceptionOccurred(ctx, exception);
        } while (i != endIdx);
    }

    public DefaultFilterChain subList(int fromIndex, int toIndex) {
        return new DefaultFilterChain((Collection<Filter>)this.filters.subList(fromIndex, toIndex));
    }

    private FiltersState obtainFiltersState(Connection connection) {
        return connection.obtainProcessorState(this, this.filtersStateFactory);
    }

    private void checkStoredMessage(FilterChainContext ctx, FiltersState filtersState, int filterIdx) {
        FilterStateElement filterState;
        FilterChainContext.Operation operation = ctx.getOperation();
        if (filtersState != null && (filterState = filtersState.clearState(operation, filterIdx)) != null) {
            Object storedMessage = filterState.getState();
            Object currentMessage = ctx.getMessage();
            if (currentMessage != null) {
                Appender appender = filterState.getAppender();
                storedMessage = appender != null ? appender.append(storedMessage, currentMessage) : ((Appendable)storedMessage).append(currentMessage);
            }
            ctx.setMessage(storedMessage);
        }
    }

    private <M> void storeMessage(FilterChainContext ctx, FiltersState filtersState, FILTER_STATE_TYPE type, int filterIdx, M messageToStore, Appender<M> appender) {
        if (messageToStore != null) {
            FilterChainContext.Operation operation = ctx.getOperation();
            filtersState.setState(operation, filterIdx, FilterStateElement.create(type, messageToStore, appender));
        }
    }

    private void notifyComplete(FilterChainContext context) {
        CompletionHandler transportCompletionHandler;
        CompletionHandler<FilterChainContext> completionHandler = context.operationCompletionHandler;
        if (completionHandler != null) {
            completionHandler.completed(context);
        }
        if ((transportCompletionHandler = context.transportFilterContext.completionHandler) != null) {
            transportCompletionHandler.completed(null);
        }
    }

    private void notifyFailure(FilterChainContext context, Throwable e) {
        CompletionHandler transportCompletionHandler;
        CompletionHandler<FilterChainContext> completionHandler = context.operationCompletionHandler;
        if (completionHandler != null) {
            completionHandler.failed(e);
        }
        if ((transportCompletionHandler = context.transportFilterContext.completionHandler) != null) {
            transportCompletionHandler.failed(e);
        }
    }

    private static final class FilterExecution {
        private static final int CONTINUE_TYPE = 0;
        private static final int TERMINATE_TYPE = 1;
        private static final int REEXECUTE_TYPE = 2;
        private static final FilterExecution CONTINUE = new FilterExecution(0, null);
        private static final FilterExecution TERMINATE = new FilterExecution(1, null);
        private final int type;
        private final FilterChainContext context;

        public static FilterExecution createContinue() {
            return CONTINUE;
        }

        public static FilterExecution createTerminate() {
            return TERMINATE;
        }

        public static FilterExecution createReExecute(FilterChainContext context) {
            return new FilterExecution(2, context);
        }

        public FilterExecution(int type, FilterChainContext context) {
            this.type = type;
            this.context = context;
        }

        public int getType() {
            return this.type;
        }

        public FilterChainContext getContext() {
            return this.context;
        }
    }

    private final class FiltersStateFactory
    implements NullaryFunction<FiltersState> {
        private FiltersStateFactory() {
        }

        @Override
        public FiltersState evaluate() {
            return new FiltersState(DefaultFilterChain.this.size());
        }
    }

    public static final class FilterStateElement {
        private final FILTER_STATE_TYPE type;
        private final Object state;
        private final Appender appender;

        public static FilterStateElement create(FILTER_STATE_TYPE type, Object remainder) {
            if (remainder instanceof Buffer) {
                return FilterStateElement.create(type, (Buffer)remainder, Buffers.getBufferAppender(true));
            }
            return FilterStateElement.create(type, (Appendable)remainder);
        }

        public static FilterStateElement create(FILTER_STATE_TYPE type, Appendable state) {
            return new FilterStateElement(type, state);
        }

        public static <E> FilterStateElement create(FILTER_STATE_TYPE type, E state, Appender<E> appender) {
            return new FilterStateElement(type, state, appender);
        }

        private FilterStateElement(FILTER_STATE_TYPE type, Appendable state) {
            this.type = type;
            this.state = state;
            this.appender = null;
        }

        private <E> FilterStateElement(FILTER_STATE_TYPE type, E state, Appender<E> appender) {
            this.type = type;
            this.state = state;
            this.appender = appender;
        }

        private FILTER_STATE_TYPE getType() {
            return this.type;
        }

        public Object getState() {
            return this.state;
        }

        public Appender getAppender() {
            return this.appender;
        }
    }

    public static final class FiltersState {
        private final FilterStateElement[][] state;

        public FiltersState(int filtersNum) {
            this.state = new FilterStateElement[FilterChainContext.Operation.values().length][filtersNum];
        }

        public FilterStateElement getState(FilterChainContext.Operation operation, int filterIndex) {
            return this.state[operation.ordinal()][filterIndex];
        }

        public void setState(FilterChainContext.Operation operation, int filterIndex, FilterStateElement stateElement) {
            this.state[operation.ordinal()][filterIndex] = stateElement;
        }

        public FilterStateElement clearState(FilterChainContext.Operation operation, int filterIndex) {
            int operationIdx = operation.ordinal();
            FilterStateElement oldState = this.state[operationIdx][filterIndex];
            this.state[operationIdx][filterIndex] = null;
            return oldState;
        }

        public int indexOf(FilterChainContext.Operation operation, FILTER_STATE_TYPE type) {
            return this.indexOf(operation, type, 0);
        }

        public int indexOf(FilterChainContext.Operation operation, FILTER_STATE_TYPE type, int start) {
            int eventIdx = operation.ordinal();
            int length = this.state[eventIdx].length;
            for (int i = start; i < length; ++i) {
                FilterStateElement filterState = this.state[eventIdx][i];
                if (filterState == null || filterState.getType() != type) continue;
                return i;
            }
            return -1;
        }

        public int lastIndexOf(IOEvent event, FILTER_STATE_TYPE type, int end) {
            int eventIdx = event.ordinal();
            for (int i = end - 1; i >= 0; --i) {
                FilterStateElement filterState = this.state[eventIdx][i];
                if (filterState == null || filterState.getType() != type) continue;
                return i;
            }
            return -1;
        }

        public int lastIndexOf(IOEvent event, FILTER_STATE_TYPE type) {
            return this.lastIndexOf(event, type, this.state[event.ordinal()].length);
        }
    }

    public static enum FILTER_STATE_TYPE {
        INCOMPLETE,
        REMAINDER;

    }
}

