/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.federation.store.records;

import java.nio.ByteBuffer;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.shaded.org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.hadoop.shaded.org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.hadoop.yarn.util.Records;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public abstract class RouterMasterKey {
    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public static RouterMasterKey newInstance(Integer keyId, ByteBuffer keyBytes, Long expiryDate) {
        RouterMasterKey policy = (RouterMasterKey)Records.newRecord(RouterMasterKey.class);
        policy.setKeyId(keyId);
        policy.setKeyBytes(keyBytes);
        policy.setExpiryDate(expiryDate);
        return policy;
    }

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public static RouterMasterKey newInstance(RouterMasterKey masterKey) {
        RouterMasterKey routerMasterKey = (RouterMasterKey)Records.newRecord(RouterMasterKey.class);
        routerMasterKey.setKeyId(masterKey.getKeyId());
        routerMasterKey.setKeyBytes(masterKey.getKeyBytes());
        routerMasterKey.setExpiryDate(masterKey.getExpiryDate());
        return routerMasterKey;
    }

    @InterfaceAudience.Public
    @InterfaceStability.Unstable
    public abstract Integer getKeyId();

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public abstract void setKeyId(Integer var1);

    @InterfaceAudience.Public
    @InterfaceStability.Unstable
    public abstract ByteBuffer getKeyBytes();

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public abstract void setKeyBytes(ByteBuffer var1);

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public abstract Long getExpiryDate();

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public abstract void setExpiryDate(Long var1);

    public int hashCode() {
        return new HashCodeBuilder().append(this.getExpiryDate().longValue()).append(this.getKeyId().intValue()).append(this.getKeyBytes().array()).hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj instanceof RouterMasterKey) {
            RouterMasterKey other = (RouterMasterKey)obj;
            return new EqualsBuilder().append(this.getKeyId().intValue(), other.getKeyId().intValue()).append(this.getExpiryDate().longValue(), other.getExpiryDate().longValue()).append((Object)this.getKeyBytes().array(), (Object)other.getKeyBytes()).isEquals();
        }
        return false;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("RouterMasterKey: [").append("KeyId: ").append(this.getKeyId()).append(", ").append("ExpiryDate: ").append(this.getExpiryDate()).append(", ").append("KeyBytes: ").append(this.getKeyBytes()).append(", ").append("]");
        return sb.toString();
    }
}

