/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.nodemanager.containermanager.deletion.task;

import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hadoop.yarn.proto.YarnServerNodemanagerRecoveryProtos;
import org.apache.hadoop.yarn.server.nodemanager.DeletionService;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.deletion.task.DeletionTaskType;
import org.apache.hadoop.yarn.server.nodemanager.recovery.NMStateStoreService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DeletionTask
implements Runnable {
    static final Logger LOG = LoggerFactory.getLogger(DeletionTask.class);
    public static final int INVALID_TASK_ID = -1;
    private int taskId;
    private String user;
    private DeletionTaskType deletionTaskType;
    private DeletionService deletionService;
    private final AtomicInteger numberOfPendingPredecessorTasks;
    private final Set<DeletionTask> successorTaskSet;
    private boolean success;

    public DeletionTask(int taskId, DeletionService deletionService, String user, DeletionTaskType deletionTaskType) {
        this(taskId, deletionService, user, new AtomicInteger(0), new HashSet<DeletionTask>(), deletionTaskType);
    }

    public DeletionTask(int taskId, DeletionService deletionService, String user, AtomicInteger numberOfPendingPredecessorTasks, Set<DeletionTask> successorTaskSet, DeletionTaskType deletionTaskType) {
        this.taskId = taskId;
        this.deletionService = deletionService;
        this.user = user;
        this.numberOfPendingPredecessorTasks = numberOfPendingPredecessorTasks;
        this.successorTaskSet = successorTaskSet;
        this.deletionTaskType = deletionTaskType;
        this.success = true;
    }

    public int getTaskId() {
        return this.taskId;
    }

    public void setTaskId(int taskId) {
        this.taskId = taskId;
    }

    public String getUser() {
        return this.user;
    }

    public DeletionService getDeletionService() {
        return this.deletionService;
    }

    public DeletionTaskType getDeletionTaskType() {
        return this.deletionTaskType;
    }

    public synchronized void setSuccess(boolean success) {
        this.success = success;
    }

    public synchronized boolean getSucess() {
        return this.success;
    }

    public synchronized DeletionTask[] getSuccessorTasks() {
        DeletionTask[] successors = new DeletionTask[this.successorTaskSet.size()];
        return this.successorTaskSet.toArray(successors);
    }

    public abstract YarnServerNodemanagerRecoveryProtos.DeletionServiceDeleteTaskProto convertDeletionTaskToProto();

    public synchronized void addDeletionTaskDependency(DeletionTask successorTask) {
        if (this.successorTaskSet.add(successorTask)) {
            successorTask.incrementAndGetPendingPredecessorTasks();
        }
    }

    public int incrementAndGetPendingPredecessorTasks() {
        return this.numberOfPendingPredecessorTasks.incrementAndGet();
    }

    public int decrementAndGetPendingPredecessorTasks() {
        return this.numberOfPendingPredecessorTasks.decrementAndGet();
    }

    synchronized void deletionTaskFinished() {
        try {
            NMStateStoreService stateStore = this.deletionService.getStateStore();
            stateStore.removeDeletionTask(this.taskId);
        }
        catch (IOException e) {
            LOG.error("Unable to remove deletion task " + this.taskId + " from state store", (Throwable)e);
        }
        for (DeletionTask successorTask : this.successorTaskSet) {
            int count;
            if (!this.success) {
                successorTask.setSuccess(this.success);
            }
            if ((count = successorTask.decrementAndGetPendingPredecessorTasks()) != 0) continue;
            if (successorTask.getSucess()) {
                successorTask.deletionService.delete(successorTask);
                continue;
            }
            successorTask.deletionTaskFinished();
        }
    }

    YarnServerNodemanagerRecoveryProtos.DeletionServiceDeleteTaskProto.Builder getBaseDeletionTaskProtoBuilder() {
        YarnServerNodemanagerRecoveryProtos.DeletionServiceDeleteTaskProto.Builder builder = YarnServerNodemanagerRecoveryProtos.DeletionServiceDeleteTaskProto.newBuilder();
        builder.setId(this.getTaskId());
        if (this.getUser() != null) {
            builder.setUser(this.getUser());
        }
        builder.setDeletionTime(System.currentTimeMillis() + TimeUnit.MILLISECONDS.convert(this.getDeletionService().getDebugDelay(), TimeUnit.SECONDS));
        for (DeletionTask successor : this.getSuccessorTasks()) {
            builder.addSuccessorIds(successor.getTaskId());
        }
        return builder;
    }
}

