/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.com.squareup.okhttp.internal.http;

import java.io.IOException;
import java.net.Proxy;
import java.net.Socket;
import java.net.URL;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import org.apache.hadoop.shaded.com.squareup.okhttp.Address;
import org.apache.hadoop.shaded.com.squareup.okhttp.CertificatePinner;
import org.apache.hadoop.shaded.com.squareup.okhttp.Connection;
import org.apache.hadoop.shaded.com.squareup.okhttp.ConnectionPool;
import org.apache.hadoop.shaded.com.squareup.okhttp.ConnectionSpec;
import org.apache.hadoop.shaded.com.squareup.okhttp.Handshake;
import org.apache.hadoop.shaded.com.squareup.okhttp.Protocol;
import org.apache.hadoop.shaded.com.squareup.okhttp.Request;
import org.apache.hadoop.shaded.com.squareup.okhttp.Response;
import org.apache.hadoop.shaded.com.squareup.okhttp.Route;
import org.apache.hadoop.shaded.com.squareup.okhttp.internal.ConnectionSpecSelector;
import org.apache.hadoop.shaded.com.squareup.okhttp.internal.Platform;
import org.apache.hadoop.shaded.com.squareup.okhttp.internal.Util;
import org.apache.hadoop.shaded.com.squareup.okhttp.internal.http.HttpConnection;
import org.apache.hadoop.shaded.com.squareup.okhttp.internal.http.OkHeaders;
import org.apache.hadoop.shaded.com.squareup.okhttp.internal.http.RouteException;
import org.apache.hadoop.shaded.com.squareup.okhttp.internal.tls.OkHostnameVerifier;
import org.apache.hadoop.shaded.okio.Source;

public class SocketConnector {
    private final Connection connection;
    private final ConnectionPool connectionPool;

    public SocketConnector(Connection connection, ConnectionPool connectionPool) {
        this.connection = connection;
        this.connectionPool = connectionPool;
    }

    public ConnectedSocket connectCleartext(int connectTimeout, int readTimeout, Route route) throws RouteException {
        Socket socket = this.connectRawSocket(readTimeout, connectTimeout, route);
        return new ConnectedSocket(route, socket);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConnectedSocket connectTls(int connectTimeout, int readTimeout, int writeTimeout, Request request, Route route, List<ConnectionSpec> connectionSpecs, boolean connectionRetryEnabled) throws RouteException {
        Address address = route.getAddress();
        ConnectionSpecSelector connectionSpecSelector = new ConnectionSpecSelector(connectionSpecs);
        RouteException routeException = null;
        while (true) {
            Socket socket = this.connectRawSocket(readTimeout, connectTimeout, route);
            if (route.requiresTunnel()) {
                this.createTunnel(readTimeout, writeTimeout, request, route, socket);
            }
            SSLSocket sslSocket = null;
            try {
                SSLSocketFactory sslSocketFactory = address.getSslSocketFactory();
                sslSocket = (SSLSocket)sslSocketFactory.createSocket(socket, address.getUriHost(), address.getUriPort(), true);
                ConnectionSpec connectionSpec = connectionSpecSelector.configureSecureSocket(sslSocket);
                Platform platform = Platform.get();
                Handshake handshake = null;
                Protocol alpnProtocol = null;
                try {
                    String maybeProtocol;
                    if (connectionSpec.supportsTlsExtensions()) {
                        platform.configureTlsExtensions(sslSocket, address.getUriHost(), address.getProtocols());
                    }
                    sslSocket.startHandshake();
                    handshake = Handshake.get(sslSocket.getSession());
                    if (connectionSpec.supportsTlsExtensions() && (maybeProtocol = platform.getSelectedProtocol(sslSocket)) != null) {
                        alpnProtocol = Protocol.get(maybeProtocol);
                    }
                }
                finally {
                    platform.afterHandshake(sslSocket);
                }
                if (!address.getHostnameVerifier().verify(address.getUriHost(), sslSocket.getSession())) {
                    X509Certificate cert = (X509Certificate)sslSocket.getSession().getPeerCertificates()[0];
                    throw new SSLPeerUnverifiedException("Hostname " + address.getUriHost() + " not verified:" + "\n    certificate: " + CertificatePinner.pin(cert) + "\n    DN: " + cert.getSubjectDN().getName() + "\n    subjectAltNames: " + OkHostnameVerifier.allSubjectAltNames(cert));
                }
                address.getCertificatePinner().check(address.getUriHost(), handshake.peerCertificates());
                return new ConnectedSocket(route, sslSocket, alpnProtocol, handshake);
            }
            catch (IOException e) {
                boolean canRetry = connectionRetryEnabled && connectionSpecSelector.connectionFailed(e);
                Util.closeQuietly(sslSocket);
                Util.closeQuietly(socket);
                if (routeException == null) {
                    routeException = new RouteException(e);
                    continue;
                }
                routeException.addConnectException(e);
                if (canRetry) continue;
                throw routeException;
            }
            break;
        }
    }

    private Socket connectRawSocket(int soTimeout, int connectTimeout, Route route) throws RouteException {
        Platform platform = Platform.get();
        try {
            Proxy proxy = route.getProxy();
            Address address = route.getAddress();
            Socket socket = proxy.type() == Proxy.Type.DIRECT || proxy.type() == Proxy.Type.HTTP ? address.getSocketFactory().createSocket() : new Socket(proxy);
            socket.setSoTimeout(soTimeout);
            platform.connectSocket(socket, route.getSocketAddress(), connectTimeout);
            return socket;
        }
        catch (IOException e) {
            throw new RouteException(e);
        }
    }

    private void createTunnel(int readTimeout, int writeTimeout, Request request, Route route, Socket socket) throws RouteException {
        try {
            Response response;
            Request tunnelRequest = this.createTunnelRequest(request);
            HttpConnection tunnelConnection = new HttpConnection(this.connectionPool, this.connection, socket);
            tunnelConnection.setTimeouts(readTimeout, writeTimeout);
            URL url = tunnelRequest.url();
            String requestLine = "CONNECT " + url.getHost() + ":" + Util.getEffectivePort(url) + " HTTP/1.1";
            block6: while (true) {
                tunnelConnection.writeRequest(tunnelRequest.headers(), requestLine);
                tunnelConnection.flush();
                response = tunnelConnection.readResponse().request(tunnelRequest).build();
                long contentLength = OkHeaders.contentLength(response);
                if (contentLength == -1L) {
                    contentLength = 0L;
                }
                Source body = tunnelConnection.newFixedLengthSource(contentLength);
                Util.skipAll(body, Integer.MAX_VALUE, TimeUnit.MILLISECONDS);
                body.close();
                switch (response.code()) {
                    case 200: {
                        if (tunnelConnection.bufferSize() > 0L) {
                            throw new IOException("TLS tunnel buffered too many bytes!");
                        }
                        return;
                    }
                    case 407: {
                        tunnelRequest = OkHeaders.processAuthHeader(route.getAddress().getAuthenticator(), response, route.getProxy());
                        if (tunnelRequest != null) continue block6;
                        throw new IOException("Failed to authenticate with proxy");
                    }
                }
                break;
            }
            throw new IOException("Unexpected response code for CONNECT: " + response.code());
        }
        catch (IOException e) {
            throw new RouteException(e);
        }
    }

    private Request createTunnelRequest(Request request) throws IOException {
        String proxyAuthorization;
        String host = request.url().getHost();
        int port = Util.getEffectivePort(request.url());
        String authority = port == Util.getDefaultPort("https") ? host : host + ":" + port;
        Request.Builder result = new Request.Builder().url(new URL("https", host, port, "/")).header("Host", authority).header("Proxy-Connection", "Keep-Alive");
        String userAgent = request.header("User-Agent");
        if (userAgent != null) {
            result.header("User-Agent", userAgent);
        }
        if ((proxyAuthorization = request.header("Proxy-Authorization")) != null) {
            result.header("Proxy-Authorization", proxyAuthorization);
        }
        return result.build();
    }

    public static class ConnectedSocket {
        public final Route route;
        public final Socket socket;
        public final Protocol alpnProtocol;
        public final Handshake handshake;

        public ConnectedSocket(Route route, Socket socket) {
            this.route = route;
            this.socket = socket;
            this.alpnProtocol = null;
            this.handshake = null;
        }

        public ConnectedSocket(Route route, SSLSocket socket, Protocol alpnProtocol, Handshake handshake) {
            this.route = route;
            this.socket = socket;
            this.alpnProtocol = alpnProtocol;
            this.handshake = handshake;
        }
    }
}

