/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.apache.commons.compress.archivers;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.hadoop.shaded.org.apache.commons.compress.archivers.ArchiveException;
import org.apache.hadoop.shaded.org.apache.commons.compress.archivers.ArchiveInputStream;
import org.apache.hadoop.shaded.org.apache.commons.compress.archivers.ArchiveOutputStream;
import org.apache.hadoop.shaded.org.apache.commons.compress.archivers.ar.ArArchiveInputStream;
import org.apache.hadoop.shaded.org.apache.commons.compress.archivers.ar.ArArchiveOutputStream;
import org.apache.hadoop.shaded.org.apache.commons.compress.archivers.cpio.CpioArchiveInputStream;
import org.apache.hadoop.shaded.org.apache.commons.compress.archivers.cpio.CpioArchiveOutputStream;
import org.apache.hadoop.shaded.org.apache.commons.compress.archivers.dump.DumpArchiveInputStream;
import org.apache.hadoop.shaded.org.apache.commons.compress.archivers.jar.JarArchiveInputStream;
import org.apache.hadoop.shaded.org.apache.commons.compress.archivers.jar.JarArchiveOutputStream;
import org.apache.hadoop.shaded.org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.hadoop.shaded.org.apache.commons.compress.archivers.tar.TarArchiveOutputStream;
import org.apache.hadoop.shaded.org.apache.commons.compress.archivers.zip.ZipArchiveInputStream;
import org.apache.hadoop.shaded.org.apache.commons.compress.archivers.zip.ZipArchiveOutputStream;

public class ArchiveStreamFactory {
    public static final String AR = "ar";
    public static final String CPIO = "cpio";
    public static final String DUMP = "dump";
    public static final String JAR = "jar";
    public static final String TAR = "tar";
    public static final String ZIP = "zip";

    public ArchiveInputStream createArchiveInputStream(String archiverName, InputStream in) throws ArchiveException {
        if (archiverName == null) {
            throw new IllegalArgumentException("Archivername must not be null.");
        }
        if (in == null) {
            throw new IllegalArgumentException("InputStream must not be null.");
        }
        if (AR.equalsIgnoreCase(archiverName)) {
            return new ArArchiveInputStream(in);
        }
        if (ZIP.equalsIgnoreCase(archiverName)) {
            return new ZipArchiveInputStream(in);
        }
        if (TAR.equalsIgnoreCase(archiverName)) {
            return new TarArchiveInputStream(in);
        }
        if (JAR.equalsIgnoreCase(archiverName)) {
            return new JarArchiveInputStream(in);
        }
        if (CPIO.equalsIgnoreCase(archiverName)) {
            return new CpioArchiveInputStream(in);
        }
        if (DUMP.equalsIgnoreCase(archiverName)) {
            return new DumpArchiveInputStream(in);
        }
        throw new ArchiveException("Archiver: " + archiverName + " not found.");
    }

    public ArchiveOutputStream createArchiveOutputStream(String archiverName, OutputStream out) throws ArchiveException {
        if (archiverName == null) {
            throw new IllegalArgumentException("Archivername must not be null.");
        }
        if (out == null) {
            throw new IllegalArgumentException("OutputStream must not be null.");
        }
        if (AR.equalsIgnoreCase(archiverName)) {
            return new ArArchiveOutputStream(out);
        }
        if (ZIP.equalsIgnoreCase(archiverName)) {
            return new ZipArchiveOutputStream(out);
        }
        if (TAR.equalsIgnoreCase(archiverName)) {
            return new TarArchiveOutputStream(out);
        }
        if (JAR.equalsIgnoreCase(archiverName)) {
            return new JarArchiveOutputStream(out);
        }
        if (CPIO.equalsIgnoreCase(archiverName)) {
            return new CpioArchiveOutputStream(out);
        }
        throw new ArchiveException("Archiver: " + archiverName + " not found.");
    }

    public ArchiveInputStream createArchiveInputStream(InputStream in) throws ArchiveException {
        if (in == null) {
            throw new IllegalArgumentException("Stream must not be null.");
        }
        if (!in.markSupported()) {
            throw new IllegalArgumentException("Mark is not supported.");
        }
        byte[] signature = new byte[12];
        in.mark(signature.length);
        try {
            int signatureLength = in.read(signature);
            in.reset();
            if (ZipArchiveInputStream.matches(signature, signatureLength)) {
                return new ZipArchiveInputStream(in);
            }
            if (JarArchiveInputStream.matches(signature, signatureLength)) {
                return new JarArchiveInputStream(in);
            }
            if (ArArchiveInputStream.matches(signature, signatureLength)) {
                return new ArArchiveInputStream(in);
            }
            if (CpioArchiveInputStream.matches(signature, signatureLength)) {
                return new CpioArchiveInputStream(in);
            }
            byte[] dumpsig = new byte[32];
            in.mark(dumpsig.length);
            signatureLength = in.read(dumpsig);
            in.reset();
            if (DumpArchiveInputStream.matches(dumpsig, signatureLength)) {
                return new DumpArchiveInputStream(in);
            }
            byte[] tarheader = new byte[512];
            in.mark(tarheader.length);
            signatureLength = in.read(tarheader);
            in.reset();
            if (TarArchiveInputStream.matches(tarheader, signatureLength)) {
                return new TarArchiveInputStream(in);
            }
            if (signatureLength >= 512) {
                try {
                    TarArchiveInputStream tais = new TarArchiveInputStream(new ByteArrayInputStream(tarheader));
                    tais.getNextEntry();
                    return new TarArchiveInputStream(in);
                }
                catch (Exception e) {}
            }
        }
        catch (IOException e) {
            throw new ArchiveException("Could not use reset and mark operations.", e);
        }
        throw new ArchiveException("No Archiver found for the stream signature");
    }
}

