/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.apache.commons.math3.linear;

import java.io.Serializable;
import org.apache.hadoop.shaded.org.apache.commons.math3.exception.DimensionMismatchException;
import org.apache.hadoop.shaded.org.apache.commons.math3.exception.MathUnsupportedOperationException;
import org.apache.hadoop.shaded.org.apache.commons.math3.exception.NotStrictlyPositiveException;
import org.apache.hadoop.shaded.org.apache.commons.math3.exception.OutOfRangeException;
import org.apache.hadoop.shaded.org.apache.commons.math3.linear.AbstractRealMatrix;
import org.apache.hadoop.shaded.org.apache.commons.math3.linear.Array2DRowRealMatrix;
import org.apache.hadoop.shaded.org.apache.commons.math3.linear.MatrixDimensionMismatchException;
import org.apache.hadoop.shaded.org.apache.commons.math3.linear.MatrixUtils;
import org.apache.hadoop.shaded.org.apache.commons.math3.linear.RealMatrix;
import org.apache.hadoop.shaded.org.apache.commons.math3.linear.RealMatrixChangingVisitor;
import org.apache.hadoop.shaded.org.apache.commons.math3.linear.RealMatrixPreservingVisitor;

public class DiagonalMatrix
extends AbstractRealMatrix
implements Serializable {
    private static final long serialVersionUID = 20121229L;
    private final double[] data;

    public DiagonalMatrix(int dimension) throws NotStrictlyPositiveException {
        super(dimension, dimension);
        this.data = new double[dimension];
    }

    public DiagonalMatrix(double[] d) {
        this(d, true);
    }

    public DiagonalMatrix(double[] d, boolean copyArray) {
        this.data = copyArray ? (double[])d.clone() : d;
    }

    public RealMatrix createMatrix(int rowDimension, int columnDimension) throws NotStrictlyPositiveException, DimensionMismatchException {
        if (rowDimension != columnDimension) {
            throw new DimensionMismatchException(rowDimension, columnDimension);
        }
        return new DiagonalMatrix(rowDimension);
    }

    public RealMatrix copy() {
        return new DiagonalMatrix(this.data);
    }

    public DiagonalMatrix add(DiagonalMatrix m) throws MatrixDimensionMismatchException {
        MatrixUtils.checkAdditionCompatible(this, m);
        int dim = this.getRowDimension();
        double[] outData = new double[dim];
        for (int i = 0; i < dim; ++i) {
            outData[i] = this.data[i] + m.data[i];
        }
        return new DiagonalMatrix(outData, false);
    }

    public DiagonalMatrix subtract(DiagonalMatrix m) throws MatrixDimensionMismatchException {
        MatrixUtils.checkSubtractionCompatible(this, m);
        int dim = this.getRowDimension();
        double[] outData = new double[dim];
        for (int i = 0; i < dim; ++i) {
            outData[i] = this.data[i] - m.data[i];
        }
        return new DiagonalMatrix(outData, false);
    }

    public DiagonalMatrix multiply(DiagonalMatrix m) throws DimensionMismatchException {
        MatrixUtils.checkMultiplicationCompatible(this, m);
        int dim = this.getRowDimension();
        double[] outData = new double[dim];
        for (int i = 0; i < dim; ++i) {
            outData[i] = this.data[i] * m.data[i];
        }
        return new DiagonalMatrix(outData, false);
    }

    public RealMatrix multiply(RealMatrix m) throws DimensionMismatchException {
        if (m instanceof DiagonalMatrix) {
            return this.multiply((DiagonalMatrix)m);
        }
        MatrixUtils.checkMultiplicationCompatible(this, m);
        int nRows = m.getRowDimension();
        int nCols = m.getColumnDimension();
        double[][] product = new double[nRows][nCols];
        for (int r = 0; r < nRows; ++r) {
            for (int c = 0; c < nCols; ++c) {
                product[r][c] = this.data[r] * m.getEntry(r, c);
            }
        }
        return new Array2DRowRealMatrix(product, false);
    }

    public double[][] getData() {
        int dim = this.getRowDimension();
        double[][] out = new double[dim][dim];
        for (int i = 0; i < dim; ++i) {
            out[i][i] = this.data[i];
        }
        return out;
    }

    public double[] getDataRef() {
        return this.data;
    }

    public void setSubMatrix(double[][] subMatrix, int row, int column) throws MathUnsupportedOperationException {
        throw new MathUnsupportedOperationException();
    }

    public double getEntry(int row, int column) throws OutOfRangeException {
        MatrixUtils.checkMatrixIndex(this, row, column);
        return row == column ? this.data[row] : 0.0;
    }

    public void setEntry(int row, int column, double value) throws OutOfRangeException, MathUnsupportedOperationException {
        if (row != column) {
            throw new MathUnsupportedOperationException();
        }
        MatrixUtils.checkMatrixIndex(this, row, column);
        this.data[row] = value;
    }

    public void addToEntry(int row, int column, double increment) throws OutOfRangeException, MathUnsupportedOperationException {
        if (row != column) {
            throw new MathUnsupportedOperationException();
        }
        MatrixUtils.checkMatrixIndex(this, row, column);
        int n = row;
        this.data[n] = this.data[n] + increment;
    }

    public void multiplyEntry(int row, int column, double factor) throws OutOfRangeException, MathUnsupportedOperationException {
        if (row != column) {
            throw new MathUnsupportedOperationException();
        }
        MatrixUtils.checkMatrixIndex(this, row, column);
        int n = row;
        this.data[n] = this.data[n] * factor;
    }

    public int getRowDimension() {
        return this.data == null ? 0 : this.data.length;
    }

    public int getColumnDimension() {
        return this.getRowDimension();
    }

    public double[] operate(double[] v) throws DimensionMismatchException {
        return this.multiply(new DiagonalMatrix(v, false)).getDataRef();
    }

    public double[] preMultiply(double[] v) throws DimensionMismatchException {
        return this.operate(v);
    }

    public double walkInRowOrder(RealMatrixChangingVisitor visitor) throws MathUnsupportedOperationException {
        throw new MathUnsupportedOperationException();
    }

    public double walkInRowOrder(RealMatrixPreservingVisitor visitor) throws MathUnsupportedOperationException {
        throw new MathUnsupportedOperationException();
    }

    public double walkInRowOrder(RealMatrixChangingVisitor visitor, int startRow, int endRow, int startColumn, int endColumn) throws MathUnsupportedOperationException {
        throw new MathUnsupportedOperationException();
    }

    public double walkInRowOrder(RealMatrixPreservingVisitor visitor, int startRow, int endRow, int startColumn, int endColumn) throws MathUnsupportedOperationException {
        throw new MathUnsupportedOperationException();
    }

    public double walkInColumnOrder(RealMatrixChangingVisitor visitor) throws MathUnsupportedOperationException {
        throw new MathUnsupportedOperationException();
    }

    public double walkInColumnOrder(RealMatrixPreservingVisitor visitor) throws MathUnsupportedOperationException {
        throw new MathUnsupportedOperationException();
    }

    public double walkInColumnOrder(RealMatrixChangingVisitor visitor, int startRow, int endRow, int startColumn, int endColumn) throws MathUnsupportedOperationException {
        throw new MathUnsupportedOperationException();
    }

    public double walkInColumnOrder(RealMatrixPreservingVisitor visitor, int startRow, int endRow, int startColumn, int endColumn) throws MathUnsupportedOperationException {
        throw new MathUnsupportedOperationException();
    }
}

