/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.apache.http.impl.cookie;

import org.apache.hadoop.shaded.org.apache.http.annotation.Immutable;
import org.apache.hadoop.shaded.org.apache.http.cookie.CommonCookieAttributeHandler;
import org.apache.hadoop.shaded.org.apache.http.cookie.Cookie;
import org.apache.hadoop.shaded.org.apache.http.cookie.CookieOrigin;
import org.apache.hadoop.shaded.org.apache.http.cookie.MalformedCookieException;
import org.apache.hadoop.shaded.org.apache.http.cookie.SetCookie;
import org.apache.hadoop.shaded.org.apache.http.impl.cookie.AbstractCookieAttributeHandler;
import org.apache.hadoop.shaded.org.apache.http.util.Args;

@Immutable
public class BasicSecureHandler
extends AbstractCookieAttributeHandler
implements CommonCookieAttributeHandler {
    @Override
    public void parse(SetCookie cookie, String value) throws MalformedCookieException {
        Args.notNull(cookie, "Cookie");
        cookie.setSecure(true);
    }

    @Override
    public boolean match(Cookie cookie, CookieOrigin origin) {
        Args.notNull(cookie, "Cookie");
        Args.notNull(origin, "Cookie origin");
        return !cookie.isSecure() || origin.isSecure();
    }

    @Override
    public String getAttributeName() {
        return "secure";
    }
}

