/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.tukaani.xz;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.hadoop.shaded.org.tukaani.xz.FinishableOutputStream;

class CountingOutputStream
extends FinishableOutputStream {
    private OutputStream out;
    private long size = 0L;

    public CountingOutputStream(OutputStream outputStream) {
        this.out = outputStream;
    }

    public void write(int n) throws IOException {
        this.out.write(n);
        if (this.size >= 0L) {
            ++this.size;
        }
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        this.out.write(byArray, n, n2);
        if (this.size >= 0L) {
            this.size += (long)n2;
        }
    }

    public void flush() throws IOException {
        this.out.flush();
    }

    public void close() throws IOException {
        this.out.close();
    }

    public long getSize() {
        return this.size;
    }
}

