/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.eclipse.jetty.websocket.client;

import java.net.URL;
import org.apache.hadoop.shaded.org.eclipse.jetty.client.HttpClient;
import org.apache.hadoop.shaded.org.eclipse.jetty.util.log.Log;
import org.apache.hadoop.shaded.org.eclipse.jetty.websocket.common.scopes.WebSocketContainerScope;
import org.apache.hadoop.shaded.org.eclipse.jetty.xml.XmlConfiguration;

class XmlBasedHttpClientProvider {
    XmlBasedHttpClientProvider() {
    }

    public static HttpClient get(WebSocketContainerScope scope) {
        URL resource = Thread.currentThread().getContextClassLoader().getResource("jetty-websocket-httpclient.xml");
        if (resource == null) {
            return null;
        }
        try {
            XmlConfiguration configuration = new XmlConfiguration(resource);
            return (HttpClient)configuration.configure();
        }
        catch (Throwable t) {
            Log.getLogger(XmlBasedHttpClientProvider.class).warn("Unable to load: " + resource, t);
            return null;
        }
    }
}

