/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.eclipse.jetty.websocket.common.events;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.ByteBuffer;
import org.apache.hadoop.shaded.org.eclipse.jetty.util.Utf8StringBuilder;
import org.apache.hadoop.shaded.org.eclipse.jetty.util.log.Log;
import org.apache.hadoop.shaded.org.eclipse.jetty.util.log.Logger;
import org.apache.hadoop.shaded.org.eclipse.jetty.websocket.api.WebSocketConnectionListener;
import org.apache.hadoop.shaded.org.eclipse.jetty.websocket.api.WebSocketFrameListener;
import org.apache.hadoop.shaded.org.eclipse.jetty.websocket.api.WebSocketListener;
import org.apache.hadoop.shaded.org.eclipse.jetty.websocket.api.WebSocketPartialListener;
import org.apache.hadoop.shaded.org.eclipse.jetty.websocket.api.WebSocketPingPongListener;
import org.apache.hadoop.shaded.org.eclipse.jetty.websocket.api.WebSocketPolicy;
import org.apache.hadoop.shaded.org.eclipse.jetty.websocket.api.extensions.Frame;
import org.apache.hadoop.shaded.org.eclipse.jetty.websocket.common.CloseInfo;
import org.apache.hadoop.shaded.org.eclipse.jetty.websocket.common.events.AbstractEventDriver;
import org.apache.hadoop.shaded.org.eclipse.jetty.websocket.common.frames.ReadOnlyDelegatedFrame;
import org.apache.hadoop.shaded.org.eclipse.jetty.websocket.common.message.SimpleBinaryMessage;
import org.apache.hadoop.shaded.org.eclipse.jetty.websocket.common.message.SimpleTextMessage;

public class JettyListenerEventDriver
extends AbstractEventDriver {
    private static final Logger LOG = Log.getLogger(JettyListenerEventDriver.class);
    private final WebSocketConnectionListener listener;
    private Utf8StringBuilder utf8Partial;
    private PartialMode partialMode = PartialMode.NONE;
    private boolean hasCloseBeenCalled = false;

    public JettyListenerEventDriver(WebSocketPolicy policy, WebSocketConnectionListener listener) {
        super(policy, listener);
        this.listener = listener;
    }

    @Override
    public void onBinaryFrame(ByteBuffer buffer, boolean fin) throws IOException {
        if (this.listener instanceof WebSocketListener) {
            if (this.activeMessage == null) {
                this.activeMessage = new SimpleBinaryMessage(this);
            }
            this.appendMessage(buffer, fin);
        }
        if (this.listener instanceof WebSocketPartialListener) {
            switch (this.partialMode) {
                case NONE: {
                    this.partialMode = PartialMode.BINARY;
                }
                case BINARY: {
                    ((WebSocketPartialListener)this.listener).onWebSocketPartialBinary(buffer.slice().asReadOnlyBuffer(), fin);
                    break;
                }
                case TEXT: {
                    throw new IOException("Out of order binary frame encountered");
                }
            }
            if (fin) {
                this.partialMode = PartialMode.NONE;
            }
        }
    }

    @Override
    public void onBinaryMessage(byte[] data) {
        if (this.listener instanceof WebSocketListener) {
            ((WebSocketListener)this.listener).onWebSocketBinary(data, 0, data.length);
        }
    }

    @Override
    public void onClose(CloseInfo close) {
        if (this.hasCloseBeenCalled) {
            return;
        }
        this.hasCloseBeenCalled = true;
        int statusCode = close.getStatusCode();
        String reason = close.getReason();
        this.listener.onWebSocketClose(statusCode, reason);
    }

    @Override
    public void onConnect() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("onConnect({})", this.session);
        }
        this.listener.onWebSocketConnect(this.session);
    }

    @Override
    public void onError(Throwable cause) {
        this.listener.onWebSocketError(cause);
    }

    @Override
    public void onFrame(Frame frame) {
        if (this.listener instanceof WebSocketFrameListener) {
            ((WebSocketFrameListener)this.listener).onWebSocketFrame(new ReadOnlyDelegatedFrame(frame));
        }
        if (this.listener instanceof WebSocketPingPongListener) {
            if (frame.getType() == Frame.Type.PING) {
                ((WebSocketPingPongListener)this.listener).onWebSocketPing(frame.getPayload().asReadOnlyBuffer());
            } else if (frame.getType() == Frame.Type.PONG) {
                ((WebSocketPingPongListener)this.listener).onWebSocketPong(frame.getPayload().asReadOnlyBuffer());
            }
        }
    }

    @Override
    public void onInputStream(InputStream stream) {
    }

    @Override
    public void onReader(Reader reader) {
    }

    @Override
    public void onTextFrame(ByteBuffer buffer, boolean fin) throws IOException {
        if (this.listener instanceof WebSocketListener) {
            if (this.activeMessage == null) {
                this.activeMessage = new SimpleTextMessage(this);
            }
            this.appendMessage(buffer, fin);
        }
        if (this.listener instanceof WebSocketPartialListener) {
            switch (this.partialMode) {
                case NONE: {
                    this.partialMode = PartialMode.TEXT;
                }
                case TEXT: {
                    if (this.utf8Partial == null) {
                        this.utf8Partial = new Utf8StringBuilder();
                    }
                    String partial = "";
                    if (buffer != null) {
                        this.utf8Partial.append(buffer);
                        partial = this.utf8Partial.takePartialString();
                    }
                    ((WebSocketPartialListener)this.listener).onWebSocketPartialText(partial, fin);
                    if (!fin) break;
                    this.utf8Partial = null;
                    break;
                }
                case BINARY: {
                    throw new IOException("Out of order text frame encountered");
                }
            }
            if (fin) {
                this.partialMode = PartialMode.NONE;
            }
        }
    }

    @Override
    public void onTextMessage(String message) {
        if (this.listener instanceof WebSocketListener) {
            ((WebSocketListener)this.listener).onWebSocketText(message);
        }
    }

    @Override
    public void onContinuationFrame(ByteBuffer buffer, boolean fin) throws IOException {
        if (this.listener instanceof WebSocketPartialListener) {
            switch (this.partialMode) {
                case NONE: {
                    throw new IOException("Out of order Continuation frame encountered");
                }
                case TEXT: {
                    this.onTextFrame(buffer, fin);
                    break;
                }
                case BINARY: {
                    this.onBinaryFrame(buffer, fin);
                }
            }
            return;
        }
        if (this.listener instanceof WebSocketListener) {
            super.onContinuationFrame(buffer, fin);
        }
    }

    @Override
    public String toString() {
        return String.format("%s[%s]", JettyListenerEventDriver.class.getSimpleName(), this.listener.getClass().getName());
    }

    private static enum PartialMode {
        NONE,
        TEXT,
        BINARY;

    }
}

