/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.eclipse.jetty.websocket.common.io;

import java.nio.ByteBuffer;
import org.apache.hadoop.shaded.org.eclipse.jetty.util.BufferUtil;

class ReadState {
    public static final ByteBuffer NO_ACTION = BufferUtil.EMPTY_BUFFER;
    private State state = State.READING;
    private ByteBuffer buffer;

    ReadState() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isReading() {
        ReadState readState = this;
        synchronized (readState) {
            return this.state == State.READING;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isSuspended() {
        ReadState readState = this;
        synchronized (readState) {
            return this.state == State.SUSPENDED || this.state == State.EOF;
        }
    }

    boolean suspending() {
        ReadState readState = this;
        synchronized (readState) {
            switch (this.state) {
                case READING: {
                    this.state = State.SUSPENDING;
                    return true;
                }
                case EOF: {
                    return false;
                }
            }
            throw new IllegalStateException(this.toString(this.state));
        }
    }

    public boolean suspendParse(ByteBuffer buffer) {
        ReadState readState = this;
        synchronized (readState) {
            switch (this.state) {
                case READING: {
                    return false;
                }
                case SUSPENDING: {
                    this.buffer = buffer;
                    this.state = State.SUSPENDED;
                    return true;
                }
            }
            throw new IllegalStateException(this.toString(this.state));
        }
    }

    boolean suspend() {
        ReadState readState = this;
        synchronized (readState) {
            switch (this.state) {
                case READING: {
                    return false;
                }
                case SUSPENDING: {
                    this.state = State.SUSPENDED;
                    return true;
                }
                case SUSPENDED: {
                    if (this.buffer == null) {
                        throw new IllegalStateException();
                    }
                    return true;
                }
                case EOF: {
                    return true;
                }
            }
            throw new IllegalStateException(this.toString(this.state));
        }
    }

    ByteBuffer resume() {
        ReadState readState = this;
        synchronized (readState) {
            switch (this.state) {
                case SUSPENDING: {
                    this.state = State.READING;
                    return NO_ACTION;
                }
                case SUSPENDED: {
                    this.state = State.READING;
                    ByteBuffer bb = this.buffer;
                    this.buffer = null;
                    return bb;
                }
                case EOF: {
                    return NO_ACTION;
                }
            }
            throw new IllegalStateException(this.toString(this.state));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void eof() {
        ReadState readState = this;
        synchronized (readState) {
            this.state = State.EOF;
        }
    }

    private String toString(State state) {
        return String.format("%s@%x[%s]", new Object[]{this.getClass().getSimpleName(), this.hashCode(), state});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        ReadState readState = this;
        synchronized (readState) {
            return this.toString(this.state);
        }
    }

    private static enum State {
        READING,
        SUSPENDING,
        SUSPENDED,
        EOF;

    }
}

