/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.xbill.DNS;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import lombok.Generated;
import org.apache.hadoop.shaded.org.xbill.DNS.DNSInput;
import org.apache.hadoop.shaded.org.xbill.DNS.DNSOutput;
import org.apache.hadoop.shaded.org.xbill.DNS.EDNSOption;
import org.apache.hadoop.shaded.org.xbill.DNS.Mnemonic;

public class ExtendedErrorCodeOption
extends EDNSOption {
    public static final int OTHER = 0;
    public static final int UNSUPPORTED_DNSKEY_ALGORITHM = 1;
    public static final int UNSUPPORTED_DS_DIGEST_TYPE = 2;
    public static final int STALE_ANSWER = 3;
    public static final int FORGED_ANSWER = 4;
    public static final int DNSSEC_INDETERMINATE = 5;
    public static final int DNSSEC_BOGUS = 6;
    public static final int SIGNATURE_EXPIRED = 7;
    public static final int SIGNATURE_NOT_YET_VALID = 8;
    public static final int DNSKEY_MISSING = 9;
    public static final int RRSIGS_MISSING = 10;
    public static final int NO_ZONE_KEY_BIT_SET = 11;
    public static final int NSEC_MISSING = 12;
    public static final int CACHED_ERROR = 13;
    public static final int NOT_READY = 14;
    public static final int BLOCKED = 15;
    public static final int CENSORED = 16;
    public static final int FILTERED = 17;
    public static final int PROHIBITED = 18;
    public static final int STALE_NXDOMAIN_ANSWER = 19;
    public static final int NOT_AUTHORITATIVE = 20;
    public static final int NOT_SUPPORTED = 21;
    public static final int NO_REACHABLE_AUTHORITY = 22;
    public static final int NETWORK_ERROR = 23;
    public static final int INVALID_DATA = 24;
    private int errorCode;
    private String text;
    private static final Mnemonic codes = new Mnemonic("EDNS Extended Error Codes", 1);

    ExtendedErrorCodeOption() {
        super(15);
    }

    public ExtendedErrorCodeOption(int errorCode, String text) {
        super(15);
        this.errorCode = errorCode;
        this.text = text;
    }

    public ExtendedErrorCodeOption(int errorCode) {
        this(errorCode, null);
    }

    @Override
    void optionFromWire(DNSInput in) throws IOException {
        this.errorCode = in.readU16();
        if (in.remaining() > 0) {
            byte[] data = in.readByteArray();
            int len = data.length;
            if (data[data.length - 1] == 0) {
                --len;
            }
            this.text = new String(data, 0, len, StandardCharsets.UTF_8);
        }
    }

    @Override
    void optionToWire(DNSOutput out) {
        out.writeU16(this.errorCode);
        if (this.text != null && this.text.length() > 0) {
            out.writeByteArray(this.text.getBytes(StandardCharsets.UTF_8));
        }
    }

    @Override
    String optionToString() {
        if (this.text == null) {
            return codes.getText(this.errorCode);
        }
        return codes.getText(this.errorCode) + ": " + this.text;
    }

    @Generated
    public int getErrorCode() {
        return this.errorCode;
    }

    @Generated
    public String getText() {
        return this.text;
    }

    static {
        codes.setMaximum(65535);
        codes.setPrefix("EDE");
        codes.add(0, "Other");
        codes.add(1, "Unsupported DNSKEY Algorithm");
        codes.add(2, "Unsupported DS Digest Type");
        codes.add(3, "Stale Answer");
        codes.add(4, "Forged Answer");
        codes.add(5, "DNSSEC Indeterminate");
        codes.add(6, "DNSSEC Bogus");
        codes.add(7, "Signature Expired");
        codes.add(8, "Signature Not Yet Valid");
        codes.add(9, "DNSKEY Missing");
        codes.add(10, "RRSIGs Missing");
        codes.add(11, "No Zone Key Bit Set");
        codes.add(12, "NSEC Missing");
        codes.add(13, "Cached Error");
        codes.add(14, "Not Ready");
        codes.add(15, "Blocked");
        codes.add(16, "Censored");
        codes.add(17, "Filtered");
        codes.add(18, "Prohibited");
        codes.add(19, "Stale NXDOMAIN Answer");
        codes.add(20, "Not Authoritative");
        codes.add(21, "Not Supported");
        codes.add(22, "No Reachable Authority");
        codes.add(23, "Network Error");
        codes.add(24, "Invalid Data");
    }
}

