/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.xbill.DNS.config;

import java.net.Inet4Address;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.StringTokenizer;
import java.util.stream.Collectors;
import org.apache.hadoop.shaded.org.xbill.DNS.Name;
import org.apache.hadoop.shaded.org.xbill.DNS.TextParseException;
import org.apache.hadoop.shaded.org.xbill.DNS.config.ResolverConfigProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseResolverConfigProvider
implements ResolverConfigProvider {
    private static final boolean ipv4only = Boolean.getBoolean("java.net.preferIPv4Stack");
    private static final boolean ipv6first = Boolean.getBoolean("java.net.preferIPv6Addresses");
    private final List<InetSocketAddress> nameservers = new ArrayList<InetSocketAddress>(3);
    final Logger log = LoggerFactory.getLogger(this.getClass());
    List<Name> searchlist = new ArrayList<Name>(1);

    protected void parseSearchPathList(String search, String delimiter) {
        if (search != null) {
            StringTokenizer st = new StringTokenizer(search, delimiter);
            while (st.hasMoreTokens()) {
                this.addSearchPath(st.nextToken());
            }
        }
    }

    protected void addSearchPath(String searchPath) {
        if (searchPath == null || searchPath.isEmpty()) {
            return;
        }
        try {
            Name n = Name.fromString(searchPath, Name.root);
            if (!this.searchlist.contains(n)) {
                this.searchlist.add(n);
                this.log.debug("Added {} to search paths", (Object)n);
            }
        }
        catch (TextParseException e) {
            this.log.warn("Could not parse search path {} as a dns name, ignoring", (Object)searchPath);
        }
    }

    protected void addNameserver(InetSocketAddress server) {
        if (!this.nameservers.contains(server)) {
            this.nameservers.add(server);
            this.log.debug("Added {} to nameservers", (Object)server);
        }
    }

    protected int parseNdots(String token) {
        if (token != null && !token.isEmpty()) {
            try {
                int ndots = Integer.parseInt(token);
                if (ndots >= 0) {
                    if (ndots > 15) {
                        ndots = 15;
                    }
                    return ndots;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return 1;
    }

    @Override
    public final List<InetSocketAddress> servers() {
        if (ipv6first) {
            return this.nameservers.stream().sorted((a, b) -> Integer.compare(b.getAddress().getAddress().length, a.getAddress().getAddress().length)).collect(Collectors.toList());
        }
        if (ipv4only) {
            return this.nameservers.stream().filter(isa -> isa.getAddress() instanceof Inet4Address).collect(Collectors.toList());
        }
        return Collections.unmodifiableList(this.nameservers);
    }

    @Override
    public final List<Name> searchPaths() {
        return Collections.unmodifiableList(this.searchlist);
    }
}

