/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.security;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.security.GroupMappingServiceProvider;
import org.apache.hadoop.security.ShellBasedUnixGroupsMapping;
import org.apache.hadoop.util.NativeCodeLoader;

public class JniBasedUnixGroupsMapping
implements GroupMappingServiceProvider {
    private static final Log LOG = LogFactory.getLog(ShellBasedUnixGroupsMapping.class);

    native String[] getGroupForUser(String var1);

    @Override
    public List<String> getGroups(String user) throws IOException {
        String[] groups = new String[]{};
        try {
            groups = this.getGroupForUser(user);
        }
        catch (Exception e) {
            LOG.warn((Object)("Got exception while trying to obtain the groups for user " + user));
        }
        return Arrays.asList(groups);
    }

    static {
        if (!NativeCodeLoader.isNativeCodeLoaded()) {
            throw new RuntimeException("Bailing out since native library couldn't be loaded");
        }
        LOG.info((Object)"Using JniBasedUnixGroupsMapping for Group resolution");
    }
}

