/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.shell;

import java.io.File;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.fs.ChecksumFileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.shell.CommandFactory;
import org.apache.hadoop.fs.shell.CommandFormat;
import org.apache.hadoop.fs.shell.CommandWithDestination;
import org.apache.hadoop.fs.shell.FsCommand;
import org.apache.hadoop.fs.shell.PathData;

@InterfaceAudience.Private
@InterfaceStability.Evolving
class CopyCommands {
    CopyCommands() {
    }

    public static void registerCommands(CommandFactory factory) {
        factory.addClass(Merge.class, "-getmerge");
        factory.addClass(Cp.class, "-cp");
        factory.addClass(CopyFromLocal.class, "-copyFromLocal");
        factory.addClass(CopyToLocal.class, "-copyToLocal");
        factory.addClass(Get.class, "-get");
        factory.addClass(Put.class, "-put");
    }

    public static class CopyToLocal
    extends Get {
        public static final String NAME = "copyToLocal";
        public static final String USAGE = "[-ignoreCrc] [-crc] <src> ... <localdst>";
        public static final String DESCRIPTION = "Identical to the -get command.";
    }

    public static class CopyFromLocal
    extends Put {
        public static final String NAME = "copyFromLocal";
        public static final String USAGE = "<localsrc> ... <dst>";
        public static final String DESCRIPTION = "Identical to the -put command.";
    }

    public static class Put
    extends CommandWithDestination {
        public static final String NAME = "put";
        public static final String USAGE = "<localsrc> ... <dst>";
        public static final String DESCRIPTION = "Copy files from the local file system\ninto fs.";

        @Override
        protected void processOptions(LinkedList<String> args) throws IOException {
            CommandFormat cf = new CommandFormat(1, Integer.MAX_VALUE, "f");
            cf.parse(args);
            this.setOverwrite(cf.getOpt("f"));
            this.getRemoteDestination(args);
            this.setRecursive(true);
        }

        @Override
        protected List<PathData> expandArgument(String arg) throws IOException {
            LinkedList<PathData> items = new LinkedList<PathData>();
            items.add(new PathData(new File(arg), this.getConf()));
            return items;
        }

        @Override
        protected void processArguments(LinkedList<PathData> args) throws IOException {
            if (args.size() == 1 && args.get(0).toString().equals("-")) {
                this.copyStreamToTarget(System.in, this.getTargetPath(args.get(0)));
                return;
            }
            super.processArguments(args);
        }
    }

    public static class Get
    extends CommandWithDestination {
        public static final String NAME = "get";
        public static final String USAGE = "[-ignoreCrc] [-crc] <src> ... <localdst>";
        public static final String DESCRIPTION = "Copy files that match the file pattern <src>\nto the local name.  <src> is kept.  When copying multiple,\nfiles, the destination must be a directory.";
        private boolean copyCrc;
        private boolean verifyChecksum;

        @Override
        protected void processOptions(LinkedList<String> args) throws IOException {
            CommandFormat cf = new CommandFormat(1, Integer.MAX_VALUE, "crc", "ignoreCrc");
            cf.parse(args);
            this.copyCrc = cf.getOpt("crc");
            this.verifyChecksum = !cf.getOpt("ignoreCrc");
            this.setRecursive(true);
            this.getLocalDestination(args);
        }

        @Override
        protected void copyFileToTarget(PathData src, PathData target) throws IOException {
            src.fs.setVerifyChecksum(this.verifyChecksum);
            if (this.copyCrc && !(src.fs instanceof ChecksumFileSystem)) {
                this.displayWarning(src.fs + ": Does not support checksums");
                this.copyCrc = false;
            }
            super.copyFileToTarget(src, target);
            if (this.copyCrc) {
                super.copyFileToTarget(src.getChecksumFile(), target.getChecksumFile());
            }
        }
    }

    static class Cp
    extends CommandWithDestination {
        public static final String NAME = "cp";
        public static final String USAGE = "<src> ... <dst>";
        public static final String DESCRIPTION = "Copy files that match the file pattern <src> to a\ndestination.  When copying multiple files, the destination\nmust be a directory.";

        Cp() {
        }

        @Override
        protected void processOptions(LinkedList<String> args) throws IOException {
            CommandFormat cf = new CommandFormat(2, Integer.MAX_VALUE, "f");
            cf.parse(args);
            this.setOverwrite(cf.getOpt("f"));
            this.setRecursive(true);
            this.getRemoteDestination(args);
        }
    }

    public static class Merge
    extends FsCommand {
        public static final String NAME = "getmerge";
        public static final String USAGE = "[-nl] <src> <localdst>";
        public static final String DESCRIPTION = "Get all the files in the directories that\nmatch the source file pattern and merge and sort them to only\none file on local fs. <src> is kept.\n  -nl   Add a newline character at the end of each file.";
        protected PathData dst = null;
        protected String delimiter = null;

        @Override
        protected void processOptions(LinkedList<String> args) throws IOException {
            CommandFormat cf = new CommandFormat(2, 3, "nl");
            cf.parse(args);
            this.delimiter = cf.getOpt("nl") ? "\n" : null;
            this.dst = new PathData(new File(args.removeLast()), this.getConf());
        }

        @Override
        protected void processPath(PathData src) throws IOException {
            FileUtil.copyMerge(src.fs, src.path, this.dst.fs, this.dst.path, false, this.getConf(), this.delimiter);
        }
    }
}

