/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.shell;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.shell.PathExceptions;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class PathData
implements Comparable<PathData> {
    protected final URI uri;
    public final FileSystem fs;
    public final Path path;
    public FileStatus stat;
    public boolean exists;

    public PathData(String pathString, Configuration conf) throws IOException {
        this(FileSystem.get(PathData.stringToUri(pathString), conf), pathString);
    }

    public PathData(File localPath, Configuration conf) throws IOException {
        this(FileSystem.getLocal(conf), localPath.toString());
    }

    private PathData(FileSystem fs, String pathString) throws IOException {
        this(fs, pathString, PathData.lookupStat(fs, pathString, true));
    }

    private PathData(FileSystem fs, String pathString, FileStatus stat) throws IOException {
        this.fs = fs;
        this.uri = PathData.stringToUri(pathString);
        this.path = fs.makeQualified(new Path(this.uri));
        this.setStat(stat);
    }

    private static FileStatus lookupStat(FileSystem fs, String pathString, boolean ignoreFNF) throws IOException {
        FileStatus status;
        block2: {
            status = null;
            try {
                status = fs.getFileStatus(new Path(pathString));
            }
            catch (FileNotFoundException e) {
                if (ignoreFNF) break block2;
                throw new PathExceptions.PathNotFoundException(pathString);
            }
        }
        return status;
    }

    private void setStat(FileStatus stat) {
        this.stat = stat;
        this.exists = stat != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileStatus refreshStatus() throws IOException {
        FileStatus status = null;
        try {
            status = PathData.lookupStat(this.fs, this.toString(), false);
            this.setStat(status);
        }
        catch (Throwable throwable) {
            this.setStat(status);
            throw throwable;
        }
        return status;
    }

    private void checkIfExists(FileTypeRequirement typeRequirement) throws PathExceptions.PathIOException {
        if (!this.exists) {
            throw new PathExceptions.PathNotFoundException(this.toString());
        }
        if (typeRequirement == FileTypeRequirement.SHOULD_BE_DIRECTORY && !this.stat.isDirectory()) {
            throw new PathExceptions.PathIsNotDirectoryException(this.toString());
        }
        if (typeRequirement == FileTypeRequirement.SHOULD_NOT_BE_DIRECTORY && this.stat.isDirectory()) {
            throw new PathExceptions.PathIsDirectoryException(this.toString());
        }
    }

    public PathData suffix(String extension) throws IOException {
        return new PathData(this.fs, this + extension);
    }

    public boolean parentExists() throws IOException {
        return this.representsDirectory() ? this.fs.exists(this.path) : this.fs.exists(this.path.getParent());
    }

    public boolean representsDirectory() {
        String uriPath = this.uri.getPath();
        String name = uriPath.substring(uriPath.lastIndexOf("/") + 1);
        return name.isEmpty() || name.equals(".") || name.equals("..");
    }

    public PathData[] getDirectoryContents() throws IOException {
        this.checkIfExists(FileTypeRequirement.SHOULD_BE_DIRECTORY);
        FileStatus[] stats = this.fs.listStatus(this.path);
        Object[] items = new PathData[stats.length];
        for (int i = 0; i < stats.length; ++i) {
            String child = this.getStringForChildPath(stats[i].getPath());
            items[i] = new PathData(this.fs, child, stats[i]);
        }
        Arrays.sort(items);
        return items;
    }

    public PathData getPathDataForChild(PathData child) throws IOException {
        this.checkIfExists(FileTypeRequirement.SHOULD_BE_DIRECTORY);
        return new PathData(this.fs, this.getStringForChildPath(child.path));
    }

    private String getStringForChildPath(Path childPath) {
        String basename = childPath.getName();
        if (".".equals(this.toString())) {
            return basename;
        }
        String separator = this.uri.getPath().endsWith("/") ? "" : "/";
        return PathData.uriToString(this.uri) + separator + basename;
    }

    public static PathData[] expandAsGlob(String pattern, Configuration conf) throws IOException {
        Path globPath = new Path(pattern);
        FileSystem fs = globPath.getFileSystem(conf);
        FileStatus[] stats = fs.globStatus(globPath);
        Object[] items = null;
        if (stats == null) {
            pattern = pattern.replaceAll("\\\\(.)", "$1");
            items = new PathData[]{new PathData(fs, pattern, null)};
        } else {
            URI globUri = globPath.toUri();
            PathType globType = globUri.getScheme() != null ? PathType.HAS_SCHEME : (new File(globUri.getPath()).isAbsolute() ? PathType.SCHEMELESS_ABSOLUTE : PathType.RELATIVE);
            items = new PathData[stats.length];
            int i = 0;
            for (FileStatus stat : stats) {
                URI matchUri = stat.getPath().toUri();
                String globMatch = null;
                switch (globType) {
                    case HAS_SCHEME: {
                        if (globUri.getAuthority() == null) {
                            matchUri = PathData.removeAuthority(matchUri);
                        }
                        globMatch = PathData.uriToString(matchUri);
                        break;
                    }
                    case SCHEMELESS_ABSOLUTE: {
                        globMatch = matchUri.getPath();
                        break;
                    }
                    case RELATIVE: {
                        URI cwdUri = fs.getWorkingDirectory().toUri();
                        globMatch = PathData.relativize(cwdUri, matchUri, stat.isDirectory());
                    }
                }
                items[i++] = new PathData(fs, globMatch, stat);
            }
        }
        Arrays.sort(items);
        return items;
    }

    private static URI removeAuthority(URI uri) {
        try {
            uri = new URI(uri.getScheme(), "", uri.getPath(), uri.getQuery(), uri.getFragment());
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e.getLocalizedMessage());
        }
        return uri;
    }

    private static String relativize(URI cwdUri, URI srcUri, boolean isDir) {
        String uriPath = srcUri.getPath();
        String cwdPath = cwdUri.getPath();
        if (cwdPath.equals(uriPath)) {
            return ".";
        }
        int lastSep = PathData.findLongestDirPrefix(cwdPath, uriPath, isDir);
        StringBuilder relPath = new StringBuilder();
        if (lastSep < uriPath.length()) {
            relPath.append(uriPath.substring(lastSep + 1));
        }
        if (lastSep < cwdPath.length()) {
            while (lastSep != -1) {
                if (relPath.length() != 0) {
                    relPath.insert(0, "/");
                }
                relPath.insert(0, "..");
                lastSep = cwdPath.indexOf("/", lastSep + 1);
            }
        }
        return relPath.toString();
    }

    private static int findLongestDirPrefix(String cwd, String path, boolean isDir) {
        if (!cwd.endsWith("/")) {
            cwd = cwd + "/";
        }
        if (isDir && !path.endsWith("/")) {
            path = path + "/";
        }
        int len = Math.min(cwd.length(), path.length());
        int lastSep = -1;
        for (int i = 0; i < len && cwd.charAt(i) == path.charAt(i); ++i) {
            if (cwd.charAt(i) != '/') continue;
            lastSep = i;
        }
        return lastSep;
    }

    public String toString() {
        return PathData.uriToString(this.uri);
    }

    private static String uriToString(URI uri) {
        String scheme = uri.getScheme();
        String ssp = uri.getSchemeSpecificPart();
        return scheme != null ? scheme + ":" + ssp : ssp;
    }

    public File toFile() {
        if (!(this.fs instanceof LocalFileSystem)) {
            throw new IllegalArgumentException("Not a local path: " + this.path);
        }
        return ((LocalFileSystem)this.fs).pathToFile(this.path);
    }

    private static URI stringToUri(String pathString) {
        String scheme = null;
        String authority = null;
        int start = 0;
        int colon = pathString.indexOf(58);
        int slash = pathString.indexOf(47);
        if (colon > 0 && slash == colon + 1) {
            scheme = pathString.substring(0, colon);
            start = colon + 1;
        }
        if (pathString.startsWith("//", start) && pathString.length() - start > 2) {
            int nextSlash = pathString.indexOf(47, start += 2);
            int authEnd = nextSlash > 0 ? nextSlash : pathString.length();
            authority = pathString.substring(start, authEnd);
            start = authEnd;
        }
        String path = pathString.substring(start, pathString.length());
        try {
            return new URI(scheme, authority, path, null, null);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
    }

    @Override
    public int compareTo(PathData o) {
        return this.path.compareTo(o.path);
    }

    public boolean equals(Object o) {
        return o != null && o instanceof PathData && this.path.equals(((PathData)o).path);
    }

    public int hashCode() {
        return this.path.hashCode();
    }

    protected static enum PathType {
        HAS_SCHEME,
        SCHEMELESS_ABSOLUTE,
        RELATIVE;

    }

    protected static enum FileTypeRequirement {
        SHOULD_NOT_BE_DIRECTORY,
        SHOULD_BE_DIRECTORY;

    }
}

