/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.util;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;

@InterfaceAudience.LimitedPrivate(value={"HDFS", "MapReduce"})
@InterfaceStability.Unstable
public final class ExitUtil {
    private static final Log LOG = LogFactory.getLog((String)ExitUtil.class.getName());
    private static volatile boolean systemExitDisabled = false;
    private static volatile boolean terminateCalled = false;

    public static void disableSystemExit() {
        systemExitDisabled = true;
    }

    public static boolean terminateCalled() {
        return terminateCalled;
    }

    public static void terminate(int status, String msg) throws ExitException {
        LOG.info((Object)("Exiting with status " + status));
        terminateCalled = true;
        if (systemExitDisabled) {
            throw new ExitException(status, msg);
        }
        System.exit(status);
    }

    public static void terminate(int status) throws ExitException {
        ExitUtil.terminate(status, "ExitException");
    }

    public static class ExitException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;
        public final int status;

        public ExitException(int status, String msg) {
            super(msg);
            this.status = status;
        }
    }
}

