/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.util;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.util.StringUtils;

@InterfaceAudience.LimitedPrivate(value={"HDFS", "MapReduce"})
@InterfaceStability.Unstable
public final class ExitUtil {
    private static final Log LOG = LogFactory.getLog((String)ExitUtil.class.getName());
    private static volatile boolean systemExitDisabled = false;
    private static volatile ExitException firstExitException;

    public static void disableSystemExit() {
        systemExitDisabled = true;
    }

    public static boolean terminateCalled() {
        return firstExitException != null;
    }

    public static ExitException getFirstExitException() {
        return firstExitException;
    }

    public static void resetFirstExitException() {
        firstExitException = null;
    }

    public static void clearTerminateCalled() {
        ExitUtil.resetFirstExitException();
    }

    public static void terminate(int status, String msg) throws ExitException {
        LOG.info((Object)("Exiting with status " + status));
        if (systemExitDisabled) {
            ExitException ee = new ExitException(status, msg);
            LOG.fatal((Object)"Terminate called", (Throwable)ee);
            if (null == firstExitException) {
                firstExitException = ee;
            }
            throw ee;
        }
        System.exit(status);
    }

    public static void terminate(int status, Throwable t) throws ExitException {
        ExitUtil.terminate(status, StringUtils.stringifyException(t));
    }

    public static void terminate(int status) throws ExitException {
        ExitUtil.terminate(status, "ExitException");
    }

    public static class ExitException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;
        public final int status;

        public ExitException(int status, String msg) {
            super(msg);
            this.status = status;
        }
    }
}

