/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.io.nativeio;

import java.io.FileDescriptor;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.nativeio.NativeIOException;
import org.apache.hadoop.util.NativeCodeLoader;

public class NativeIO {
    public static final int O_RDONLY = 0;
    public static final int O_WRONLY = 1;
    public static final int O_RDWR = 2;
    public static final int O_CREAT = 64;
    public static final int O_EXCL = 128;
    public static final int O_NOCTTY = 256;
    public static final int O_TRUNC = 512;
    public static final int O_APPEND = 1024;
    public static final int O_NONBLOCK = 2048;
    public static final int O_SYNC = 4096;
    public static final int O_ASYNC = 8192;
    public static final int O_FSYNC = 4096;
    public static final int O_NDELAY = 2048;
    public static final int POSIX_FADV_NORMAL = 0;
    public static final int POSIX_FADV_RANDOM = 1;
    public static final int POSIX_FADV_SEQUENTIAL = 2;
    public static final int POSIX_FADV_WILLNEED = 3;
    public static final int POSIX_FADV_DONTNEED = 4;
    public static final int POSIX_FADV_NOREUSE = 5;
    public static final int SYNC_FILE_RANGE_WAIT_BEFORE = 1;
    public static final int SYNC_FILE_RANGE_WRITE = 2;
    public static final int SYNC_FILE_RANGE_WAIT_AFTER = 4;
    private static final Log LOG = LogFactory.getLog(NativeIO.class);
    private static boolean nativeLoaded = false;
    private static boolean workaroundNonThreadSafePasswdCalls = false;
    private static boolean fadvisePossible = true;
    private static boolean syncFileRangePossible = true;
    static final String WORKAROUND_NON_THREADSAFE_CALLS_KEY = "hadoop.workaround.non.threadsafe.getpwuid";
    static final boolean WORKAROUND_NON_THREADSAFE_CALLS_DEFAULT = false;

    public static boolean isAvailable() {
        return NativeCodeLoader.isNativeCodeLoaded() && nativeLoaded;
    }

    public static native FileDescriptor open(String var0, int var1, int var2) throws IOException;

    public static native Stat fstat(FileDescriptor var0) throws IOException;

    public static native void chmod(String var0, int var1) throws IOException;

    static native void posix_fadvise(FileDescriptor var0, long var1, long var3, int var5) throws NativeIOException;

    static native void sync_file_range(FileDescriptor var0, long var1, long var3, int var5) throws NativeIOException;

    private static native void initNative();

    public static void posixFadviseIfPossible(FileDescriptor fd, long offset, long len, int flags) throws NativeIOException {
        if (nativeLoaded && fadvisePossible) {
            try {
                NativeIO.posix_fadvise(fd, offset, len, flags);
            }
            catch (UnsupportedOperationException uoe) {
                fadvisePossible = false;
            }
            catch (UnsatisfiedLinkError ule) {
                fadvisePossible = false;
            }
        }
    }

    public static void syncFileRangeIfPossible(FileDescriptor fd, long offset, long nbytes, int flags) throws NativeIOException {
        if (nativeLoaded && syncFileRangePossible) {
            try {
                NativeIO.sync_file_range(fd, offset, nbytes, flags);
            }
            catch (UnsupportedOperationException uoe) {
                syncFileRangePossible = false;
            }
            catch (UnsatisfiedLinkError ule) {
                syncFileRangePossible = false;
            }
        }
    }

    static {
        if (NativeCodeLoader.isNativeCodeLoaded()) {
            try {
                Configuration conf = new Configuration();
                workaroundNonThreadSafePasswdCalls = conf.getBoolean(WORKAROUND_NON_THREADSAFE_CALLS_KEY, false);
                NativeIO.initNative();
                nativeLoaded = true;
            }
            catch (Throwable t) {
                LOG.error((Object)"Unable to initialize NativeIO libraries", t);
            }
        }
    }

    public static class Stat {
        private String owner;
        private String group;
        private int mode;
        public static final int S_IFMT = 61440;
        public static final int S_IFIFO = 4096;
        public static final int S_IFCHR = 8192;
        public static final int S_IFDIR = 16384;
        public static final int S_IFBLK = 24576;
        public static final int S_IFREG = 32768;
        public static final int S_IFLNK = 40960;
        public static final int S_IFSOCK = 49152;
        public static final int S_IFWHT = 57344;
        public static final int S_ISUID = 2048;
        public static final int S_ISGID = 1024;
        public static final int S_ISVTX = 512;
        public static final int S_IRUSR = 256;
        public static final int S_IWUSR = 128;
        public static final int S_IXUSR = 64;

        Stat(String owner, String group, int mode) {
            this.owner = owner;
            this.group = group;
            this.mode = mode;
        }

        public String toString() {
            return "Stat(owner='" + this.owner + "', group='" + this.group + "'" + ", mode=" + this.mode + ")";
        }

        public String getOwner() {
            return this.owner;
        }

        public String getGroup() {
            return this.group;
        }

        public int getMode() {
            return this.mode;
        }
    }
}

