/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.shell;

import java.io.IOException;
import java.util.LinkedList;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.fs.shell.CommandFactory;
import org.apache.hadoop.fs.shell.CommandFormat;
import org.apache.hadoop.fs.shell.CommandWithDestination;
import org.apache.hadoop.fs.shell.CopyCommands;
import org.apache.hadoop.fs.shell.FsCommand;
import org.apache.hadoop.fs.shell.PathData;
import org.apache.hadoop.fs.shell.PathExceptions;

@InterfaceAudience.Private
@InterfaceStability.Evolving
class MoveCommands {
    MoveCommands() {
    }

    public static void registerCommands(CommandFactory factory) {
        factory.addClass(MoveFromLocal.class, "-moveFromLocal");
        factory.addClass(MoveToLocal.class, "-moveToLocal");
        factory.addClass(Rename.class, "-mv");
    }

    public static class Rename
    extends CommandWithDestination {
        public static final String NAME = "mv";
        public static final String USAGE = "<src> ... <dst>";
        public static final String DESCRIPTION = "Move files that match the specified file pattern <src>\nto a destination <dst>.  When moving multiple files, the\ndestination must be a directory.";

        @Override
        protected void processOptions(LinkedList<String> args) throws IOException {
            CommandFormat cf = new CommandFormat(2, Integer.MAX_VALUE, new String[0]);
            cf.parse(args);
            this.getRemoteDestination(args);
        }

        @Override
        protected void processPath(PathData src, PathData target) throws IOException {
            if (!src.fs.getUri().equals(target.fs.getUri())) {
                throw new PathExceptions.PathIOException(src.toString(), "Does not match target filesystem");
            }
            if (!target.fs.rename(src.path, target.path)) {
                throw new PathExceptions.PathIOException(src.toString());
            }
        }
    }

    public static class MoveToLocal
    extends FsCommand {
        public static final String NAME = "moveToLocal";
        public static final String USAGE = "<src> <localdst>";
        public static final String DESCRIPTION = "Not implemented yet";

        @Override
        protected void processOptions(LinkedList<String> args) throws IOException {
            throw new IOException("Option '-moveToLocal' is not implemented yet.");
        }
    }

    public static class MoveFromLocal
    extends CopyCommands.CopyFromLocal {
        public static final String NAME = "moveFromLocal";
        public static final String USAGE = "<localsrc> ... <dst>";
        public static final String DESCRIPTION = "Same as -put, except that the source is\ndeleted after it's copied.";

        @Override
        protected void processPath(PathData src, PathData target) throws IOException {
            target.fs.moveFromLocalFile(src.path, target.path);
        }
    }
}

