/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ipc;

import com.google.common.annotations.VisibleForTesting;
import com.google.protobuf.BlockingService;
import com.google.protobuf.Descriptors;
import com.google.protobuf.Message;
import com.google.protobuf.ServiceException;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.InetSocketAddress;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.net.SocketFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.DataOutputOutputStream;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.ipc.Client;
import org.apache.hadoop.ipc.ClientCache;
import org.apache.hadoop.ipc.ProtocolMetaInfoPB;
import org.apache.hadoop.ipc.ProtocolProxy;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.ipc.RpcEngine;
import org.apache.hadoop.ipc.RpcInvocationHandler;
import org.apache.hadoop.ipc.RpcServerException;
import org.apache.hadoop.ipc.protobuf.HadoopRpcProtos;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.SecretManager;
import org.apache.hadoop.security.token.TokenIdentifier;
import org.apache.hadoop.util.ProtoUtil;

@InterfaceStability.Evolving
public class ProtobufRpcEngine
implements RpcEngine {
    private static final Log LOG = LogFactory.getLog(ProtobufRpcEngine.class);
    private static final ClientCache CLIENTS;

    @Override
    public <T> ProtocolProxy<T> getProxy(Class<T> protocol, long clientVersion, InetSocketAddress addr, UserGroupInformation ticket, Configuration conf, SocketFactory factory, int rpcTimeout) throws IOException {
        return new ProtocolProxy<Object>(protocol, Proxy.newProxyInstance(protocol.getClassLoader(), new Class[]{protocol}, (InvocationHandler)new Invoker(protocol, addr, ticket, conf, factory, rpcTimeout)), false);
    }

    @Override
    public ProtocolProxy<ProtocolMetaInfoPB> getProtocolMetaInfoProxy(Client.ConnectionId connId, Configuration conf, SocketFactory factory) throws IOException {
        Class<ProtocolMetaInfoPB> protocol = ProtocolMetaInfoPB.class;
        return new ProtocolProxy<ProtocolMetaInfoPB>(protocol, (ProtocolMetaInfoPB)Proxy.newProxyInstance(protocol.getClassLoader(), new Class[]{protocol}, (InvocationHandler)new Invoker(protocol, connId, conf, factory)), false);
    }

    @Override
    public Object[] call(Method method, Object[][] params, InetSocketAddress[] addrs, UserGroupInformation ticket, Configuration conf) {
        throw new UnsupportedOperationException();
    }

    @VisibleForTesting
    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    static Client getClient(Configuration conf) {
        return CLIENTS.getClient(conf, SocketFactory.getDefault(), RpcResponseWritable.class);
    }

    @Override
    public RPC.Server getServer(Class<?> protocol, Object protocolImpl, String bindAddress, int port, int numHandlers, int numReaders, int queueSizePerHandler, boolean verbose, Configuration conf, SecretManager<? extends TokenIdentifier> secretManager, String portRangeConfig) throws IOException {
        return new Server(protocol, protocolImpl, conf, bindAddress, port, numHandlers, numReaders, queueSizePerHandler, verbose, secretManager, portRangeConfig);
    }

    static {
        org.apache.hadoop.ipc.Server.registerProtocolEngine(RPC.RpcKind.RPC_PROTOCOL_BUFFER, RpcRequestWritable.class, new Server.ProtoBufRpcInvoker());
        CLIENTS = new ClientCache();
    }

    public static class Server
    extends RPC.Server {
        public Server(Class<?> protocolClass, Object protocolImpl, Configuration conf, String bindAddress, int port, int numHandlers, int numReaders, int queueSizePerHandler, boolean verbose, SecretManager<? extends TokenIdentifier> secretManager, String portRangeConfig) throws IOException {
            super(bindAddress, port, null, numHandlers, numReaders, queueSizePerHandler, conf, Server.classNameBase(protocolImpl.getClass().getName()), secretManager, portRangeConfig);
            this.verbose = verbose;
            this.registerProtocolAndImpl(RPC.RpcKind.RPC_PROTOCOL_BUFFER, protocolClass, protocolImpl);
        }

        static class ProtoBufRpcInvoker
        implements RPC.RpcInvoker {
            ProtoBufRpcInvoker() {
            }

            private static RPC.Server.ProtoClassProtoImpl getProtocolImpl(RPC.Server server, String protoName, long version) throws IOException {
                RPC.Server.ProtoNameVer pv = new RPC.Server.ProtoNameVer(protoName, version);
                RPC.Server.ProtoClassProtoImpl impl = server.getProtocolImplMap(RPC.RpcKind.RPC_PROTOCOL_BUFFER).get(pv);
                if (impl == null) {
                    RPC.Server.VerProtocolImpl highest = server.getHighestSupportedProtocol(RPC.RpcKind.RPC_PROTOCOL_BUFFER, protoName);
                    if (highest == null) {
                        throw new IOException("Unknown protocol: " + protoName);
                    }
                    throw new RPC.VersionMismatch(protoName, version, highest.version);
                }
                return impl;
            }

            @Override
            public Writable call(RPC.Server server, String protocol, Writable writableRequest, long receiveTime) throws Exception {
                Message result;
                RpcRequestWritable request = (RpcRequestWritable)writableRequest;
                HadoopRpcProtos.HadoopRpcRequestProto rpcRequest = request.message;
                String methodName = rpcRequest.getMethodName();
                String protoName = rpcRequest.getDeclaringClassProtocolName();
                long clientVersion = rpcRequest.getClientProtocolVersion();
                if (server.verbose) {
                    org.apache.hadoop.ipc.Server.LOG.info((Object)("Call: protocol=" + protocol + ", method=" + methodName));
                }
                RPC.Server.ProtoClassProtoImpl protocolImpl = ProtoBufRpcInvoker.getProtocolImpl(server, protoName, clientVersion);
                BlockingService service = (BlockingService)protocolImpl.protocolImpl;
                Descriptors.MethodDescriptor methodDescriptor = service.getDescriptorForType().findMethodByName(methodName);
                if (methodDescriptor == null) {
                    String msg = "Unknown method " + methodName + " called on " + protocol + " protocol.";
                    org.apache.hadoop.ipc.Server.LOG.warn((Object)msg);
                    throw new RpcServerException(msg);
                }
                Message prototype = service.getRequestPrototype(methodDescriptor);
                Message param = prototype.newBuilderForType().mergeFrom(rpcRequest.getRequest()).build();
                try {
                    long startTime = System.currentTimeMillis();
                    server.rpcDetailedMetrics.init(protocolImpl.protocolClass);
                    result = service.callBlockingMethod(methodDescriptor, null, param);
                    int processingTime = (int)(System.currentTimeMillis() - startTime);
                    int qTime = (int)(startTime - receiveTime);
                    if (org.apache.hadoop.ipc.Server.LOG.isDebugEnabled()) {
                        org.apache.hadoop.ipc.Server.LOG.info((Object)("Served: " + methodName + " queueTime= " + qTime + " procesingTime= " + processingTime));
                    }
                    server.rpcMetrics.addRpcQueueTime(qTime);
                    server.rpcMetrics.addRpcProcessingTime(processingTime);
                    server.rpcDetailedMetrics.addProcessingTime(methodName, processingTime);
                }
                catch (ServiceException e) {
                    throw (Exception)e.getCause();
                }
                catch (Exception e) {
                    throw e;
                }
                return new RpcResponseWritable(result);
            }
        }
    }

    private static class RpcResponseWritable
    implements Writable {
        byte[] responseMessage;

        public RpcResponseWritable() {
        }

        public RpcResponseWritable(Message message) {
            this.responseMessage = message.toByteArray();
        }

        @Override
        public void write(DataOutput out) throws IOException {
            out.writeInt(this.responseMessage.length);
            out.write(this.responseMessage);
        }

        @Override
        public void readFields(DataInput in) throws IOException {
            int length = in.readInt();
            byte[] bytes = new byte[length];
            in.readFully(bytes);
            this.responseMessage = bytes;
        }
    }

    private static class RpcRequestWritable
    implements Writable {
        HadoopRpcProtos.HadoopRpcRequestProto message;

        public RpcRequestWritable() {
        }

        RpcRequestWritable(HadoopRpcProtos.HadoopRpcRequestProto message) {
            this.message = message;
        }

        @Override
        public void write(DataOutput out) throws IOException {
            this.message.writeDelimitedTo(DataOutputOutputStream.constructOutputStream(out));
        }

        @Override
        public void readFields(DataInput in) throws IOException {
            int length = ProtoUtil.readRawVarint32(in);
            byte[] bytes = new byte[length];
            in.readFully(bytes);
            this.message = HadoopRpcProtos.HadoopRpcRequestProto.parseFrom(bytes);
        }

        public String toString() {
            return this.message.getDeclaringClassProtocolName() + "." + this.message.getMethodName();
        }
    }

    private static class Invoker
    implements RpcInvocationHandler {
        private final Map<String, Message> returnTypes = new ConcurrentHashMap<String, Message>();
        private boolean isClosed = false;
        private final Client.ConnectionId remoteId;
        private final Client client;
        private final long clientProtocolVersion;
        private final String protocolName;

        public Invoker(Class<?> protocol, InetSocketAddress addr, UserGroupInformation ticket, Configuration conf, SocketFactory factory, int rpcTimeout) throws IOException {
            this(protocol, Client.ConnectionId.getConnectionId(addr, protocol, ticket, rpcTimeout, conf), conf, factory);
        }

        public Invoker(Class<?> protocol, Client.ConnectionId connId, Configuration conf, SocketFactory factory) {
            this.remoteId = connId;
            this.client = CLIENTS.getClient(conf, factory, RpcResponseWritable.class);
            this.protocolName = RPC.getProtocolName(protocol);
            this.clientProtocolVersion = RPC.getProtocolVersion(protocol);
        }

        private HadoopRpcProtos.HadoopRpcRequestProto constructRpcRequest(Method method, Object[] params) throws ServiceException {
            HadoopRpcProtos.HadoopRpcRequestProto.Builder builder = HadoopRpcProtos.HadoopRpcRequestProto.newBuilder();
            builder.setMethodName(method.getName());
            if (params.length != 2) {
                throw new ServiceException("Too many parameters for request. Method: [" + method.getName() + "]" + ", Expected: 2, Actual: " + params.length);
            }
            if (params[1] == null) {
                throw new ServiceException("null param while calling Method: [" + method.getName() + "]");
            }
            Message param = (Message)params[1];
            builder.setRequest(param.toByteString());
            builder.setDeclaringClassProtocolName(this.protocolName);
            builder.setClientProtocolVersion(this.clientProtocolVersion);
            HadoopRpcProtos.HadoopRpcRequestProto rpcRequest = builder.build();
            return rpcRequest;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws ServiceException {
            Message returnMessage;
            long startTime = 0L;
            if (LOG.isDebugEnabled()) {
                startTime = System.currentTimeMillis();
            }
            HadoopRpcProtos.HadoopRpcRequestProto rpcRequest = this.constructRpcRequest(method, args);
            RpcResponseWritable val = null;
            try {
                val = (RpcResponseWritable)this.client.call(RPC.RpcKind.RPC_PROTOCOL_BUFFER, (Writable)new RpcRequestWritable(rpcRequest), this.remoteId);
            }
            catch (Throwable e) {
                throw new ServiceException(e);
            }
            if (LOG.isDebugEnabled()) {
                long callTime = System.currentTimeMillis() - startTime;
                LOG.debug((Object)("Call: " + method.getName() + " " + callTime));
            }
            Message prototype = null;
            try {
                prototype = this.getReturnProtoType(method);
            }
            catch (Exception e) {
                throw new ServiceException((Throwable)e);
            }
            try {
                returnMessage = prototype.newBuilderForType().mergeFrom(val.responseMessage).build();
            }
            catch (Throwable e) {
                throw new ServiceException(e);
            }
            return returnMessage;
        }

        @Override
        public void close() throws IOException {
            if (!this.isClosed) {
                this.isClosed = true;
                CLIENTS.stopClient(this.client);
            }
        }

        private Message getReturnProtoType(Method method) throws Exception {
            if (this.returnTypes.containsKey(method.getName())) {
                return this.returnTypes.get(method.getName());
            }
            Class<?> returnType = method.getReturnType();
            Method newInstMethod = returnType.getMethod("getDefaultInstance", new Class[0]);
            newInstMethod.setAccessible(true);
            Message prototype = (Message)newInstMethod.invoke(null, (Object[])null);
            this.returnTypes.put(method.getName(), prototype);
            return prototype;
        }

        @Override
        public Client.ConnectionId getConnectionId() {
            return this.remoteId;
        }
    }
}

