/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.util;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.zip.Checksum;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.fs.ChecksumException;
import org.apache.hadoop.util.NativeCrc32;
import org.apache.hadoop.util.PureJavaCrc32;
import org.apache.hadoop.util.PureJavaCrc32C;

@InterfaceAudience.LimitedPrivate(value={"HDFS", "MapReduce"})
@InterfaceStability.Evolving
public class DataChecksum
implements Checksum {
    public static final int HEADER_LEN = 5;
    public static final int CHECKSUM_NULL = 0;
    public static final int CHECKSUM_CRC32 = 1;
    public static final int CHECKSUM_CRC32C = 2;
    private static String[] NAMES = new String[]{"NULL", "CRC32", "CRC32C"};
    private static final int CHECKSUM_NULL_SIZE = 0;
    private static final int CHECKSUM_CRC32_SIZE = 4;
    private static final int CHECKSUM_CRC32C_SIZE = 4;
    private final int type;
    private final int size;
    private final Checksum summer;
    private final int bytesPerChecksum;
    private int inSum = 0;
    public static final int SIZE_OF_INTEGER = 4;

    public static DataChecksum newDataChecksum(int type, int bytesPerChecksum) {
        if (bytesPerChecksum <= 0) {
            return null;
        }
        switch (type) {
            case 0: {
                return new DataChecksum(0, new ChecksumNull(), 0, bytesPerChecksum);
            }
            case 1: {
                return new DataChecksum(1, new PureJavaCrc32(), 4, bytesPerChecksum);
            }
            case 2: {
                return new DataChecksum(2, new PureJavaCrc32C(), 4, bytesPerChecksum);
            }
        }
        return null;
    }

    public static DataChecksum newDataChecksum(byte[] bytes, int offset) {
        if (offset < 0 || bytes.length < offset + 5) {
            return null;
        }
        int bytesPerChecksum = (bytes[offset + 1] & 0xFF) << 24 | (bytes[offset + 2] & 0xFF) << 16 | (bytes[offset + 3] & 0xFF) << 8 | bytes[offset + 4] & 0xFF;
        return DataChecksum.newDataChecksum(bytes[0], bytesPerChecksum);
    }

    public static DataChecksum newDataChecksum(DataInputStream in) throws IOException {
        int bpc;
        byte type = in.readByte();
        DataChecksum summer = DataChecksum.newDataChecksum(type, bpc = in.readInt());
        if (summer == null) {
            throw new IOException("Could not create DataChecksum of type " + type + " with bytesPerChecksum " + bpc);
        }
        return summer;
    }

    public void writeHeader(DataOutputStream out) throws IOException {
        out.writeByte(this.type);
        out.writeInt(this.bytesPerChecksum);
    }

    public byte[] getHeader() {
        byte[] header = new byte[]{(byte)(this.type & 0xFF), (byte)(this.bytesPerChecksum >>> 24 & 0xFF), (byte)(this.bytesPerChecksum >>> 16 & 0xFF), (byte)(this.bytesPerChecksum >>> 8 & 0xFF), (byte)(this.bytesPerChecksum & 0xFF)};
        return header;
    }

    public int writeValue(DataOutputStream out, boolean reset) throws IOException {
        if (this.size <= 0) {
            return 0;
        }
        if (this.size != 4) {
            throw new IOException("Unknown Checksum " + this.type);
        }
        out.writeInt((int)this.summer.getValue());
        if (reset) {
            this.reset();
        }
        return this.size;
    }

    public int writeValue(byte[] buf, int offset, boolean reset) throws IOException {
        if (this.size <= 0) {
            return 0;
        }
        if (this.size != 4) {
            throw new IOException("Unknown Checksum " + this.type);
        }
        int checksum = (int)this.summer.getValue();
        buf[offset + 0] = (byte)(checksum >>> 24 & 0xFF);
        buf[offset + 1] = (byte)(checksum >>> 16 & 0xFF);
        buf[offset + 2] = (byte)(checksum >>> 8 & 0xFF);
        buf[offset + 3] = (byte)(checksum & 0xFF);
        if (reset) {
            this.reset();
        }
        return this.size;
    }

    public boolean compare(byte[] buf, int offset) {
        if (this.size == 4) {
            int checksum = (buf[offset + 0] & 0xFF) << 24 | (buf[offset + 1] & 0xFF) << 16 | (buf[offset + 2] & 0xFF) << 8 | buf[offset + 3] & 0xFF;
            return checksum == (int)this.summer.getValue();
        }
        return this.size == 0;
    }

    private DataChecksum(int checksumType, Checksum checksum, int sumSize, int chunkSize) {
        this.type = checksumType;
        this.summer = checksum;
        this.size = sumSize;
        this.bytesPerChecksum = chunkSize;
    }

    public int getChecksumType() {
        return this.type;
    }

    public int getChecksumSize() {
        return this.size;
    }

    public int getBytesPerChecksum() {
        return this.bytesPerChecksum;
    }

    public int getNumBytesInSum() {
        return this.inSum;
    }

    public static int getChecksumHeaderSize() {
        return 5;
    }

    @Override
    public long getValue() {
        return this.summer.getValue();
    }

    @Override
    public void reset() {
        this.summer.reset();
        this.inSum = 0;
    }

    @Override
    public void update(byte[] b, int off, int len) {
        if (len > 0) {
            this.summer.update(b, off, len);
            this.inSum += len;
        }
    }

    @Override
    public void update(int b) {
        this.summer.update(b);
        ++this.inSum;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void verifyChunkedSums(ByteBuffer data, ByteBuffer checksums, String fileName, long basePos) throws ChecksumException {
        if (this.size == 0) {
            return;
        }
        if (data.hasArray() && checksums.hasArray()) {
            this.verifyChunkedSums(data.array(), data.arrayOffset() + data.position(), data.remaining(), checksums.array(), checksums.arrayOffset() + checksums.position(), fileName, basePos);
            return;
        }
        if (NativeCrc32.isAvailable()) {
            NativeCrc32.verifyChunkedSums(this.bytesPerChecksum, this.type, checksums, data, fileName, basePos);
            return;
        }
        int startDataPos = data.position();
        data.mark();
        checksums.mark();
        try {
            byte[] buf = new byte[this.bytesPerChecksum];
            byte[] sum = new byte[this.size];
            while (data.remaining() > 0) {
                int stored;
                int n = Math.min(data.remaining(), this.bytesPerChecksum);
                checksums.get(sum);
                data.get(buf, 0, n);
                this.summer.reset();
                this.summer.update(buf, 0, n);
                int calculated = (int)this.summer.getValue();
                if (calculated == (stored = sum[0] << 24 & 0xFF000000 | sum[1] << 16 & 0xFF0000 | sum[2] << 8 & 0xFF00 | sum[3] & 0xFF)) continue;
                long errPos = basePos + (long)data.position() - (long)startDataPos - (long)n;
                throw new ChecksumException("Checksum error: " + fileName + " at " + errPos + " exp: " + stored + " got: " + calculated, errPos);
            }
        }
        finally {
            data.reset();
            checksums.reset();
        }
    }

    private void verifyChunkedSums(byte[] data, int dataOff, int dataLen, byte[] checksums, int checksumsOff, String fileName, long basePos) throws ChecksumException {
        int remaining = dataLen;
        int dataPos = 0;
        while (remaining > 0) {
            int n = Math.min(remaining, this.bytesPerChecksum);
            this.summer.reset();
            this.summer.update(data, dataOff + dataPos, n);
            dataPos += n;
            remaining -= n;
            int calculated = (int)this.summer.getValue();
            int stored = checksums[checksumsOff] << 24 & 0xFF000000 | checksums[checksumsOff + 1] << 16 & 0xFF0000 | checksums[checksumsOff + 2] << 8 & 0xFF00 | checksums[checksumsOff + 3] & 0xFF;
            checksumsOff += 4;
            if (calculated == stored) continue;
            long errPos = basePos + (long)dataPos - (long)n;
            throw new ChecksumException("Checksum error: " + fileName + " at " + errPos + " exp: " + stored + " got: " + calculated, errPos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void calculateChunkedSums(ByteBuffer data, ByteBuffer checksums) {
        if (this.size == 0) {
            return;
        }
        if (data.hasArray() && checksums.hasArray()) {
            this.calculateChunkedSums(data.array(), data.arrayOffset() + data.position(), data.remaining(), checksums.array(), checksums.arrayOffset() + checksums.position());
            return;
        }
        data.mark();
        checksums.mark();
        try {
            byte[] buf = new byte[this.bytesPerChecksum];
            while (data.remaining() > 0) {
                int n = Math.min(data.remaining(), this.bytesPerChecksum);
                data.get(buf, 0, n);
                this.summer.reset();
                this.summer.update(buf, 0, n);
                checksums.putInt((int)this.summer.getValue());
            }
        }
        finally {
            data.reset();
            checksums.reset();
        }
    }

    private void calculateChunkedSums(byte[] data, int dataOffset, int dataLength, byte[] sums, int sumsOffset) {
        int n;
        for (int remaining = dataLength; remaining > 0; remaining -= n) {
            n = Math.min(remaining, this.bytesPerChecksum);
            this.summer.reset();
            this.summer.update(data, dataOffset, n);
            dataOffset += n;
            long calculated = this.summer.getValue();
            sums[sumsOffset++] = (byte)(calculated >> 24);
            sums[sumsOffset++] = (byte)(calculated >> 16);
            sums[sumsOffset++] = (byte)(calculated >> 8);
            sums[sumsOffset++] = (byte)calculated;
        }
    }

    public boolean equals(Object other) {
        if (!(other instanceof DataChecksum)) {
            return false;
        }
        DataChecksum o = (DataChecksum)other;
        return o.bytesPerChecksum == this.bytesPerChecksum && o.type == this.type;
    }

    public int hashCode() {
        return (this.type + 31) * this.bytesPerChecksum;
    }

    public String toString() {
        String strType = this.type < NAMES.length && this.type > 0 ? NAMES[this.type] : String.valueOf(this.type);
        return "DataChecksum(type=" + strType + ", chunkSize=" + this.bytesPerChecksum + ")";
    }

    static class ChecksumNull
    implements Checksum {
        @Override
        public long getValue() {
            return 0L;
        }

        @Override
        public void reset() {
        }

        @Override
        public void update(byte[] b, int off, int len) {
        }

        @Override
        public void update(int b) {
        }
    }
}

