/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ha;

import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Map;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.ha.FailoverController;
import org.apache.hadoop.ha.FailoverFailedException;
import org.apache.hadoop.ha.HAServiceProtocol;
import org.apache.hadoop.ha.HAServiceProtocolHelper;
import org.apache.hadoop.ha.HAServiceTarget;
import org.apache.hadoop.ha.HealthCheckFailedException;
import org.apache.hadoop.ha.ServiceFailedException;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;

@InterfaceAudience.Private
public abstract class HAAdmin
extends Configured
implements Tool {
    private static final String FORCEFENCE = "forcefence";
    private static final String FORCEACTIVE = "forceactive";
    private static final Log LOG = LogFactory.getLog(HAAdmin.class);
    private int rpcTimeoutForChecks = -1;
    private static Map<String, UsageInfo> USAGE = ImmutableMap.builder().put((Object)"-transitionToActive", (Object)new UsageInfo("<serviceId>", "Transitions the service into Active state")).put((Object)"-transitionToStandby", (Object)new UsageInfo("<serviceId>", "Transitions the service into Standby state")).put((Object)"-failover", (Object)new UsageInfo("[--forcefence] [--forceactive] <serviceId> <serviceId>", "Failover from the first service to the second.\nUnconditionally fence services if the forcefence option is used.\nTry to failover to the target service even if it is not ready if the forceactive option is used.")).put((Object)"-getServiceState", (Object)new UsageInfo("<serviceId>", "Returns the state of the service")).put((Object)"-checkHealth", (Object)new UsageInfo("<serviceId>", "Requests that the service perform a health check.\nThe HAAdmin tool will exit with a non-zero exit code\nif the check fails.")).put((Object)"-help", (Object)new UsageInfo("<command>", "Displays help on the specified command")).build();
    protected PrintStream errOut = System.err;
    PrintStream out = System.out;

    protected abstract HAServiceTarget resolveTarget(String var1);

    protected String getUsageString() {
        return "Usage: HAAdmin";
    }

    protected void printUsage(PrintStream errOut) {
        errOut.println(this.getUsageString());
        for (Map.Entry<String, UsageInfo> e : USAGE.entrySet()) {
            String cmd = e.getKey();
            UsageInfo usage = e.getValue();
            errOut.println("    [" + cmd + " " + usage.args + "]");
        }
        errOut.println();
        ToolRunner.printGenericCommandUsage(errOut);
    }

    private static void printUsage(PrintStream errOut, String cmd) {
        UsageInfo usage = USAGE.get(cmd);
        if (usage == null) {
            throw new RuntimeException("No usage for cmd " + cmd);
        }
        errOut.println("Usage: HAAdmin [" + cmd + " " + usage.args + "]");
    }

    private int transitionToActive(String[] argv) throws IOException, ServiceFailedException {
        if (argv.length != 2) {
            this.errOut.println("transitionToActive: incorrect number of arguments");
            HAAdmin.printUsage(this.errOut, "-transitionToActive");
            return -1;
        }
        HAServiceProtocol proto = this.resolveTarget(argv[1]).getProxy(this.getConf(), 0);
        HAServiceProtocolHelper.transitionToActive(proto);
        return 0;
    }

    private int transitionToStandby(String[] argv) throws IOException, ServiceFailedException {
        if (argv.length != 2) {
            this.errOut.println("transitionToStandby: incorrect number of arguments");
            HAAdmin.printUsage(this.errOut, "-transitionToStandby");
            return -1;
        }
        HAServiceProtocol proto = this.resolveTarget(argv[1]).getProxy(this.getConf(), 0);
        HAServiceProtocolHelper.transitionToStandby(proto);
        return 0;
    }

    private int failover(String[] argv) throws IOException, ServiceFailedException {
        CommandLine cmd;
        boolean forceFence = false;
        boolean forceActive = false;
        Options failoverOpts = new Options();
        failoverOpts.addOption("failover", false, "failover");
        failoverOpts.addOption(FORCEFENCE, false, "force fencing");
        failoverOpts.addOption(FORCEACTIVE, false, "force failover");
        GnuParser parser = new GnuParser();
        try {
            cmd = parser.parse(failoverOpts, argv);
            forceFence = cmd.hasOption(FORCEFENCE);
            forceActive = cmd.hasOption(FORCEACTIVE);
        }
        catch (ParseException pe) {
            this.errOut.println("failover: incorrect arguments");
            HAAdmin.printUsage(this.errOut, "-failover");
            return -1;
        }
        int numOpts = cmd.getOptions() == null ? 0 : cmd.getOptions().length;
        String[] args = cmd.getArgs();
        if (numOpts > 2 || args.length != 2) {
            this.errOut.println("failover: incorrect arguments");
            HAAdmin.printUsage(this.errOut, "-failover");
            return -1;
        }
        HAServiceTarget fromNode = this.resolveTarget(args[0]);
        HAServiceTarget toNode = this.resolveTarget(args[1]);
        FailoverController fc = new FailoverController(this.getConf());
        try {
            fc.failover(fromNode, toNode, forceFence, forceActive);
            this.out.println("Failover from " + args[0] + " to " + args[1] + " successful");
        }
        catch (FailoverFailedException ffe) {
            this.errOut.println("Failover failed: " + ffe.getLocalizedMessage());
            return -1;
        }
        return 0;
    }

    private int checkHealth(String[] argv) throws IOException, ServiceFailedException {
        if (argv.length != 2) {
            this.errOut.println("checkHealth: incorrect number of arguments");
            HAAdmin.printUsage(this.errOut, "-checkHealth");
            return -1;
        }
        HAServiceProtocol proto = this.resolveTarget(argv[1]).getProxy(this.getConf(), this.rpcTimeoutForChecks);
        try {
            HAServiceProtocolHelper.monitorHealth(proto);
        }
        catch (HealthCheckFailedException e) {
            this.errOut.println("Health check failed: " + e.getLocalizedMessage());
            return -1;
        }
        return 0;
    }

    private int getServiceState(String[] argv) throws IOException, ServiceFailedException {
        if (argv.length != 2) {
            this.errOut.println("getServiceState: incorrect number of arguments");
            HAAdmin.printUsage(this.errOut, "-getServiceState");
            return -1;
        }
        HAServiceProtocol proto = this.resolveTarget(argv[1]).getProxy(this.getConf(), this.rpcTimeoutForChecks);
        this.out.println((Object)proto.getServiceStatus().getState());
        return 0;
    }

    protected String getServiceAddr(String serviceId) {
        return serviceId;
    }

    @Override
    public void setConf(Configuration conf) {
        super.setConf(conf);
        if (conf != null) {
            this.rpcTimeoutForChecks = conf.getInt("ha.failover-controller.cli-check.rpc-timeout.ms", 20000);
        }
    }

    @Override
    public int run(String[] argv) throws Exception {
        try {
            return this.runCmd(argv);
        }
        catch (IllegalArgumentException iae) {
            this.errOut.println("Illegal argument: " + iae.getLocalizedMessage());
            return -1;
        }
        catch (IOException ioe) {
            this.errOut.println("Operation failed: " + ioe.getLocalizedMessage());
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Operation failed", (Throwable)ioe);
            }
            return -1;
        }
    }

    protected int runCmd(String[] argv) throws Exception {
        if (argv.length < 1) {
            this.printUsage(this.errOut);
            return -1;
        }
        String cmd = argv[0];
        if (!cmd.startsWith("-")) {
            this.errOut.println("Bad command '" + cmd + "': expected command starting with '-'");
            this.printUsage(this.errOut);
            return -1;
        }
        if ("-transitionToActive".equals(cmd)) {
            return this.transitionToActive(argv);
        }
        if ("-transitionToStandby".equals(cmd)) {
            return this.transitionToStandby(argv);
        }
        if ("-failover".equals(cmd)) {
            return this.failover(argv);
        }
        if ("-getServiceState".equals(cmd)) {
            return this.getServiceState(argv);
        }
        if ("-checkHealth".equals(cmd)) {
            return this.checkHealth(argv);
        }
        if ("-help".equals(cmd)) {
            return this.help(argv);
        }
        this.errOut.println(cmd.substring(1) + ": Unknown command");
        this.printUsage(this.errOut);
        return -1;
    }

    private int help(String[] argv) {
        UsageInfo usageInfo;
        if (argv.length != 2) {
            HAAdmin.printUsage(this.errOut, "-help");
            return -1;
        }
        String cmd = argv[1];
        if (!cmd.startsWith("-")) {
            cmd = "-" + cmd;
        }
        if ((usageInfo = USAGE.get(cmd)) == null) {
            this.errOut.println(cmd + ": Unknown command");
            this.printUsage(this.errOut);
            return -1;
        }
        this.errOut.println(cmd + " [" + usageInfo.args + "]: " + usageInfo.help);
        return 0;
    }

    private static class UsageInfo {
        private final String args;
        private final String help;

        public UsageInfo(String args, String help) {
            this.args = args;
            this.help = help;
        }
    }
}

