/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.io.retry;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.net.ConnectException;
import java.net.NoRouteToHostException;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.io.retry.RetryPolicy;
import org.apache.hadoop.ipc.RemoteException;
import org.apache.hadoop.ipc.StandbyException;

public class RetryPolicies {
    public static final Log LOG = LogFactory.getLog(RetryPolicies.class);
    private static final Random RAND = new Random();
    public static final RetryPolicy TRY_ONCE_THEN_FAIL = new TryOnceThenFail();
    public static final RetryPolicy RETRY_FOREVER = new RetryForever();

    public static final RetryPolicy retryUpToMaximumCountWithFixedSleep(int maxRetries, long sleepTime, TimeUnit timeUnit) {
        return new RetryUpToMaximumCountWithFixedSleep(maxRetries, sleepTime, timeUnit);
    }

    public static final RetryPolicy retryUpToMaximumTimeWithFixedSleep(long maxTime, long sleepTime, TimeUnit timeUnit) {
        return new RetryUpToMaximumTimeWithFixedSleep(maxTime, sleepTime, timeUnit);
    }

    public static final RetryPolicy retryUpToMaximumCountWithProportionalSleep(int maxRetries, long sleepTime, TimeUnit timeUnit) {
        return new RetryUpToMaximumCountWithProportionalSleep(maxRetries, sleepTime, timeUnit);
    }

    public static final RetryPolicy exponentialBackoffRetry(int maxRetries, long sleepTime, TimeUnit timeUnit) {
        return new ExponentialBackoffRetry(maxRetries, sleepTime, timeUnit);
    }

    public static final RetryPolicy retryByException(RetryPolicy defaultPolicy, Map<Class<? extends Exception>, RetryPolicy> exceptionToPolicyMap) {
        return new ExceptionDependentRetry(defaultPolicy, exceptionToPolicyMap);
    }

    public static final RetryPolicy retryByRemoteException(RetryPolicy defaultPolicy, Map<Class<? extends Exception>, RetryPolicy> exceptionToPolicyMap) {
        return new RemoteExceptionDependentRetry(defaultPolicy, exceptionToPolicyMap);
    }

    public static final RetryPolicy failoverOnNetworkException(int maxFailovers) {
        return RetryPolicies.failoverOnNetworkException(TRY_ONCE_THEN_FAIL, maxFailovers);
    }

    public static final RetryPolicy failoverOnNetworkException(RetryPolicy fallbackPolicy, int maxFailovers) {
        return RetryPolicies.failoverOnNetworkException(fallbackPolicy, maxFailovers, 0L, 0L);
    }

    public static final RetryPolicy failoverOnNetworkException(RetryPolicy fallbackPolicy, int maxFailovers, long delayMillis, long maxDelayBase) {
        return new FailoverOnNetworkExceptionRetry(fallbackPolicy, maxFailovers, delayMillis, maxDelayBase);
    }

    @VisibleForTesting
    public static long calculateExponentialTime(long time, int retries, long cap) {
        long baseTime = Math.min(time * (1L << retries), cap);
        return (long)((double)baseTime * ((double)RAND.nextFloat() + 0.5));
    }

    private static long calculateExponentialTime(long time, int retries) {
        return RetryPolicies.calculateExponentialTime(time, retries, Long.MAX_VALUE);
    }

    private static boolean isWrappedStandbyException(Exception e) {
        if (!(e instanceof RemoteException)) {
            return false;
        }
        IOException unwrapped = ((RemoteException)e).unwrapRemoteException(StandbyException.class);
        return unwrapped instanceof StandbyException;
    }

    static class FailoverOnNetworkExceptionRetry
    implements RetryPolicy {
        private RetryPolicy fallbackPolicy;
        private int maxFailovers;
        private long delayMillis;
        private long maxDelayBase;

        public FailoverOnNetworkExceptionRetry(RetryPolicy fallbackPolicy, int maxFailovers) {
            this(fallbackPolicy, maxFailovers, 0L, 0L);
        }

        public FailoverOnNetworkExceptionRetry(RetryPolicy fallbackPolicy, int maxFailovers, long delayMillis, long maxDelayBase) {
            this.fallbackPolicy = fallbackPolicy;
            this.maxFailovers = maxFailovers;
            this.delayMillis = delayMillis;
            this.maxDelayBase = maxDelayBase;
        }

        @Override
        public RetryPolicy.RetryAction shouldRetry(Exception e, int retries, int failovers, boolean isMethodIdempotent) throws Exception {
            if (failovers >= this.maxFailovers) {
                return new RetryPolicy.RetryAction(RetryPolicy.RetryAction.RetryDecision.FAIL, 0L, "failovers (" + failovers + ") exceeded maximum allowed (" + this.maxFailovers + ")");
            }
            if (e instanceof ConnectException || e instanceof NoRouteToHostException || e instanceof UnknownHostException || e instanceof StandbyException || RetryPolicies.isWrappedStandbyException(e)) {
                return new RetryPolicy.RetryAction(RetryPolicy.RetryAction.RetryDecision.FAILOVER_AND_RETRY, failovers == 0 ? 0L : RetryPolicies.calculateExponentialTime(this.delayMillis, failovers, this.maxDelayBase));
            }
            if (e instanceof SocketException || e instanceof IOException && !(e instanceof RemoteException)) {
                if (isMethodIdempotent) {
                    return RetryPolicy.RetryAction.FAILOVER_AND_RETRY;
                }
                return new RetryPolicy.RetryAction(RetryPolicy.RetryAction.RetryDecision.FAIL, 0L, "the invoked method is not idempotent, and unable to determine whether it was invoked");
            }
            return this.fallbackPolicy.shouldRetry(e, retries, failovers, isMethodIdempotent);
        }
    }

    static class ExponentialBackoffRetry
    extends RetryLimited {
        public ExponentialBackoffRetry(int maxRetries, long sleepTime, TimeUnit timeUnit) {
            super(maxRetries, sleepTime, timeUnit);
        }

        @Override
        protected long calculateSleepTime(int retries) {
            return RetryPolicies.calculateExponentialTime(this.sleepTime, retries + 1);
        }
    }

    static class RemoteExceptionDependentRetry
    implements RetryPolicy {
        RetryPolicy defaultPolicy;
        Map<String, RetryPolicy> exceptionNameToPolicyMap;

        public RemoteExceptionDependentRetry(RetryPolicy defaultPolicy, Map<Class<? extends Exception>, RetryPolicy> exceptionToPolicyMap) {
            this.defaultPolicy = defaultPolicy;
            this.exceptionNameToPolicyMap = new HashMap<String, RetryPolicy>();
            for (Map.Entry<Class<? extends Exception>, RetryPolicy> e : exceptionToPolicyMap.entrySet()) {
                this.exceptionNameToPolicyMap.put(e.getKey().getName(), e.getValue());
            }
        }

        @Override
        public RetryPolicy.RetryAction shouldRetry(Exception e, int retries, int failovers, boolean isMethodIdempotent) throws Exception {
            RetryPolicy policy = null;
            if (e instanceof RemoteException) {
                policy = this.exceptionNameToPolicyMap.get(((RemoteException)e).getClassName());
            }
            if (policy == null) {
                policy = this.defaultPolicy;
            }
            return policy.shouldRetry(e, retries, failovers, isMethodIdempotent);
        }
    }

    static class ExceptionDependentRetry
    implements RetryPolicy {
        RetryPolicy defaultPolicy;
        Map<Class<? extends Exception>, RetryPolicy> exceptionToPolicyMap;

        public ExceptionDependentRetry(RetryPolicy defaultPolicy, Map<Class<? extends Exception>, RetryPolicy> exceptionToPolicyMap) {
            this.defaultPolicy = defaultPolicy;
            this.exceptionToPolicyMap = exceptionToPolicyMap;
        }

        @Override
        public RetryPolicy.RetryAction shouldRetry(Exception e, int retries, int failovers, boolean isMethodIdempotent) throws Exception {
            RetryPolicy policy = this.exceptionToPolicyMap.get(e.getClass());
            if (policy == null) {
                policy = this.defaultPolicy;
            }
            return policy.shouldRetry(e, retries, failovers, isMethodIdempotent);
        }
    }

    static class RetryUpToMaximumCountWithProportionalSleep
    extends RetryLimited {
        public RetryUpToMaximumCountWithProportionalSleep(int maxRetries, long sleepTime, TimeUnit timeUnit) {
            super(maxRetries, sleepTime, timeUnit);
        }

        @Override
        protected long calculateSleepTime(int retries) {
            return this.sleepTime * (long)(retries + 1);
        }
    }

    static class RetryUpToMaximumTimeWithFixedSleep
    extends RetryUpToMaximumCountWithFixedSleep {
        public RetryUpToMaximumTimeWithFixedSleep(long maxTime, long sleepTime, TimeUnit timeUnit) {
            super((int)(maxTime / sleepTime), sleepTime, timeUnit);
        }
    }

    static class RetryUpToMaximumCountWithFixedSleep
    extends RetryLimited {
        public RetryUpToMaximumCountWithFixedSleep(int maxRetries, long sleepTime, TimeUnit timeUnit) {
            super(maxRetries, sleepTime, timeUnit);
        }

        @Override
        protected long calculateSleepTime(int retries) {
            return this.sleepTime;
        }
    }

    static abstract class RetryLimited
    implements RetryPolicy {
        int maxRetries;
        long sleepTime;
        TimeUnit timeUnit;

        public RetryLimited(int maxRetries, long sleepTime, TimeUnit timeUnit) {
            this.maxRetries = maxRetries;
            this.sleepTime = sleepTime;
            this.timeUnit = timeUnit;
        }

        @Override
        public RetryPolicy.RetryAction shouldRetry(Exception e, int retries, int failovers, boolean isMethodIdempotent) throws Exception {
            if (retries >= this.maxRetries) {
                return RetryPolicy.RetryAction.FAIL;
            }
            return new RetryPolicy.RetryAction(RetryPolicy.RetryAction.RetryDecision.RETRY, this.timeUnit.toMillis(this.calculateSleepTime(retries)));
        }

        protected abstract long calculateSleepTime(int var1);
    }

    static class RetryForever
    implements RetryPolicy {
        RetryForever() {
        }

        @Override
        public RetryPolicy.RetryAction shouldRetry(Exception e, int retries, int failovers, boolean isMethodIdempotent) throws Exception {
            return RetryPolicy.RetryAction.RETRY;
        }
    }

    static class TryOnceThenFail
    implements RetryPolicy {
        TryOnceThenFail() {
        }

        @Override
        public RetryPolicy.RetryAction shouldRetry(Exception e, int retries, int failovers, boolean isMethodIdempotent) throws Exception {
            return RetryPolicy.RetryAction.FAIL;
        }
    }
}

