/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.shell;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.LinkedList;
import java.util.zip.GZIPInputStream;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.shell.CommandFactory;
import org.apache.hadoop.fs.shell.CommandFormat;
import org.apache.hadoop.fs.shell.FsCommand;
import org.apache.hadoop.fs.shell.PathData;
import org.apache.hadoop.fs.shell.PathExceptions;
import org.apache.hadoop.io.DataInputBuffer;
import org.apache.hadoop.io.DataOutputBuffer;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.CompressionCodecFactory;
import org.apache.hadoop.util.ReflectionUtils;

@InterfaceAudience.Private
@InterfaceStability.Evolving
class Display
extends FsCommand {
    Display() {
    }

    public static void registerCommands(CommandFactory factory) {
        factory.addClass(Cat.class, "-cat");
        factory.addClass(Text.class, "-text");
    }

    protected class TextRecordInputStream
    extends InputStream {
        SequenceFile.Reader r;
        WritableComparable<?> key;
        Writable val;
        DataInputBuffer inbuf;
        DataOutputBuffer outbuf;

        public TextRecordInputStream(FileStatus f) throws IOException {
            Path fpath = f.getPath();
            Configuration lconf = Display.this.getConf();
            this.r = new SequenceFile.Reader(lconf, SequenceFile.Reader.file(fpath));
            this.key = ReflectionUtils.newInstance(this.r.getKeyClass().asSubclass(WritableComparable.class), lconf);
            this.val = ReflectionUtils.newInstance(this.r.getValueClass().asSubclass(Writable.class), lconf);
            this.inbuf = new DataInputBuffer();
            this.outbuf = new DataOutputBuffer();
        }

        @Override
        public int read() throws IOException {
            int ret;
            if (null == this.inbuf || -1 == (ret = this.inbuf.read())) {
                if (!this.r.next(this.key, this.val)) {
                    return -1;
                }
                byte[] tmp = this.key.toString().getBytes();
                this.outbuf.write(tmp, 0, tmp.length);
                this.outbuf.write(9);
                tmp = this.val.toString().getBytes();
                this.outbuf.write(tmp, 0, tmp.length);
                this.outbuf.write(10);
                this.inbuf.reset(this.outbuf.getData(), this.outbuf.getLength());
                this.outbuf.reset();
                ret = this.inbuf.read();
            }
            return ret;
        }

        @Override
        public void close() throws IOException {
            this.r.close();
            super.close();
        }
    }

    public static class Text
    extends Cat {
        public static final String NAME = "text";
        public static final String USAGE = "[-ignoreCrc] <src> ...";
        public static final String DESCRIPTION = "Takes a source file and outputs the file in text format.\nThe allowed formats are zip and TextRecordInputStream.";

        @Override
        protected InputStream getInputStream(PathData item) throws IOException {
            FSDataInputStream i = (FSDataInputStream)super.getInputStream(item);
            switch (i.readShort()) {
                case 8075: {
                    i.seek(0L);
                    return new GZIPInputStream(i);
                }
                case 21317: {
                    if (i.readByte() != 81) break;
                    i.close();
                    return new TextRecordInputStream(item.stat);
                }
            }
            CompressionCodecFactory cf = new CompressionCodecFactory(this.getConf());
            CompressionCodec codec = cf.getCodec(item.path);
            if (codec != null) {
                return codec.createInputStream(i);
            }
            i.seek(0L);
            return i;
        }
    }

    public static class Cat
    extends Display {
        public static final String NAME = "cat";
        public static final String USAGE = "[-ignoreCrc] <src> ...";
        public static final String DESCRIPTION = "Fetch all files that match the file pattern <src> \nand display their content on stdout.\n";
        private boolean verifyChecksum = true;

        @Override
        protected void processOptions(LinkedList<String> args) throws IOException {
            CommandFormat cf = new CommandFormat(1, Integer.MAX_VALUE, "ignoreCrc");
            cf.parse(args);
            this.verifyChecksum = !cf.getOpt("ignoreCrc");
        }

        @Override
        protected void processPath(PathData item) throws IOException {
            if (item.stat.isDirectory()) {
                throw new PathExceptions.PathIsDirectoryException(item.toString());
            }
            item.fs.setVerifyChecksum(this.verifyChecksum);
            this.printToStdout(this.getInputStream(item));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void printToStdout(InputStream in) throws IOException {
            try {
                IOUtils.copyBytes(in, (OutputStream)this.out, this.getConf(), false);
            }
            finally {
                in.close();
            }
        }

        protected InputStream getInputStream(PathData item) throws IOException {
            return item.fs.open(item.path);
        }
    }
}

