/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ipc;

import java.io.InterruptedIOException;
import java.net.ConnectException;
import java.net.InetSocketAddress;
import java.nio.channels.ClosedByInterruptException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.ipc.TestRPC;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestRPCWaitForProxy
extends Assert {
    private static final String ADDRESS = "0.0.0.0";
    private static final Logger LOG = LoggerFactory.getLogger(TestRPCWaitForProxy.class);
    private static final Configuration conf = new Configuration();

    @Test(timeout=10000L)
    public void testWaitForProxy() throws Throwable {
        RpcThread worker = new RpcThread(0);
        worker.start();
        worker.join();
        Throwable caught = worker.getCaught();
        TestRPCWaitForProxy.assertNotNull((String)"No exception was raised", (Object)caught);
        if (!(caught instanceof ConnectException)) {
            throw caught;
        }
    }

    @Test(timeout=10000L)
    public void testInterruptedWaitForProxy() throws Throwable {
        RpcThread worker = new RpcThread(100);
        worker.start();
        Thread.sleep(1000L);
        TestRPCWaitForProxy.assertTrue((String)"worker hasn't started", (boolean)worker.waitStarted);
        worker.interrupt();
        worker.join();
        Throwable caught = worker.getCaught();
        TestRPCWaitForProxy.assertNotNull((String)"No exception was raised", (Object)caught);
        Throwable cause = caught.getCause();
        if (cause == null) {
            cause = caught;
        }
        if (!(cause instanceof InterruptedIOException) && !(cause instanceof ClosedByInterruptException)) {
            throw caught;
        }
    }

    private class RpcThread
    extends Thread {
        private Throwable caught;
        private int connectRetries;
        private volatile boolean waitStarted = false;

        private RpcThread(int connectRetries) {
            this.connectRetries = connectRetries;
        }

        @Override
        public void run() {
            try {
                Configuration config = new Configuration(conf);
                config.setInt("ipc.client.connect.max.retries", this.connectRetries);
                config.setInt("ipc.client.connect.max.retries.on.timeouts", this.connectRetries);
                this.waitStarted = true;
                TestRPC.TestProtocol proxy = (TestRPC.TestProtocol)RPC.waitForProxy(TestRPC.TestProtocol.class, (long)1L, (InetSocketAddress)new InetSocketAddress(TestRPCWaitForProxy.ADDRESS, 20), (Configuration)config, (long)15000L);
                proxy.echo("");
            }
            catch (Throwable throwable) {
                this.caught = throwable;
            }
        }

        public Throwable getCaught() {
            return this.caught;
        }
    }
}

