/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.viewfs;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.ContentSummary;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileSystemTestHelper;
import org.apache.hadoop.fs.FilterFileSystem;
import org.apache.hadoop.fs.FsConstants;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.viewfs.ChRootedFileSystem;
import org.apache.hadoop.fs.viewfs.ConfigUtil;
import org.apache.hadoop.fs.viewfs.ViewFileSystem;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class TestChRootedFileSystem {
    FileSystem fSys;
    FileSystem fSysTarget;
    Path chrootedTo;
    FileSystemTestHelper fileSystemTestHelper;

    @Before
    public void setUp() throws Exception {
        Configuration conf = new Configuration();
        this.fSysTarget = FileSystem.getLocal((Configuration)conf);
        this.fileSystemTestHelper = new FileSystemTestHelper();
        this.chrootedTo = this.fileSystemTestHelper.getAbsoluteTestRootPath(this.fSysTarget);
        this.fSysTarget.delete(this.chrootedTo, true);
        this.fSysTarget.mkdirs(this.chrootedTo);
        this.fSys = new ChRootedFileSystem(this.chrootedTo.toUri(), conf);
    }

    @After
    public void tearDown() throws Exception {
        this.fSysTarget.delete(this.chrootedTo, true);
    }

    @Test
    public void testURI() {
        URI uri = this.fSys.getUri();
        Assert.assertEquals((Object)this.chrootedTo.toUri(), (Object)uri);
    }

    @Test
    public void testBasicPaths() {
        URI uri = this.fSys.getUri();
        Assert.assertEquals((Object)this.chrootedTo.toUri(), (Object)uri);
        Assert.assertEquals((Object)this.fSys.makeQualified(new Path(System.getProperty("user.home"))), (Object)this.fSys.getWorkingDirectory());
        Assert.assertEquals((Object)this.fSys.makeQualified(new Path(System.getProperty("user.home"))), (Object)this.fSys.getHomeDirectory());
        Assert.assertEquals((Object)new Path("/foo/bar").makeQualified(FsConstants.LOCAL_FS_URI, null), (Object)this.fSys.makeQualified(new Path("/foo/bar")));
    }

    @Test
    public void testCreateDelete() throws IOException {
        this.fileSystemTestHelper.createFile(this.fSys, "/foo");
        Assert.assertTrue((boolean)this.fSys.isFile(new Path("/foo")));
        Assert.assertTrue((boolean)this.fSysTarget.isFile(new Path(this.chrootedTo, "foo")));
        this.fileSystemTestHelper.createFile(this.fSys, "/newDir/foo");
        Assert.assertTrue((boolean)this.fSys.isFile(new Path("/newDir/foo")));
        Assert.assertTrue((boolean)this.fSysTarget.isFile(new Path(this.chrootedTo, "newDir/foo")));
        Assert.assertTrue((boolean)this.fSys.delete(new Path("/newDir/foo"), false));
        Assert.assertFalse((boolean)this.fSys.exists(new Path("/newDir/foo")));
        Assert.assertFalse((boolean)this.fSysTarget.exists(new Path(this.chrootedTo, "newDir/foo")));
        this.fileSystemTestHelper.createFile(this.fSys, "/newDir/newDir2/foo");
        Assert.assertTrue((boolean)this.fSys.isFile(new Path("/newDir/newDir2/foo")));
        Assert.assertTrue((boolean)this.fSysTarget.isFile(new Path(this.chrootedTo, "newDir/newDir2/foo")));
        Assert.assertTrue((boolean)this.fSys.delete(new Path("/newDir/newDir2/foo"), false));
        Assert.assertFalse((boolean)this.fSys.exists(new Path("/newDir/newDir2/foo")));
        Assert.assertFalse((boolean)this.fSysTarget.exists(new Path(this.chrootedTo, "newDir/newDir2/foo")));
    }

    @Test
    public void testMkdirDelete() throws IOException {
        this.fSys.mkdirs(this.fileSystemTestHelper.getTestRootPath(this.fSys, "/dirX"));
        Assert.assertTrue((boolean)this.fSys.isDirectory(new Path("/dirX")));
        Assert.assertTrue((boolean)this.fSysTarget.isDirectory(new Path(this.chrootedTo, "dirX")));
        this.fSys.mkdirs(this.fileSystemTestHelper.getTestRootPath(this.fSys, "/dirX/dirY"));
        Assert.assertTrue((boolean)this.fSys.isDirectory(new Path("/dirX/dirY")));
        Assert.assertTrue((boolean)this.fSysTarget.isDirectory(new Path(this.chrootedTo, "dirX/dirY")));
        Assert.assertTrue((boolean)this.fSys.delete(new Path("/dirX/dirY"), false));
        Assert.assertFalse((boolean)this.fSys.exists(new Path("/dirX/dirY")));
        Assert.assertFalse((boolean)this.fSysTarget.exists(new Path(this.chrootedTo, "dirX/dirY")));
        Assert.assertTrue((boolean)this.fSys.delete(new Path("/dirX"), false));
        Assert.assertFalse((boolean)this.fSys.exists(new Path("/dirX")));
        Assert.assertFalse((boolean)this.fSysTarget.exists(new Path(this.chrootedTo, "dirX")));
    }

    @Test
    public void testRename() throws IOException {
        this.fileSystemTestHelper.createFile(this.fSys, "/newDir/foo");
        this.fSys.rename(new Path("/newDir/foo"), new Path("/newDir/fooBar"));
        Assert.assertFalse((boolean)this.fSys.exists(new Path("/newDir/foo")));
        Assert.assertFalse((boolean)this.fSysTarget.exists(new Path(this.chrootedTo, "newDir/foo")));
        Assert.assertTrue((boolean)this.fSys.isFile(this.fileSystemTestHelper.getTestRootPath(this.fSys, "/newDir/fooBar")));
        Assert.assertTrue((boolean)this.fSysTarget.isFile(new Path(this.chrootedTo, "newDir/fooBar")));
        this.fSys.mkdirs(new Path("/newDir/dirFoo"));
        this.fSys.rename(new Path("/newDir/dirFoo"), new Path("/newDir/dirFooBar"));
        Assert.assertFalse((boolean)this.fSys.exists(new Path("/newDir/dirFoo")));
        Assert.assertFalse((boolean)this.fSysTarget.exists(new Path(this.chrootedTo, "newDir/dirFoo")));
        Assert.assertTrue((boolean)this.fSys.isDirectory(this.fileSystemTestHelper.getTestRootPath(this.fSys, "/newDir/dirFooBar")));
        Assert.assertTrue((boolean)this.fSysTarget.isDirectory(new Path(this.chrootedTo, "newDir/dirFooBar")));
    }

    @Test
    public void testGetContentSummary() throws IOException {
        this.fSys.mkdirs(new Path("/newDir/dirFoo"));
        ContentSummary cs = this.fSys.getContentSummary(new Path("/newDir/dirFoo"));
        Assert.assertEquals((long)-1L, (long)cs.getQuota());
        Assert.assertEquals((long)-1L, (long)cs.getSpaceQuota());
    }

    @Test
    public void testRenameAcrossFs() throws IOException {
        this.fSys.mkdirs(new Path("/newDir/dirFoo"));
        this.fSys.rename(new Path("/newDir/dirFoo"), new Path("file:///tmp/dirFooBar"));
        FileSystemTestHelper.isDir(this.fSys, new Path("/tmp/dirFooBar"));
    }

    @Test
    public void testList() throws IOException {
        FileStatus fs = this.fSys.getFileStatus(new Path("/"));
        Assert.assertTrue((boolean)fs.isDirectory());
        Assert.assertEquals((Object)fs.getPath(), (Object)this.chrootedTo);
        FileStatus[] dirPaths = this.fSys.listStatus(new Path("/"));
        Assert.assertEquals((long)0L, (long)dirPaths.length);
        this.fileSystemTestHelper.createFile(this.fSys, "/foo");
        this.fileSystemTestHelper.createFile(this.fSys, "/bar");
        this.fSys.mkdirs(new Path("/dirX"));
        this.fSys.mkdirs(this.fileSystemTestHelper.getTestRootPath(this.fSys, "/dirY"));
        this.fSys.mkdirs(new Path("/dirX/dirXX"));
        dirPaths = this.fSys.listStatus(new Path("/"));
        Assert.assertEquals((long)4L, (long)dirPaths.length);
        fs = FileSystemTestHelper.containsPath(new Path(this.chrootedTo, "foo"), dirPaths);
        Assert.assertNotNull((Object)fs);
        Assert.assertTrue((boolean)fs.isFile());
        fs = FileSystemTestHelper.containsPath(new Path(this.chrootedTo, "bar"), dirPaths);
        Assert.assertNotNull((Object)fs);
        Assert.assertTrue((boolean)fs.isFile());
        fs = FileSystemTestHelper.containsPath(new Path(this.chrootedTo, "dirX"), dirPaths);
        Assert.assertNotNull((Object)fs);
        Assert.assertTrue((boolean)fs.isDirectory());
        fs = FileSystemTestHelper.containsPath(new Path(this.chrootedTo, "dirY"), dirPaths);
        Assert.assertNotNull((Object)fs);
        Assert.assertTrue((boolean)fs.isDirectory());
    }

    @Test
    public void testWorkingDirectory() throws Exception {
        this.fSys.mkdirs(new Path("/testWd"));
        Path workDir = new Path("/testWd");
        this.fSys.setWorkingDirectory(workDir);
        Assert.assertEquals((Object)workDir, (Object)this.fSys.getWorkingDirectory());
        this.fSys.setWorkingDirectory(new Path("."));
        Assert.assertEquals((Object)workDir, (Object)this.fSys.getWorkingDirectory());
        this.fSys.setWorkingDirectory(new Path(".."));
        Assert.assertEquals((Object)workDir.getParent(), (Object)this.fSys.getWorkingDirectory());
        workDir = new Path("/testWd");
        this.fSys.setWorkingDirectory(workDir);
        Assert.assertEquals((Object)workDir, (Object)this.fSys.getWorkingDirectory());
        Path relativeDir = new Path("existingDir1");
        Path absoluteDir = new Path(workDir, "existingDir1");
        this.fSys.mkdirs(absoluteDir);
        this.fSys.setWorkingDirectory(relativeDir);
        Assert.assertEquals((Object)absoluteDir, (Object)this.fSys.getWorkingDirectory());
        absoluteDir = new Path("/test/existingDir2");
        this.fSys.mkdirs(absoluteDir);
        this.fSys.setWorkingDirectory(absoluteDir);
        Assert.assertEquals((Object)absoluteDir, (Object)this.fSys.getWorkingDirectory());
        Path absoluteFooPath = new Path(absoluteDir, "foo");
        this.fSys.create(absoluteFooPath).close();
        this.fSys.open(new Path("foo")).close();
        this.fSys.mkdirs(new Path("newDir"));
        Assert.assertTrue((boolean)this.fSys.isDirectory(new Path(absoluteDir, "newDir")));
        String LOCAL_FS_ROOT_URI = "file:///tmp/test";
        absoluteDir = new Path("file:///tmp/test/existingDir");
        this.fSys.mkdirs(absoluteDir);
        this.fSys.setWorkingDirectory(absoluteDir);
        Assert.assertEquals((Object)absoluteDir, (Object)this.fSys.getWorkingDirectory());
    }

    @Test
    public void testResolvePath() throws IOException {
        Assert.assertEquals((Object)this.chrootedTo, (Object)this.fSys.resolvePath(new Path("/")));
        this.fileSystemTestHelper.createFile(this.fSys, "/foo");
        Assert.assertEquals((Object)new Path(this.chrootedTo, "foo"), (Object)this.fSys.resolvePath(new Path("/foo")));
    }

    @Test(expected=FileNotFoundException.class)
    public void testResolvePathNonExisting() throws IOException {
        this.fSys.resolvePath(new Path("/nonExisting"));
    }

    @Test
    public void testDeleteOnExitPathHandling() throws IOException {
        Configuration conf = new Configuration();
        conf.setClass("fs.mockfs.impl", MockFileSystem.class, FileSystem.class);
        URI chrootUri = URI.create("mockfs://foo/a/b");
        ChRootedFileSystem chrootFs = new ChRootedFileSystem(chrootUri, conf);
        FileSystem mockFs = ((FilterFileSystem)chrootFs.getRawFileSystem()).getRawFileSystem();
        Path chrootPath = new Path("/c");
        Path rawPath = new Path("/a/b/c");
        chrootFs.delete(chrootPath, false);
        ((FileSystem)Mockito.verify((Object)mockFs)).delete((Path)Mockito.eq((Object)rawPath), Mockito.eq((boolean)false));
        Mockito.reset((Object[])new FileSystem[]{mockFs});
        FileStatus stat = (FileStatus)Mockito.mock(FileStatus.class);
        Mockito.when((Object)mockFs.getFileStatus((Path)Mockito.eq((Object)rawPath))).thenReturn((Object)stat);
        chrootFs.deleteOnExit(chrootPath);
        chrootFs.close();
        ((FileSystem)Mockito.verify((Object)mockFs)).delete((Path)Mockito.eq((Object)rawPath), Mockito.eq((boolean)true));
    }

    @Test
    public void testURIEmptyPath() throws IOException {
        Configuration conf = new Configuration();
        conf.setClass("fs.mockfs.impl", MockFileSystem.class, FileSystem.class);
        URI chrootUri = URI.create("mockfs://foo");
        new ChRootedFileSystem(chrootUri, conf);
    }

    @Test
    public void testAclMethodsPathTranslation() throws IOException {
        Configuration conf = new Configuration();
        conf.setClass("fs.mockfs.impl", MockFileSystem.class, FileSystem.class);
        URI chrootUri = URI.create("mockfs://foo/a/b");
        ChRootedFileSystem chrootFs = new ChRootedFileSystem(chrootUri, conf);
        FileSystem mockFs = ((FilterFileSystem)chrootFs.getRawFileSystem()).getRawFileSystem();
        Path chrootPath = new Path("/c");
        Path rawPath = new Path("/a/b/c");
        List entries = Collections.emptyList();
        chrootFs.modifyAclEntries(chrootPath, entries);
        ((FileSystem)Mockito.verify((Object)mockFs)).modifyAclEntries(rawPath, entries);
        chrootFs.removeAclEntries(chrootPath, entries);
        ((FileSystem)Mockito.verify((Object)mockFs)).removeAclEntries(rawPath, entries);
        chrootFs.removeDefaultAcl(chrootPath);
        ((FileSystem)Mockito.verify((Object)mockFs)).removeDefaultAcl(rawPath);
        chrootFs.removeAcl(chrootPath);
        ((FileSystem)Mockito.verify((Object)mockFs)).removeAcl(rawPath);
        chrootFs.setAcl(chrootPath, entries);
        ((FileSystem)Mockito.verify((Object)mockFs)).setAcl(rawPath, entries);
        chrootFs.getAclStatus(chrootPath);
        ((FileSystem)Mockito.verify((Object)mockFs)).getAclStatus(rawPath);
    }

    @Test
    public void testListLocatedFileStatus() throws Exception {
        Path mockMount = new Path("mockfs://foo/user");
        Path mockPath = new Path("/usermock");
        Configuration conf = new Configuration();
        conf.setClass("fs.mockfs.impl", MockFileSystem.class, FileSystem.class);
        ConfigUtil.addLink((Configuration)conf, (String)mockPath.toString(), (URI)mockMount.toUri());
        FileSystem vfs = FileSystem.get((URI)URI.create("viewfs:///"), (Configuration)conf);
        vfs.listLocatedStatus(mockPath);
        FileSystem mockFs = ((MockFileSystem)TestChRootedFileSystem.getChildFileSystem((ViewFileSystem)vfs, new URI("mockfs://foo/"))).getRawFileSystem();
        ((FileSystem)Mockito.verify((Object)mockFs)).listLocatedStatus(new Path(mockMount.toUri().getPath()));
    }

    static FileSystem getChildFileSystem(ViewFileSystem viewFs, URI uri) {
        for (FileSystem fs : viewFs.getChildFileSystems()) {
            if (!Objects.equals(fs.getUri().getScheme(), uri.getScheme()) || !Objects.equals(fs.getUri().getAuthority(), uri.getAuthority())) continue;
            return fs;
        }
        return null;
    }

    @Test(timeout=30000L)
    public void testCreateSnapshot() throws Exception {
        Path snapRootPath = new Path("/snapPath");
        Path chRootedSnapRootPath = new Path("/a/b/snapPath");
        Configuration conf = new Configuration();
        conf.setClass("fs.mockfs.impl", MockFileSystem.class, FileSystem.class);
        URI chrootUri = URI.create("mockfs://foo/a/b");
        ChRootedFileSystem chrootFs = new ChRootedFileSystem(chrootUri, conf);
        FileSystem mockFs = ((FilterFileSystem)chrootFs.getRawFileSystem()).getRawFileSystem();
        chrootFs.createSnapshot(snapRootPath, "snap1");
        ((FileSystem)Mockito.verify((Object)mockFs)).createSnapshot(chRootedSnapRootPath, "snap1");
    }

    @Test(timeout=30000L)
    public void testDeleteSnapshot() throws Exception {
        Path snapRootPath = new Path("/snapPath");
        Path chRootedSnapRootPath = new Path("/a/b/snapPath");
        Configuration conf = new Configuration();
        conf.setClass("fs.mockfs.impl", MockFileSystem.class, FileSystem.class);
        URI chrootUri = URI.create("mockfs://foo/a/b");
        ChRootedFileSystem chrootFs = new ChRootedFileSystem(chrootUri, conf);
        FileSystem mockFs = ((FilterFileSystem)chrootFs.getRawFileSystem()).getRawFileSystem();
        chrootFs.deleteSnapshot(snapRootPath, "snap1");
        ((FileSystem)Mockito.verify((Object)mockFs)).deleteSnapshot(chRootedSnapRootPath, "snap1");
    }

    @Test(timeout=30000L)
    public void testRenameSnapshot() throws Exception {
        Path snapRootPath = new Path("/snapPath");
        Path chRootedSnapRootPath = new Path("/a/b/snapPath");
        Configuration conf = new Configuration();
        conf.setClass("fs.mockfs.impl", MockFileSystem.class, FileSystem.class);
        URI chrootUri = URI.create("mockfs://foo/a/b");
        ChRootedFileSystem chrootFs = new ChRootedFileSystem(chrootUri, conf);
        FileSystem mockFs = ((FilterFileSystem)chrootFs.getRawFileSystem()).getRawFileSystem();
        chrootFs.renameSnapshot(snapRootPath, "snapOldName", "snapNewName");
        ((FileSystem)Mockito.verify((Object)mockFs)).renameSnapshot(chRootedSnapRootPath, "snapOldName", "snapNewName");
    }

    static class MockFileSystem
    extends FilterFileSystem {
        private URI uri;

        MockFileSystem() {
            super((FileSystem)Mockito.mock(FileSystem.class));
        }

        public URI getUri() {
            return this.uri;
        }

        public void initialize(URI name, Configuration conf) throws IOException {
            this.uri = name;
        }
    }
}

