/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.security;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.Groups;
import org.apache.hadoop.security.ShellBasedUnixGroupsMapping;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestGroupsCaching {
    public static final Log LOG = LogFactory.getLog(TestGroupsCaching.class);
    private static String[] myGroups = new String[]{"grp1", "grp2"};
    private Configuration conf;

    @Before
    public void setup() {
        this.conf = new Configuration();
        this.conf.setClass("hadoop.security.group.mapping", FakeGroupMapping.class, ShellBasedUnixGroupsMapping.class);
    }

    @Test
    public void testGroupsCaching() throws Exception {
        Groups groups;
        block2: {
            groups = new Groups(this.conf);
            groups.cacheGroupsAdd(Arrays.asList(myGroups));
            groups.refresh();
            FakeGroupMapping.clearBlackList();
            FakeGroupMapping.addToBlackList("user1");
            Assert.assertTrue((groups.getGroups("me").size() == 2 ? 1 : 0) != 0);
            FakeGroupMapping.addToBlackList("me");
            Assert.assertTrue((groups.getGroups("me").size() == 2 ? 1 : 0) != 0);
            try {
                LOG.error((Object)("We are not supposed to get here." + groups.getGroups("user1").toString()));
                Assert.fail();
            }
            catch (IOException ioe) {
                if (ioe.getMessage().startsWith("No groups found")) break block2;
                LOG.error((Object)("Got unexpected exception: " + ioe.getMessage()));
                Assert.fail();
            }
        }
        FakeGroupMapping.clearBlackList();
        Assert.assertTrue((groups.getGroups("user1").size() == 2 ? 1 : 0) != 0);
    }

    @Test
    public void testGroupLookupForStaticUsers() throws Exception {
        this.conf.setClass("hadoop.security.group.mapping", FakeunPrivilegedGroupMapping.class, ShellBasedUnixGroupsMapping.class);
        this.conf.set("hadoop.user.group.static.mapping.overrides", "me=;user1=group1;user2=group1,group2");
        Groups groups = new Groups(this.conf);
        List userGroups = groups.getGroups("me");
        Assert.assertTrue((String)"non-empty groups for static user", (boolean)userGroups.isEmpty());
        Assert.assertFalse((String)"group lookup done for static user", (boolean)FakeunPrivilegedGroupMapping.invoked);
        ArrayList<String> expected = new ArrayList<String>();
        expected.add("group1");
        FakeunPrivilegedGroupMapping.invoked = false;
        userGroups = groups.getGroups("user1");
        Assert.assertTrue((String)"groups not correct", (boolean)expected.equals(userGroups));
        Assert.assertFalse((String)"group lookup done for unprivileged user", (boolean)FakeunPrivilegedGroupMapping.invoked);
        expected.add("group2");
        FakeunPrivilegedGroupMapping.invoked = false;
        userGroups = groups.getGroups("user2");
        Assert.assertTrue((String)"groups not correct", (boolean)expected.equals(userGroups));
        Assert.assertFalse((String)"group lookup done for unprivileged user", (boolean)FakeunPrivilegedGroupMapping.invoked);
    }

    public static class FakeunPrivilegedGroupMapping
    extends FakeGroupMapping {
        private static boolean invoked = false;

        @Override
        public List<String> getGroups(String user) throws IOException {
            invoked = true;
            return super.getGroups(user);
        }
    }

    public static class FakeGroupMapping
    extends ShellBasedUnixGroupsMapping {
        private static Set<String> allGroups = new HashSet<String>();
        private static Set<String> blackList = new HashSet<String>();

        public List<String> getGroups(String user) throws IOException {
            LOG.info((Object)("Getting groups for " + user));
            if (blackList.contains(user)) {
                return new LinkedList<String>();
            }
            return new LinkedList<String>(allGroups);
        }

        public void cacheGroupsRefresh() throws IOException {
            LOG.info((Object)"Cache is being refreshed.");
            FakeGroupMapping.clearBlackList();
        }

        public static void clearBlackList() throws IOException {
            LOG.info((Object)"Clearing the blacklist");
            blackList.clear();
        }

        public void cacheGroupsAdd(List<String> groups) throws IOException {
            LOG.info((Object)("Adding " + groups + " to groups."));
            allGroups.addAll(groups);
        }

        public static void addToBlackList(String user) throws IOException {
            LOG.info((Object)("Adding " + user + " to the blacklist"));
            blackList.add(user);
        }
    }
}

