/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.crypto.key;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.UUID;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.crypto.key.KeyShell;
import org.apache.hadoop.fs.Path;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestKeyShell {
    private final ByteArrayOutputStream outContent = new ByteArrayOutputStream();
    private final ByteArrayOutputStream errContent = new ByteArrayOutputStream();
    private PrintStream initialStdOut;
    private PrintStream initialStdErr;
    private String jceksProvider;

    @Before
    public void setup() throws Exception {
        this.outContent.reset();
        this.errContent.reset();
        File tmpDir = new File(System.getProperty("test.build.data", "target"), UUID.randomUUID().toString());
        if (!tmpDir.mkdirs()) {
            throw new IOException("Unable to create " + tmpDir);
        }
        Path jksPath = new Path(tmpDir.toString(), "keystore.jceks");
        this.jceksProvider = "jceks://file" + jksPath.toUri();
        this.initialStdOut = System.out;
        this.initialStdErr = System.err;
        System.setOut(new PrintStream(this.outContent));
        System.setErr(new PrintStream(this.errContent));
    }

    @After
    public void cleanUp() throws Exception {
        System.setOut(this.initialStdOut);
        System.setErr(this.initialStdErr);
    }

    private void deleteKey(KeyShell ks, String keyName) throws Exception {
        this.outContent.reset();
        String[] delArgs = new String[]{"delete", keyName, "-provider", this.jceksProvider};
        int rc = ks.run(delArgs);
        Assert.assertEquals((long)0L, (long)rc);
        Assert.assertTrue((boolean)this.outContent.toString().contains(keyName + " has been " + "successfully deleted."));
    }

    private String listKeys(KeyShell ks, boolean wantMetadata) throws Exception {
        this.outContent.reset();
        String[] listArgs = new String[]{"list", "-provider", this.jceksProvider};
        String[] listArgsM = new String[]{"list", "-metadata", "-provider", this.jceksProvider};
        int rc = ks.run(wantMetadata ? listArgsM : listArgs);
        Assert.assertEquals((long)0L, (long)rc);
        return this.outContent.toString();
    }

    @Test
    public void testKeySuccessfulKeyLifecycle() throws Exception {
        int rc = 0;
        String keyName = "key1";
        KeyShell ks = new KeyShell();
        ks.setConf(new Configuration());
        this.outContent.reset();
        String[] args1 = new String[]{"create", keyName, "-provider", this.jceksProvider};
        rc = ks.run(args1);
        Assert.assertEquals((long)0L, (long)rc);
        Assert.assertTrue((boolean)this.outContent.toString().contains(keyName + " has been " + "successfully created"));
        String listOut = this.listKeys(ks, false);
        Assert.assertTrue((boolean)listOut.contains(keyName));
        listOut = this.listKeys(ks, true);
        Assert.assertTrue((boolean)listOut.contains(keyName));
        Assert.assertTrue((boolean)listOut.contains("description"));
        Assert.assertTrue((boolean)listOut.contains("created"));
        this.outContent.reset();
        String[] args2 = new String[]{"roll", keyName, "-provider", this.jceksProvider};
        rc = ks.run(args2);
        Assert.assertEquals((long)0L, (long)rc);
        Assert.assertTrue((boolean)this.outContent.toString().contains("key1 has been successfully rolled."));
        this.deleteKey(ks, keyName);
        listOut = this.listKeys(ks, false);
        Assert.assertFalse((String)listOut, (boolean)listOut.contains(keyName));
    }

    @Test
    public void testKeySuccessfulCreationWithDescription() throws Exception {
        this.outContent.reset();
        String[] args1 = new String[]{"create", "key1", "-provider", this.jceksProvider, "-description", "someDescription"};
        int rc = 0;
        KeyShell ks = new KeyShell();
        ks.setConf(new Configuration());
        rc = ks.run(args1);
        Assert.assertEquals((long)0L, (long)rc);
        Assert.assertTrue((boolean)this.outContent.toString().contains("key1 has been successfully created"));
        String listOut = this.listKeys(ks, true);
        Assert.assertTrue((boolean)listOut.contains("description"));
        Assert.assertTrue((boolean)listOut.contains("someDescription"));
    }

    @Test
    public void testInvalidKeySize() throws Exception {
        String[] args1 = new String[]{"create", "key1", "-size", "56", "-provider", this.jceksProvider};
        int rc = 0;
        KeyShell ks = new KeyShell();
        ks.setConf(new Configuration());
        rc = ks.run(args1);
        Assert.assertEquals((long)1L, (long)rc);
        Assert.assertTrue((boolean)this.outContent.toString().contains("key1 has not been created."));
    }

    @Test
    public void testInvalidCipher() throws Exception {
        String[] args1 = new String[]{"create", "key1", "-cipher", "LJM", "-provider", this.jceksProvider};
        int rc = 0;
        KeyShell ks = new KeyShell();
        ks.setConf(new Configuration());
        rc = ks.run(args1);
        Assert.assertEquals((long)1L, (long)rc);
        Assert.assertTrue((boolean)this.outContent.toString().contains("key1 has not been created."));
    }

    @Test
    public void testInvalidProvider() throws Exception {
        String[] args1 = new String[]{"create", "key1", "-cipher", "AES", "-provider", "sdff://file/tmp/keystore.jceks"};
        int rc = 0;
        KeyShell ks = new KeyShell();
        ks.setConf(new Configuration());
        rc = ks.run(args1);
        Assert.assertEquals((long)1L, (long)rc);
        Assert.assertTrue((boolean)this.outContent.toString().contains("There are no valid KeyProviders configured."));
    }

    @Test
    public void testTransientProviderWarning() throws Exception {
        String[] args1 = new String[]{"create", "key1", "-cipher", "AES", "-provider", "user:///"};
        int rc = 0;
        KeyShell ks = new KeyShell();
        ks.setConf(new Configuration());
        rc = ks.run(args1);
        Assert.assertEquals((long)0L, (long)rc);
        Assert.assertTrue((boolean)this.outContent.toString().contains("WARNING: you are modifying a transient provider."));
    }

    @Test
    public void testTransientProviderOnlyConfig() throws Exception {
        String[] args1 = new String[]{"create", "key1"};
        int rc = 0;
        KeyShell ks = new KeyShell();
        Configuration config = new Configuration();
        config.set("hadoop.security.key.provider.path", "user:///");
        ks.setConf(config);
        rc = ks.run(args1);
        Assert.assertEquals((long)1L, (long)rc);
        Assert.assertTrue((boolean)this.outContent.toString().contains("There are no valid KeyProviders configured."));
    }

    @Test
    public void testFullCipher() throws Exception {
        String keyName = "key1";
        String[] args1 = new String[]{"create", "key1", "-cipher", "AES/CBC/pkcs5Padding", "-provider", this.jceksProvider};
        int rc = 0;
        KeyShell ks = new KeyShell();
        ks.setConf(new Configuration());
        rc = ks.run(args1);
        Assert.assertEquals((long)0L, (long)rc);
        Assert.assertTrue((boolean)this.outContent.toString().contains("key1 has been successfully created"));
        this.deleteKey(ks, "key1");
    }

    @Test
    public void testAttributes() throws Exception {
        KeyShell ks = new KeyShell();
        ks.setConf(new Configuration());
        String[] args1 = new String[]{"create", "keyattr1", "-provider", this.jceksProvider, "-attr", "foo=bar"};
        int rc = ks.run(args1);
        Assert.assertEquals((long)0L, (long)rc);
        Assert.assertTrue((boolean)this.outContent.toString().contains("keyattr1 has been successfully created"));
        String listOut = this.listKeys(ks, true);
        Assert.assertTrue((boolean)listOut.contains("keyattr1"));
        Assert.assertTrue((boolean)listOut.contains("attributes: [foo=bar]"));
        this.outContent.reset();
        String[] args2 = new String[]{"create", "keyattr2", "-provider", this.jceksProvider, "-attr", "=bar"};
        rc = ks.run(args2);
        Assert.assertEquals((long)1L, (long)rc);
        this.outContent.reset();
        args2[5] = "foo";
        rc = ks.run(args2);
        Assert.assertEquals((long)1L, (long)rc);
        this.outContent.reset();
        args2[5] = "=";
        rc = ks.run(args2);
        Assert.assertEquals((long)1L, (long)rc);
        this.outContent.reset();
        args2[5] = "a=b=c";
        rc = ks.run(args2);
        Assert.assertEquals((long)0L, (long)rc);
        listOut = this.listKeys(ks, true);
        Assert.assertTrue((boolean)listOut.contains("keyattr2"));
        Assert.assertTrue((boolean)listOut.contains("attributes: [a=b=c]"));
        this.outContent.reset();
        String[] args3 = new String[]{"create", "keyattr3", "-provider", this.jceksProvider, "-attr", "foo = bar", "-attr", " glarch =baz  ", "-attr", "abc=def"};
        rc = ks.run(args3);
        Assert.assertEquals((long)0L, (long)rc);
        listOut = this.listKeys(ks, true);
        Assert.assertTrue((boolean)listOut.contains("keyattr3"));
        Assert.assertTrue((boolean)listOut.contains("[foo=bar]"));
        Assert.assertTrue((boolean)listOut.contains("[glarch=baz]"));
        Assert.assertTrue((boolean)listOut.contains("[abc=def]"));
        this.outContent.reset();
        String[] args4 = new String[]{"create", "keyattr4", "-provider", this.jceksProvider, "-attr", "foo=bar", "-attr", "foo=glarch"};
        rc = ks.run(args4);
        Assert.assertEquals((long)1L, (long)rc);
        this.deleteKey(ks, "keyattr1");
        this.deleteKey(ks, "keyattr2");
        this.deleteKey(ks, "keyattr3");
    }
}

