/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.jmx;

import java.net.URL;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.http.HttpServer2;
import org.apache.hadoop.http.HttpServerFunctionalTest;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestJMXJsonServlet
extends HttpServerFunctionalTest {
    private static final Log LOG = LogFactory.getLog(TestJMXJsonServlet.class);
    private static HttpServer2 server;
    private static URL baseUrl;

    @BeforeClass
    public static void setup() throws Exception {
        server = TestJMXJsonServlet.createTestServer();
        server.start();
        baseUrl = TestJMXJsonServlet.getServerURL(server);
    }

    @AfterClass
    public static void cleanup() throws Exception {
        server.stop();
    }

    public static void assertReFind(String re, String value) {
        Pattern p = Pattern.compile(re);
        Matcher m = p.matcher(value);
        TestJMXJsonServlet.assertTrue((String)("'" + p + "' does not match " + value), (boolean)m.find());
    }

    @Test
    public void testQury() throws Exception {
        String result = TestJMXJsonServlet.readOutput(new URL(baseUrl, "/jmx?qry=java.lang:type=Runtime"));
        LOG.info((Object)("/jmx?qry=java.lang:type=Runtime RESULT: " + result));
        TestJMXJsonServlet.assertReFind("\"name\"\\s*:\\s*\"java.lang:type=Runtime\"", result);
        TestJMXJsonServlet.assertReFind("\"modelerType\"", result);
        result = TestJMXJsonServlet.readOutput(new URL(baseUrl, "/jmx?qry=java.lang:type=Memory"));
        LOG.info((Object)("/jmx?qry=java.lang:type=Memory RESULT: " + result));
        TestJMXJsonServlet.assertReFind("\"name\"\\s*:\\s*\"java.lang:type=Memory\"", result);
        TestJMXJsonServlet.assertReFind("\"modelerType\"", result);
        result = TestJMXJsonServlet.readOutput(new URL(baseUrl, "/jmx"));
        LOG.info((Object)("/jmx RESULT: " + result));
        TestJMXJsonServlet.assertReFind("\"name\"\\s*:\\s*\"java.lang:type=Memory\"", result);
        result = TestJMXJsonServlet.readOutput(new URL(baseUrl, "/jmx?get=java.lang:type=Memory::HeapMemoryUsage"));
        LOG.info((Object)("/jmx RESULT: " + result));
        TestJMXJsonServlet.assertReFind("\"name\"\\s*:\\s*\"java.lang:type=Memory\"", result);
        TestJMXJsonServlet.assertReFind("\"committed\"\\s*:", result);
        result = TestJMXJsonServlet.readOutput(new URL(baseUrl, "/jmx?get=java.lang:type=Memory::"));
        LOG.info((Object)("/jmx RESULT: " + result));
        TestJMXJsonServlet.assertReFind("\"ERROR\"", result);
        result = TestJMXJsonServlet.readOutput(new URL(baseUrl, "/jmx?qry=java.lang:type=Memory&callback=mycallback1"));
        LOG.info((Object)("/jmx?qry=java.lang:type=Memory&callback=mycallback RESULT: " + result));
        TestJMXJsonServlet.assertReFind("^mycallback1\\(\\{", result);
        TestJMXJsonServlet.assertReFind("\\}\\);$", result);
        result = TestJMXJsonServlet.readOutput(new URL(baseUrl, "/jmx?get=java.lang:type=Memory::&callback=mycallback2"));
        LOG.info((Object)("/jmx RESULT: " + result));
        TestJMXJsonServlet.assertReFind("^mycallback2\\(\\{", result);
        TestJMXJsonServlet.assertReFind("\"ERROR\"", result);
        TestJMXJsonServlet.assertReFind("\\}\\);$", result);
        result = TestJMXJsonServlet.readOutput(new URL(baseUrl, "/jmx?get=java.lang:type=Memory::HeapMemoryUsage&callback=mycallback3"));
        LOG.info((Object)("/jmx RESULT: " + result));
        TestJMXJsonServlet.assertReFind("^mycallback3\\(\\{", result);
        TestJMXJsonServlet.assertReFind("\"name\"\\s*:\\s*\"java.lang:type=Memory\"", result);
        TestJMXJsonServlet.assertReFind("\"committed\"\\s*:", result);
        TestJMXJsonServlet.assertReFind("\\}\\);$", result);
    }
}

