/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ha;

import com.google.common.base.Preconditions;
import com.google.common.primitives.Ints;
import java.io.IOException;
import java.net.InetSocketAddress;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.ha.ActiveStandbyElector;
import org.apache.hadoop.ha.ActiveStandbyElectorTestUtil;
import org.apache.hadoop.ha.DummyHAService;
import org.apache.hadoop.ha.DummySharedResource;
import org.apache.hadoop.ha.HAServiceProtocol;
import org.apache.hadoop.ha.HAServiceTarget;
import org.apache.hadoop.ha.HealthMonitor;
import org.apache.hadoop.ha.ZKFCTestUtil;
import org.apache.hadoop.ha.ZKFailoverController;
import org.apache.hadoop.security.AccessControlException;
import org.apache.hadoop.security.authorize.PolicyProvider;
import org.apache.hadoop.test.MultithreadedTestUtil;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.data.Stat;
import org.apache.zookeeper.server.ZooKeeperServer;
import org.junit.Assert;

public class MiniZKFCCluster {
    private final MultithreadedTestUtil.TestContext ctx;
    private final ZooKeeperServer zks;
    private DummyHAService[] svcs;
    private DummyZKFCThread[] thrs;
    private Configuration conf;
    private DummySharedResource sharedResource = new DummySharedResource();
    private static final Log LOG = LogFactory.getLog(MiniZKFCCluster.class);

    public MiniZKFCCluster(Configuration conf, ZooKeeperServer zks) {
        this.conf = conf;
        conf.setInt("ha.health-monitor.check-interval.ms", 50);
        conf.setInt("ha.health-monitor.connect-retry-interval.ms", 50);
        conf.setInt("ha.health-monitor.sleep-after-disconnect.ms", 50);
        this.svcs = new DummyHAService[2];
        this.svcs[0] = new DummyHAService(HAServiceProtocol.HAServiceState.INITIALIZING, new InetSocketAddress("svc1", 1234));
        this.svcs[0].setSharedResource(this.sharedResource);
        this.svcs[1] = new DummyHAService(HAServiceProtocol.HAServiceState.INITIALIZING, new InetSocketAddress("svc2", 1234));
        this.svcs[1].setSharedResource(this.sharedResource);
        this.ctx = new MultithreadedTestUtil.TestContext();
        this.zks = zks;
    }

    public void start() throws Exception {
        this.thrs = new DummyZKFCThread[2];
        this.thrs[0] = new DummyZKFCThread(this.ctx, this.svcs[0]);
        Assert.assertEquals((long)0L, (long)this.thrs[0].zkfc.run(new String[]{"-formatZK"}));
        this.ctx.addThread(this.thrs[0]);
        this.thrs[0].start();
        LOG.info((Object)"Waiting for svc0 to enter active state");
        this.waitForHAState(0, HAServiceProtocol.HAServiceState.ACTIVE);
        LOG.info((Object)"Adding svc1");
        this.thrs[1] = new DummyZKFCThread(this.ctx, this.svcs[1]);
        this.thrs[1].start();
        this.waitForHAState(1, HAServiceProtocol.HAServiceState.STANDBY);
    }

    public void stop() throws Exception {
        for (DummyZKFCThread thr : this.thrs) {
            if (thr == null) continue;
            thr.interrupt();
        }
        if (this.ctx != null) {
            this.ctx.stop();
        }
        this.sharedResource.assertNoViolations();
    }

    public MultithreadedTestUtil.TestContext getTestContext() {
        return this.ctx;
    }

    public DummyHAService getService(int i) {
        return this.svcs[i];
    }

    public ActiveStandbyElector getElector(int i) {
        return this.thrs[i].zkfc.getElectorForTests();
    }

    public DummyZKFC getZkfc(int i) {
        return this.thrs[i].zkfc;
    }

    public void setHealthy(int idx, boolean healthy) {
        this.svcs[idx].isHealthy = healthy;
    }

    public void setFailToBecomeActive(int idx, boolean doFail) {
        this.svcs[idx].failToBecomeActive = doFail;
    }

    public void setFailToBecomeStandby(int idx, boolean doFail) {
        this.svcs[idx].failToBecomeStandby = doFail;
    }

    public void setFailToFence(int idx, boolean doFail) {
        this.svcs[idx].failToFence = doFail;
    }

    public void setUnreachable(int idx, boolean unreachable) {
        this.svcs[idx].actUnreachable = unreachable;
    }

    public void waitForHAState(int idx, HAServiceProtocol.HAServiceState state) throws Exception {
        DummyZKFC svc = this.getZkfc(idx);
        while (svc.getServiceState() != state) {
            this.ctx.checkException();
            Thread.sleep(50L);
        }
    }

    public void waitForHealthState(int idx, HealthMonitor.State state) throws Exception {
        ZKFCTestUtil.waitForHealthState(this.thrs[idx].zkfc, state, this.ctx);
    }

    public void waitForElectorState(int idx, ActiveStandbyElector.State state) throws Exception {
        ActiveStandbyElectorTestUtil.waitForElectorState(this.ctx, this.getElector(idx), state);
    }

    public void expireActiveLockHolder(int idx) throws KeeperException.NoNodeException {
        Stat stat = new Stat();
        byte[] data = this.zks.getZKDatabase().getData("/hadoop-ha/dummy-cluster/ActiveStandbyElectorLock", stat, null);
        Assert.assertArrayEquals((byte[])Ints.toByteArray((int)this.svcs[idx].index), (byte[])data);
        long session = stat.getEphemeralOwner();
        LOG.info((Object)("Expiring svc " + idx + "'s zookeeper session " + session));
        this.zks.closeSession(session);
    }

    public void waitForActiveLockHolder(Integer idx) throws Exception {
        DummyHAService svc = idx == null ? null : this.svcs[idx];
        ActiveStandbyElectorTestUtil.waitForActiveLockData(this.ctx, this.zks, "/hadoop-ha/dummy-cluster", idx == null ? null : Ints.toByteArray((int)svc.index));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void expireAndVerifyFailover(int fromIdx, int toIdx) throws Exception {
        Preconditions.checkArgument((fromIdx != toIdx ? 1 : 0) != 0);
        this.getElector(fromIdx).preventSessionReestablishmentForTests();
        try {
            this.expireActiveLockHolder(fromIdx);
            this.waitForHAState(fromIdx, HAServiceProtocol.HAServiceState.STANDBY);
            this.waitForHAState(toIdx, HAServiceProtocol.HAServiceState.ACTIVE);
        }
        finally {
            this.getElector(fromIdx).allowSessionReestablishmentForTests();
        }
    }

    static class DummyZKFC
    extends ZKFailoverController {
        private static final String DUMMY_CLUSTER = "dummy-cluster";
        public static final String SCOPED_PARENT_ZNODE = "/hadoop-ha/dummy-cluster";
        private static final String LOCK_ZNODE = "/hadoop-ha/dummy-cluster/ActiveStandbyElectorLock";
        private final DummyHAService localTarget;

        public DummyZKFC(Configuration conf, DummyHAService localTarget) {
            super(conf, (HAServiceTarget)localTarget);
            this.localTarget = localTarget;
        }

        protected byte[] targetToData(HAServiceTarget target) {
            return Ints.toByteArray((int)((DummyHAService)target).index);
        }

        protected HAServiceTarget dataToTarget(byte[] data) {
            int index = Ints.fromByteArray((byte[])data);
            return DummyHAService.getInstance(index);
        }

        protected void loginAsFCUser() throws IOException {
        }

        protected String getScopeInsideParentNode() {
            return DUMMY_CLUSTER;
        }

        protected void checkRpcAdminAccess() throws AccessControlException {
        }

        protected InetSocketAddress getRpcAddressToBindTo() {
            return new InetSocketAddress(0);
        }

        protected void initRPC() throws IOException {
            super.initRPC();
            this.localTarget.zkfcProxy = this.getRpcServerForTests();
        }

        protected PolicyProvider getPolicyProvider() {
            return null;
        }
    }

    private class DummyZKFCThread
    extends MultithreadedTestUtil.TestingThread {
        private final DummyZKFC zkfc;

        public DummyZKFCThread(MultithreadedTestUtil.TestContext ctx, DummyHAService svc) {
            super(ctx);
            this.zkfc = new DummyZKFC(MiniZKFCCluster.this.conf, svc);
        }

        @Override
        public void doWork() throws Exception {
            try {
                Assert.assertEquals((long)0L, (long)this.zkfc.run(new String[0]));
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }
}

