/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.io;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Random;
import junit.framework.TestCase;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.ByteWritable;
import org.apache.hadoop.io.DataInputBuffer;
import org.apache.hadoop.io.DataOutputBuffer;
import org.apache.hadoop.io.DoubleWritable;
import org.apache.hadoop.io.ShortWritable;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.io.WritableComparator;
import org.apache.hadoop.util.ReflectionUtils;

public class TestWritable
extends TestCase {
    private static final String TEST_CONFIG_PARAM = "frob.test";
    private static final String TEST_CONFIG_VALUE = "test";
    private static final String TEST_WRITABLE_CONFIG_PARAM = "test.writable";
    private static final String TEST_WRITABLE_CONFIG_VALUE = "test";

    public TestWritable(String name) {
        super(name);
    }

    public void testSimpleWritable() throws Exception {
        TestWritable.testWritable(new SimpleWritable());
    }

    public void testByteWritable() throws Exception {
        TestWritable.testWritable((Writable)new ByteWritable(-128));
    }

    public void testShortWritable() throws Exception {
        TestWritable.testWritable((Writable)new ShortWritable(0));
    }

    public void testDoubleWritable() throws Exception {
        TestWritable.testWritable((Writable)new DoubleWritable(1.0));
    }

    public static Writable testWritable(Writable before) throws Exception {
        return TestWritable.testWritable(before, null);
    }

    public static Writable testWritable(Writable before, Configuration conf) throws Exception {
        DataOutputBuffer dob = new DataOutputBuffer();
        before.write((DataOutput)dob);
        DataInputBuffer dib = new DataInputBuffer();
        dib.reset(dob.getData(), dob.getLength());
        Writable after = (Writable)ReflectionUtils.newInstance(before.getClass(), (Configuration)conf);
        after.readFields((DataInput)dib);
        TestWritable.assertEquals((Object)before, (Object)after);
        return after;
    }

    public static void testGetComparator() throws Exception {
        Configuration conf = new Configuration();
        WritableComparator frobComparator = WritableComparator.get(Frob.class);
        assert (frobComparator instanceof FrobComparator);
        TestWritable.assertNotNull((Object)frobComparator.getConf());
        TestWritable.assertNull((Object)frobComparator.getConf().get(TEST_CONFIG_PARAM));
        conf.set(TEST_CONFIG_PARAM, "test");
        frobComparator = WritableComparator.get(Frob.class, (Configuration)conf);
        assert (frobComparator instanceof FrobComparator);
        TestWritable.assertNotNull((Object)frobComparator.getConf());
        TestWritable.assertEquals((String)conf.get(TEST_CONFIG_PARAM), (String)"test");
        frobComparator = WritableComparator.get(Frob.class);
        assert (frobComparator instanceof FrobComparator);
        TestWritable.assertNotNull((Object)frobComparator.getConf());
        TestWritable.assertEquals((String)conf.get(TEST_CONFIG_PARAM), (String)"test");
        frobComparator = WritableComparator.get(Frob.class, (Configuration)new Configuration());
        assert (frobComparator instanceof FrobComparator);
        TestWritable.assertNotNull((Object)frobComparator.getConf());
        TestWritable.assertNull((Object)frobComparator.getConf().get(TEST_CONFIG_PARAM));
    }

    public void testShortWritableComparator() throws Exception {
        ShortWritable writable1 = new ShortWritable(256);
        ShortWritable writable2 = new ShortWritable(128);
        ShortWritable writable3 = new ShortWritable(256);
        String SHOULD_NOT_MATCH_WITH_RESULT_ONE = "Result should be 1, should not match the writables";
        TestWritable.assertTrue((String)"Result should be 1, should not match the writables", (writable1.compareTo(writable2) == 1 ? 1 : 0) != 0);
        TestWritable.assertTrue((String)"Result should be 1, should not match the writables", (WritableComparator.get(ShortWritable.class).compare((WritableComparable)writable1, (WritableComparable)writable2) == 1 ? 1 : 0) != 0);
        String SHOULD_NOT_MATCH_WITH_RESULT_MINUS_ONE = "Result should be -1, should not match the writables";
        TestWritable.assertTrue((String)"Result should be -1, should not match the writables", (writable2.compareTo(writable1) == -1 ? 1 : 0) != 0);
        TestWritable.assertTrue((String)"Result should be -1, should not match the writables", (WritableComparator.get(ShortWritable.class).compare((WritableComparable)writable2, (WritableComparable)writable1) == -1 ? 1 : 0) != 0);
        String SHOULD_MATCH = "Result should be 0, should match the writables";
        TestWritable.assertTrue((String)"Result should be 0, should match the writables", (writable1.compareTo(writable1) == 0 ? 1 : 0) != 0);
        TestWritable.assertTrue((String)"Result should be 0, should match the writables", (WritableComparator.get(ShortWritable.class).compare((WritableComparable)writable1, (WritableComparable)writable3) == 0 ? 1 : 0) != 0);
    }

    public void testConfigurableWritableComparator() throws Exception {
        Configuration conf = new Configuration();
        conf.set(TEST_WRITABLE_CONFIG_PARAM, "test");
        WritableComparator wc = WritableComparator.get(SimpleWritableComparable.class, (Configuration)conf);
        SimpleWritableComparable key = (SimpleWritableComparable)wc.newKey();
        TestWritable.assertNotNull((Object)wc.getConf());
        TestWritable.assertNotNull((Object)key.getConf());
        TestWritable.assertEquals((String)key.getConf().get(TEST_WRITABLE_CONFIG_PARAM), (String)"test");
    }

    private static class Frob
    implements WritableComparable<Frob> {
        private Frob() {
        }

        public void write(DataOutput out) throws IOException {
        }

        public void readFields(DataInput in) throws IOException {
        }

        public int compareTo(Frob o) {
            return 0;
        }

        static {
            WritableComparator.define(Frob.class, (WritableComparator)new FrobComparator());
        }
    }

    private static class FrobComparator
    extends WritableComparator {
        public FrobComparator() {
            super(Frob.class);
        }

        public int compare(byte[] b1, int s1, int l1, byte[] b2, int s2, int l2) {
            return 0;
        }
    }

    public static class SimpleWritableComparable
    extends SimpleWritable
    implements WritableComparable<SimpleWritableComparable>,
    Configurable {
        private Configuration conf;

        public void setConf(Configuration conf) {
            this.conf = conf;
        }

        public Configuration getConf() {
            return this.conf;
        }

        public int compareTo(SimpleWritableComparable o) {
            return this.state - o.state;
        }
    }

    public static class SimpleWritable
    implements Writable {
        private static final Random RANDOM = new Random();
        int state = RANDOM.nextInt();

        public void write(DataOutput out) throws IOException {
            out.writeInt(this.state);
        }

        public void readFields(DataInput in) throws IOException {
            this.state = in.readInt();
        }

        public static SimpleWritable read(DataInput in) throws IOException {
            SimpleWritable result = new SimpleWritable();
            result.readFields(in);
            return result;
        }

        public boolean equals(Object o) {
            if (!(o instanceof SimpleWritable)) {
                return false;
            }
            SimpleWritable other = (SimpleWritable)o;
            return this.state == other.state;
        }
    }
}

