/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.loadGenerator;

import com.google.common.base.Preconditions;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.Random;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.fs.CreateFlag;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileContext;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Options;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.loadGenerator.DataGenerator;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.util.Time;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;

public class LoadGenerator
extends Configured
implements Tool {
    public static final Log LOG = LogFactory.getLog(LoadGenerator.class);
    private volatile boolean shouldRun = true;
    private Path root = DataGenerator.DEFAULT_ROOT;
    private FileContext fc;
    private int maxDelayBetweenOps = 0;
    private int numOfThreads = 200;
    private long[] durations = new long[]{0L};
    private double[] readProbs = new double[]{0.3333};
    private double[] writeProbs = new double[]{0.3333};
    private volatile int currentIndex = 0;
    long totalTime = 0L;
    private long startTime = Time.now() + 10000L;
    private static final int BLOCK_SIZE = 10;
    private ArrayList<String> files = new ArrayList();
    private ArrayList<String> dirs = new ArrayList();
    private Random r = null;
    private static final String USAGE = "java LoadGenerator\n-readProbability <read probability>\n-writeProbability <write probability>\n-root <root>\n-maxDelayBetweenOps <maxDelayBetweenOpsInMillis>\n-numOfThreads <numOfThreads>\n-elapsedTime <elapsedTimeInSecs>\n-startTime <startTimeInMillis>\n-scriptFile <filename>";
    private final String hostname;
    private final byte[] WRITE_CONTENTS = new byte[4096];
    private static final int ERR_TEST_FAILED = 2;
    private static final int OPEN = 0;
    private static final int LIST = 1;
    private static final int CREATE = 2;
    private static final int WRITE_CLOSE = 3;
    private static final int DELETE = 4;
    private static final int TOTAL_OP_TYPES = 5;
    private long[] executionTime = new long[5];
    private long[] totalNumOfOps = new long[5];

    public LoadGenerator() throws IOException, UnknownHostException {
        InetAddress addr = InetAddress.getLocalHost();
        this.hostname = addr.getHostName();
        Arrays.fill(this.WRITE_CONTENTS, (byte)97);
    }

    public int run(String[] args) throws Exception {
        int exitCode = this.init(args);
        if (exitCode != 0) {
            return exitCode;
        }
        this.barrier();
        DFSClientThread[] threads = new DFSClientThread[this.numOfThreads];
        for (int i = 0; i < this.numOfThreads; ++i) {
            threads[i] = new DFSClientThread(i);
            threads[i].start();
        }
        if (this.durations[0] > 0L) {
            while (this.shouldRun) {
                Thread.sleep(this.durations[this.currentIndex] * 1000L);
                this.totalTime += this.durations[this.currentIndex];
                if (this.currentIndex + 1 == this.durations.length) {
                    this.shouldRun = false;
                    continue;
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Moving to index " + this.currentIndex + ": r = " + this.readProbs[this.currentIndex] + ", w = " + this.writeProbs + " for duration " + this.durations[this.currentIndex]));
                }
                ++this.currentIndex;
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Done with testing.  Waiting for threads to finish.");
        }
        boolean failed = false;
        for (DFSClientThread thread : threads) {
            thread.join();
            for (int i = 0; i < 5; ++i) {
                int n = i;
                this.executionTime[n] = this.executionTime[n] + thread.executionTime[i];
                int n2 = i;
                this.totalNumOfOps[n2] = this.totalNumOfOps[n2] + thread.totalNumOfOps[i];
            }
            failed = failed || thread.failed;
        }
        if (failed) {
            exitCode = -2;
        }
        long totalOps = 0L;
        for (int i = 0; i < 5; ++i) {
            totalOps += this.totalNumOfOps[i];
        }
        if (this.totalNumOfOps[0] != 0L) {
            System.out.println("Average open execution time: " + (double)this.executionTime[0] / (double)this.totalNumOfOps[0] + "ms");
        }
        if (this.totalNumOfOps[1] != 0L) {
            System.out.println("Average list execution time: " + (double)this.executionTime[1] / (double)this.totalNumOfOps[1] + "ms");
        }
        if (this.totalNumOfOps[4] != 0L) {
            System.out.println("Average deletion execution time: " + (double)this.executionTime[4] / (double)this.totalNumOfOps[4] + "ms");
            System.out.println("Average create execution time: " + (double)this.executionTime[2] / (double)this.totalNumOfOps[2] + "ms");
            System.out.println("Average write_close execution time: " + (double)this.executionTime[3] / (double)this.totalNumOfOps[3] + "ms");
        }
        if (this.durations[0] != 0L) {
            System.out.println("Average operations per second: " + (double)totalOps / (double)this.totalTime + "ops/s");
        }
        System.out.println();
        return exitCode;
    }

    private int init(String[] args) throws IOException {
        int i;
        try {
            this.fc = FileContext.getFileContext((Configuration)this.getConf());
        }
        catch (IOException ioe) {
            System.err.println("Can not initialize the file system: " + ioe.getLocalizedMessage());
            return -1;
        }
        int hostHashCode = this.hostname.hashCode();
        boolean scriptSpecified = false;
        try {
            for (i = 0; i < args.length; ++i) {
                if (args[i].equals("-scriptFile")) {
                    if (this.loadScriptFile(args[++i]) == -1) {
                        return -1;
                    }
                    scriptSpecified = true;
                    continue;
                }
                if (args[i].equals("-readProbability")) {
                    if (scriptSpecified) {
                        System.err.println("Can't specify probabilities and use script.");
                        return -1;
                    }
                    this.readProbs[0] = Double.parseDouble(args[++i]);
                    if (!(this.readProbs[0] < 0.0) && !(this.readProbs[0] > 1.0)) continue;
                    System.err.println("The read probability must be [0, 1]: " + this.readProbs[0]);
                    return -1;
                }
                if (args[i].equals("-writeProbability")) {
                    if (scriptSpecified) {
                        System.err.println("Can't specify probabilities and use script.");
                        return -1;
                    }
                    this.writeProbs[0] = Double.parseDouble(args[++i]);
                    if (!(this.writeProbs[0] < 0.0) && !(this.writeProbs[0] > 1.0)) continue;
                    System.err.println("The write probability must be [0, 1]: " + this.writeProbs[0]);
                    return -1;
                }
                if (args[i].equals("-root")) {
                    this.root = new Path(args[++i]);
                    continue;
                }
                if (args[i].equals("-maxDelayBetweenOps")) {
                    this.maxDelayBetweenOps = Integer.parseInt(args[++i]);
                    continue;
                }
                if (args[i].equals("-numOfThreads")) {
                    this.numOfThreads = Integer.parseInt(args[++i]);
                    if (this.numOfThreads > 0) continue;
                    System.err.println("Number of threads must be positive: " + this.numOfThreads);
                    return -1;
                }
                if (args[i].equals("-startTime")) {
                    this.startTime = Long.parseLong(args[++i]);
                    continue;
                }
                if (args[i].equals("-elapsedTime")) {
                    if (scriptSpecified) {
                        System.err.println("Can't specify elapsedTime and use script.");
                        return -1;
                    }
                    this.durations[0] = Long.parseLong(args[++i]);
                    continue;
                }
                if (args[i].equals("-seed")) {
                    this.r = new Random(Long.parseLong(args[++i]) + (long)hostHashCode);
                    continue;
                }
                System.err.println(USAGE);
                ToolRunner.printGenericCommandUsage((PrintStream)System.err);
                return -1;
            }
        }
        catch (NumberFormatException e) {
            System.err.println("Illegal parameter: " + e.getLocalizedMessage());
            System.err.println(USAGE);
            return -1;
        }
        for (i = 0; i < this.readProbs.length; ++i) {
            if (!(this.readProbs[i] + this.writeProbs[i] < 0.0) && !(this.readProbs[i] + this.writeProbs[i] > 1.0)) continue;
            System.err.println("The sum of read probability and write probability must be [0, 1]: " + this.readProbs[i] + " " + this.writeProbs[i]);
            return -1;
        }
        if (this.r == null) {
            this.r = new Random(Time.now() + (long)hostHashCode);
        }
        return this.initFileDirTables();
    }

    private static void parseScriptLine(String line, ArrayList<Long> duration, ArrayList<Double> readProb, ArrayList<Double> writeProb) {
        String[] a = line.split("\\s");
        if (a.length != 3) {
            throw new IllegalArgumentException("Incorrect number of parameters: " + line);
        }
        try {
            long d = Long.parseLong(a[0]);
            double r = Double.parseDouble(a[1]);
            double w = Double.parseDouble(a[2]);
            Preconditions.checkArgument((d >= 0L ? 1 : 0) != 0, (Object)("Invalid duration: " + d));
            Preconditions.checkArgument((0.0 <= r && r <= 1.0 ? 1 : 0) != 0, (Object)("The read probability must be [0, 1]: " + r));
            Preconditions.checkArgument((0.0 <= w && w <= 1.0 ? 1 : 0) != 0, (Object)("The read probability must be [0, 1]: " + w));
            readProb.add(r);
            duration.add(d);
            writeProb.add(w);
        }
        catch (NumberFormatException nfe) {
            throw new IllegalArgumentException("Cannot parse: " + line);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int loadScriptFile(String filename) throws IOException {
        FileReader fr = new FileReader(new File(filename));
        BufferedReader br = new BufferedReader(fr);
        ArrayList<Long> duration = new ArrayList<Long>();
        ArrayList<Double> readProb = new ArrayList<Double>();
        ArrayList<Double> writeProb = new ArrayList<Double>();
        int lineNum = 0;
        try {
            String line;
            while ((line = br.readLine()) != null) {
                ++lineNum;
                if (line.startsWith("#") || line.isEmpty()) continue;
                LoadGenerator.parseScriptLine(line, duration, readProb, writeProb);
            }
        }
        catch (IllegalArgumentException e) {
            int n;
            try {
                System.err.println("Line: " + lineNum + ", " + e.getMessage());
                n = -1;
            }
            catch (Throwable throwable) {
                IOUtils.cleanup((Log)LOG, (Closeable[])new Closeable[]{br});
                throw throwable;
            }
            IOUtils.cleanup((Log)LOG, (Closeable[])new Closeable[]{br});
            return n;
        }
        IOUtils.cleanup((Log)LOG, (Closeable[])new Closeable[]{br});
        this.durations = new long[duration.size()];
        this.readProbs = new double[readProb.size()];
        this.writeProbs = new double[writeProb.size()];
        for (int i = 0; i < this.durations.length; ++i) {
            this.durations[i] = duration.get(i);
            this.readProbs[i] = readProb.get(i);
            this.writeProbs[i] = writeProb.get(i);
        }
        if (this.durations[0] == 0L) {
            System.err.println("Initial duration set to 0.  Will loop until stopped manually.");
        }
        return 0;
    }

    private int initFileDirTables() {
        try {
            this.initFileDirTables(this.root);
        }
        catch (IOException e) {
            System.err.println(e.getLocalizedMessage());
            e.printStackTrace();
            return -1;
        }
        if (this.dirs.isEmpty()) {
            System.err.println("The test space " + this.root + " is empty");
            return -1;
        }
        if (this.files.isEmpty()) {
            System.err.println("The test space " + this.root + " does not have any file");
            return -1;
        }
        return 0;
    }

    private void initFileDirTables(Path path) throws IOException {
        FileStatus[] stats;
        for (FileStatus stat : stats = this.fc.util().listStatus(path)) {
            if (stat.isDirectory()) {
                this.dirs.add(stat.getPath().toString());
                this.initFileDirTables(stat.getPath());
                continue;
            }
            Path filePath = stat.getPath();
            if (!filePath.getName().startsWith("_file_")) continue;
            this.files.add(filePath.toString());
        }
    }

    private void barrier() {
        long sleepTime;
        while ((sleepTime = this.startTime - Time.now()) > 0L) {
            try {
                Thread.sleep(sleepTime);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public static void main(String[] args) throws Exception {
        int res = ToolRunner.run((Configuration)new Configuration(), (Tool)new LoadGenerator(), (String[])args);
        System.exit(res);
    }

    private class DFSClientThread
    extends Thread {
        private int id;
        private long[] executionTime = new long[5];
        private long[] totalNumOfOps = new long[5];
        private byte[] buffer = new byte[1024];
        private boolean failed;

        private DFSClientThread(int id) {
            this.id = id;
        }

        @Override
        public void run() {
            try {
                while (LoadGenerator.this.shouldRun) {
                    this.nextOp();
                    this.delay();
                }
            }
            catch (Exception ioe) {
                System.err.println(ioe.getLocalizedMessage());
                ioe.printStackTrace();
                this.failed = true;
            }
        }

        private void delay() throws InterruptedException {
            if (LoadGenerator.this.maxDelayBetweenOps > 0) {
                int delay = LoadGenerator.this.r.nextInt(LoadGenerator.this.maxDelayBetweenOps);
                Thread.sleep(delay);
            }
        }

        private void nextOp() throws IOException {
            double rn = LoadGenerator.this.r.nextDouble();
            int i = LoadGenerator.this.currentIndex;
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Thread " + this.id + " moving to index " + i));
            }
            if (rn < LoadGenerator.this.readProbs[i]) {
                this.read();
            } else if (rn < LoadGenerator.this.readProbs[i] + LoadGenerator.this.writeProbs[i]) {
                this.write();
            } else {
                this.list();
            }
        }

        private void read() throws IOException {
            String fileName = (String)LoadGenerator.this.files.get(LoadGenerator.this.r.nextInt(LoadGenerator.this.files.size()));
            long startTime = Time.now();
            FSDataInputStream in = LoadGenerator.this.fc.open(new Path(fileName));
            this.executionTime[0] = this.executionTime[0] + (Time.now() - startTime);
            this.totalNumOfOps[0] = this.totalNumOfOps[0] + 1L;
            while (in.read(this.buffer) != -1) {
            }
            in.close();
        }

        private void write() throws IOException {
            double d;
            String dirName = (String)LoadGenerator.this.dirs.get(LoadGenerator.this.r.nextInt(LoadGenerator.this.dirs.size()));
            Path file = new Path(dirName, LoadGenerator.this.hostname + this.id);
            double fileSize = 0.0;
            do {
                fileSize = LoadGenerator.this.r.nextGaussian() + 2.0;
            } while (d <= 0.0);
            this.genFile(file, (long)(fileSize * 10.0));
            long startTime = Time.now();
            LoadGenerator.this.fc.delete(file, true);
            this.executionTime[4] = this.executionTime[4] + (Time.now() - startTime);
            this.totalNumOfOps[4] = this.totalNumOfOps[4] + 1L;
        }

        private void list() throws IOException {
            String dirName = (String)LoadGenerator.this.dirs.get(LoadGenerator.this.r.nextInt(LoadGenerator.this.dirs.size()));
            long startTime = Time.now();
            LoadGenerator.this.fc.listStatus(new Path(dirName));
            this.executionTime[1] = this.executionTime[1] + (Time.now() - startTime);
            this.totalNumOfOps[1] = this.totalNumOfOps[1] + 1L;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void genFile(Path file, long fileSize) throws IOException {
            long startTime = Time.now();
            FSDataOutputStream out = null;
            try {
                long s;
                out = LoadGenerator.this.fc.create(file, EnumSet.of(CreateFlag.CREATE, CreateFlag.OVERWRITE), new Options.CreateOpts[]{Options.CreateOpts.createParent(), Options.CreateOpts.bufferSize((int)4096), Options.CreateOpts.repFac((short)3)});
                this.executionTime[2] = this.executionTime[2] + (Time.now() - startTime);
                this.totalNumOfOps[2] = this.totalNumOfOps[2] + 1L;
                for (long i = fileSize; i > 0L; i -= s) {
                    s = Math.min(fileSize, (long)LoadGenerator.this.WRITE_CONTENTS.length);
                    out.write(LoadGenerator.this.WRITE_CONTENTS, 0, (int)s);
                }
                startTime = Time.now();
                this.executionTime[3] = this.executionTime[3] + (Time.now() - startTime);
                this.totalNumOfOps[3] = this.totalNumOfOps[3] + 1L;
            }
            catch (Throwable throwable) {
                IOUtils.cleanup((Log)LOG, (Closeable[])new Closeable[]{out});
                throw throwable;
            }
            IOUtils.cleanup((Log)LOG, (Closeable[])new Closeable[]{out});
        }
    }
}

