/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.security;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.Arrays;
import java.util.List;
import javax.naming.CommunicationException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.security.LdapGroupsMapping;
import org.apache.hadoop.security.alias.CredentialProvider;
import org.apache.hadoop.security.alias.CredentialProviderFactory;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class TestLdapGroupsMapping {
    private DirContext mockContext;
    private LdapGroupsMapping mappingSpy = (LdapGroupsMapping)Mockito.spy((Object)new LdapGroupsMapping());
    private NamingEnumeration mockUserNamingEnum = (NamingEnumeration)Mockito.mock(NamingEnumeration.class);
    private NamingEnumeration mockGroupNamingEnum = (NamingEnumeration)Mockito.mock(NamingEnumeration.class);
    private String[] testGroups = new String[]{"group1", "group2"};

    @Before
    public void setupMocks() throws NamingException {
        this.mockContext = (DirContext)Mockito.mock(DirContext.class);
        ((LdapGroupsMapping)Mockito.doReturn((Object)this.mockContext).when((Object)this.mappingSpy)).getDirContext();
        SearchResult mockUserResult = (SearchResult)Mockito.mock(SearchResult.class);
        Mockito.when((Object)this.mockUserNamingEnum.hasMoreElements()).thenReturn((Object)true);
        Mockito.when(this.mockUserNamingEnum.nextElement()).thenReturn((Object)mockUserResult);
        Mockito.when((Object)mockUserResult.getNameInNamespace()).thenReturn((Object)"CN=some_user,DC=test,DC=com");
        SearchResult mockGroupResult = (SearchResult)Mockito.mock(SearchResult.class);
        Mockito.when((Object)this.mockGroupNamingEnum.hasMoreElements()).thenReturn((Object)true, (Object[])new Boolean[]{true, false});
        Mockito.when(this.mockGroupNamingEnum.nextElement()).thenReturn((Object)mockGroupResult);
        BasicAttribute group1Attr = new BasicAttribute("cn");
        group1Attr.add(this.testGroups[0]);
        BasicAttributes group1Attrs = new BasicAttributes();
        group1Attrs.put(group1Attr);
        BasicAttribute group2Attr = new BasicAttribute("cn");
        group2Attr.add(this.testGroups[1]);
        BasicAttributes group2Attrs = new BasicAttributes();
        group2Attrs.put(group2Attr);
        Mockito.when((Object)mockGroupResult.getAttributes()).thenReturn((Object)group1Attrs, (Object[])new Attributes[]{group2Attrs});
    }

    @Test
    public void testGetGroups() throws IOException, NamingException {
        Mockito.when(this.mockContext.search(Mockito.anyString(), Mockito.anyString(), (Object[])Mockito.any(Object[].class), (SearchControls)Mockito.any(SearchControls.class))).thenReturn((Object)this.mockUserNamingEnum, (Object[])new NamingEnumeration[]{this.mockGroupNamingEnum});
        this.doTestGetGroups(Arrays.asList(this.testGroups), 2);
    }

    @Test
    public void testGetGroupsWithConnectionClosed() throws IOException, NamingException {
        Mockito.when(this.mockContext.search(Mockito.anyString(), Mockito.anyString(), (Object[])Mockito.any(Object[].class), (SearchControls)Mockito.any(SearchControls.class))).thenThrow(new Throwable[]{new CommunicationException("Connection is closed")}).thenReturn((Object)this.mockUserNamingEnum, (Object[])new NamingEnumeration[]{this.mockGroupNamingEnum});
        this.doTestGetGroups(Arrays.asList(this.testGroups), 3);
    }

    @Test
    public void testGetGroupsWithLdapDown() throws IOException, NamingException {
        Mockito.when(this.mockContext.search(Mockito.anyString(), Mockito.anyString(), (Object[])Mockito.any(Object[].class), (SearchControls)Mockito.any(SearchControls.class))).thenThrow(new Throwable[]{new CommunicationException("Connection is closed")});
        this.doTestGetGroups(Arrays.asList(new String[0]), 1 + LdapGroupsMapping.RECONNECT_RETRY_COUNT);
    }

    private void doTestGetGroups(List<String> expectedGroups, int searchTimes) throws IOException, NamingException {
        Configuration conf = new Configuration();
        conf.set("hadoop.security.group.mapping.ldap.url", "ldap://test");
        this.mappingSpy.setConf(conf);
        List groups = this.mappingSpy.getGroups("some_user");
        Assert.assertEquals(expectedGroups, (Object)groups);
        ((DirContext)Mockito.verify((Object)this.mockContext, (VerificationMode)Mockito.times((int)searchTimes))).search(Mockito.anyString(), Mockito.anyString(), (Object[])Mockito.any(Object[].class), (SearchControls)Mockito.any(SearchControls.class));
    }

    @Test
    public void testExtractPassword() throws IOException {
        File testDir = new File(System.getProperty("test.build.data", "target/test-dir"));
        testDir.mkdirs();
        File secretFile = new File(testDir, "secret.txt");
        FileWriter writer = new FileWriter(secretFile);
        writer.write("hadoop");
        ((Writer)writer).close();
        LdapGroupsMapping mapping = new LdapGroupsMapping();
        Assert.assertEquals((Object)"hadoop", (Object)mapping.extractPassword(secretFile.getPath()));
    }

    @Test
    public void testConfGetPassword() throws Exception {
        File testDir = new File(System.getProperty("test.build.data", "target/test-dir"));
        Configuration conf = new Configuration();
        Path jksPath = new Path(testDir.toString(), "test.jks");
        String ourUrl = "jceks://file" + jksPath.toUri();
        File file = new File(testDir, "test.jks");
        file.delete();
        conf.set("hadoop.security.credential.provider.path", ourUrl);
        CredentialProvider provider = (CredentialProvider)CredentialProviderFactory.getProviders((Configuration)conf).get(0);
        char[] bindpass = new char[]{'b', 'i', 'n', 'd', 'p', 'a', 's', 's'};
        char[] storepass = new char[]{'s', 't', 'o', 'r', 'e', 'p', 'a', 's', 's'};
        Assert.assertEquals(null, (Object)provider.getCredentialEntry("hadoop.security.group.mapping.ldap.bind.password"));
        Assert.assertEquals(null, (Object)provider.getCredentialEntry("hadoop.security.group.mapping.ldap.ssl.keystore.password"));
        try {
            provider.createCredentialEntry("hadoop.security.group.mapping.ldap.bind.password", bindpass);
            provider.createCredentialEntry("hadoop.security.group.mapping.ldap.ssl.keystore.password", storepass);
            provider.flush();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        Assert.assertArrayEquals((char[])bindpass, (char[])provider.getCredentialEntry("hadoop.security.group.mapping.ldap.bind.password").getCredential());
        Assert.assertArrayEquals((char[])storepass, (char[])provider.getCredentialEntry("hadoop.security.group.mapping.ldap.ssl.keystore.password").getCredential());
        LdapGroupsMapping mapping = new LdapGroupsMapping();
        Assert.assertEquals((Object)"bindpass", (Object)mapping.getPassword(conf, "hadoop.security.group.mapping.ldap.bind.password", ""));
        Assert.assertEquals((Object)"storepass", (Object)mapping.getPassword(conf, "hadoop.security.group.mapping.ldap.ssl.keystore.password", ""));
        Assert.assertEquals((Object)"", (Object)mapping.getPassword(conf, "invalid-alias", ""));
    }
}

