/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.security.token.delegation;

import org.apache.curator.test.TestingServer;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.SecretManager;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.delegation.web.DelegationTokenManager;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestZKDelegationTokenSecretManager {
    private static final long DAY_IN_SECS = 86400L;
    private TestingServer zkServer;

    @Before
    public void setup() throws Exception {
        this.zkServer = new TestingServer();
        this.zkServer.start();
    }

    @After
    public void tearDown() throws Exception {
        if (this.zkServer != null) {
            this.zkServer.close();
        }
    }

    protected Configuration getSecretConf(String connectString) {
        Configuration conf = new Configuration();
        conf.setBoolean("zk-dt-secret-manager.enable", true);
        conf.set("zk-dt-secret-manager.zkConnectionString", connectString);
        conf.set("zk-dt-secret-manager.znodeWorkingPath", "testPath");
        conf.set("zk-dt-secret-manager.zkAuthType", "none");
        conf.setLong("delegation-token.update-interval.sec", 86400L);
        conf.setLong("delegation-token.max-lifetime.sec", 86400L);
        conf.setLong("delegation-token.renew-interval.sec", 86400L);
        conf.setLong("delegation-token.removal-scan-interval.sec", 86400L);
        return conf;
    }

    @Test
    public void testMultiNodeOperations() throws Exception {
        DelegationTokenManager tm2 = null;
        String connectString = this.zkServer.getConnectString();
        Configuration conf = this.getSecretConf(connectString);
        DelegationTokenManager tm1 = new DelegationTokenManager(conf, new Text("bla"));
        tm1.init();
        tm2 = new DelegationTokenManager(conf, new Text("bla"));
        tm2.init();
        Token token = tm1.createToken(UserGroupInformation.getCurrentUser(), "foo");
        Assert.assertNotNull((Object)token);
        tm2.verifyToken(token);
        tm2.renewToken(token, "foo");
        tm1.verifyToken(token);
        tm1.cancelToken(token, "foo");
        try {
            tm2.verifyToken(token);
            Assert.fail((String)"Expected InvalidToken");
        }
        catch (SecretManager.InvalidToken it) {
            // empty catch block
        }
        token = tm2.createToken(UserGroupInformation.getCurrentUser(), "bar");
        Assert.assertNotNull((Object)token);
        tm1.verifyToken(token);
        tm1.renewToken(token, "bar");
        tm2.verifyToken(token);
        tm2.cancelToken(token, "bar");
        try {
            tm1.verifyToken(token);
            Assert.fail((String)"Expected InvalidToken");
        }
        catch (SecretManager.InvalidToken it) {
            // empty catch block
        }
    }

    @Test
    public void testRenewTokenSingleManager() throws Exception {
        DelegationTokenManager tm1 = null;
        String connectString = this.zkServer.getConnectString();
        Configuration conf = this.getSecretConf(connectString);
        tm1 = new DelegationTokenManager(conf, new Text("foo"));
        tm1.init();
        Token token = tm1.createToken(UserGroupInformation.getCurrentUser(), "foo");
        Assert.assertNotNull((Object)token);
        tm1.renewToken(token, "foo");
        tm1.verifyToken(token);
    }

    @Test
    public void testCancelTokenSingleManager() throws Exception {
        DelegationTokenManager tm1 = null;
        String connectString = this.zkServer.getConnectString();
        Configuration conf = this.getSecretConf(connectString);
        tm1 = new DelegationTokenManager(conf, new Text("foo"));
        tm1.init();
        Token token = tm1.createToken(UserGroupInformation.getCurrentUser(), "foo");
        Assert.assertNotNull((Object)token);
        tm1.cancelToken(token, "foo");
        try {
            tm1.verifyToken(token);
            Assert.fail((String)"Expected InvalidToken");
        }
        catch (SecretManager.InvalidToken it) {
            it.printStackTrace();
        }
    }
}

