/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.shell.find;

import java.io.IOException;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.shell.PathData;
import org.apache.hadoop.fs.shell.find.Expression;
import org.apache.hadoop.fs.shell.find.FindOptions;
import org.apache.hadoop.fs.shell.find.MockFileSystem;
import org.apache.hadoop.fs.shell.find.Name;
import org.apache.hadoop.fs.shell.find.Result;
import org.apache.hadoop.fs.shell.find.TestHelper;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestIname {
    private FileSystem mockFs;
    private Name.Iname name;

    @Before
    public void resetMock() throws IOException {
        this.mockFs = MockFileSystem.setup();
    }

    private void setup(String arg) throws IOException {
        this.name = new Name.Iname();
        TestHelper.addArgument((Expression)this.name, arg);
        this.name.setOptions(new FindOptions());
        this.name.prepare();
    }

    @Test(timeout=1000L)
    public void applyMatch() throws IOException {
        this.setup("name");
        PathData item = new PathData("/directory/path/name", this.mockFs.getConf());
        Assert.assertEquals((Object)Result.PASS, (Object)this.name.apply(item, -1));
    }

    @Test(timeout=1000L)
    public void applyNotMatch() throws IOException {
        this.setup("name");
        PathData item = new PathData("/directory/path/notname", this.mockFs.getConf());
        Assert.assertEquals((Object)Result.FAIL, (Object)this.name.apply(item, -1));
    }

    @Test(timeout=1000L)
    public void applyMixedCase() throws IOException {
        this.setup("name");
        PathData item = new PathData("/directory/path/NaMe", this.mockFs.getConf());
        Assert.assertEquals((Object)Result.PASS, (Object)this.name.apply(item, -1));
    }

    @Test(timeout=1000L)
    public void applyGlob() throws IOException {
        this.setup("n*e");
        PathData item = new PathData("/directory/path/name", this.mockFs.getConf());
        Assert.assertEquals((Object)Result.PASS, (Object)this.name.apply(item, -1));
    }

    @Test(timeout=1000L)
    public void applyGlobMixedCase() throws IOException {
        this.setup("n*e");
        PathData item = new PathData("/directory/path/NaMe", this.mockFs.getConf());
        Assert.assertEquals((Object)Result.PASS, (Object)this.name.apply(item, -1));
    }

    @Test(timeout=1000L)
    public void applyGlobNotMatch() throws IOException {
        this.setup("n*e");
        PathData item = new PathData("/directory/path/notmatch", this.mockFs.getConf());
        Assert.assertEquals((Object)Result.FAIL, (Object)this.name.apply(item, -1));
    }
}

