/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.shell.find;

import org.apache.hadoop.fs.shell.find.Result;
import org.junit.Assert;
import org.junit.Test;

public class TestResult {
    @Test(timeout=1000L)
    public void testPass() {
        Result result = Result.PASS;
        Assert.assertTrue((boolean)result.isPass());
        Assert.assertTrue((boolean)result.isDescend());
    }

    @Test(timeout=1000L)
    public void testFail() {
        Result result = Result.FAIL;
        Assert.assertFalse((boolean)result.isPass());
        Assert.assertTrue((boolean)result.isDescend());
    }

    @Test(timeout=1000L)
    public void testStop() {
        Result result = Result.STOP;
        Assert.assertTrue((boolean)result.isPass());
        Assert.assertFalse((boolean)result.isDescend());
    }

    @Test(timeout=1000L)
    public void combinePassPass() {
        Result result = Result.PASS.combine(Result.PASS);
        Assert.assertTrue((boolean)result.isPass());
        Assert.assertTrue((boolean)result.isDescend());
    }

    @Test(timeout=1000L)
    public void combinePassFail() {
        Result result = Result.PASS.combine(Result.FAIL);
        Assert.assertFalse((boolean)result.isPass());
        Assert.assertTrue((boolean)result.isDescend());
    }

    @Test(timeout=1000L)
    public void combineFailPass() {
        Result result = Result.FAIL.combine(Result.PASS);
        Assert.assertFalse((boolean)result.isPass());
        Assert.assertTrue((boolean)result.isDescend());
    }

    @Test(timeout=1000L)
    public void combineFailFail() {
        Result result = Result.FAIL.combine(Result.FAIL);
        Assert.assertFalse((boolean)result.isPass());
        Assert.assertTrue((boolean)result.isDescend());
    }

    @Test(timeout=1000L)
    public void combinePassStop() {
        Result result = Result.PASS.combine(Result.STOP);
        Assert.assertTrue((boolean)result.isPass());
        Assert.assertFalse((boolean)result.isDescend());
    }

    @Test(timeout=1000L)
    public void combineStopFail() {
        Result result = Result.STOP.combine(Result.FAIL);
        Assert.assertFalse((boolean)result.isPass());
        Assert.assertFalse((boolean)result.isDescend());
    }

    @Test(timeout=1000L)
    public void combineStopPass() {
        Result result = Result.STOP.combine(Result.PASS);
        Assert.assertTrue((boolean)result.isPass());
        Assert.assertFalse((boolean)result.isDescend());
    }

    @Test(timeout=1000L)
    public void combineFailStop() {
        Result result = Result.FAIL.combine(Result.STOP);
        Assert.assertFalse((boolean)result.isPass());
        Assert.assertFalse((boolean)result.isDescend());
    }

    @Test(timeout=1000L)
    public void negatePass() {
        Result result = Result.PASS.negate();
        Assert.assertFalse((boolean)result.isPass());
        Assert.assertTrue((boolean)result.isDescend());
    }

    @Test(timeout=1000L)
    public void negateFail() {
        Result result = Result.FAIL.negate();
        Assert.assertTrue((boolean)result.isPass());
        Assert.assertTrue((boolean)result.isDescend());
    }

    @Test(timeout=1000L)
    public void negateStop() {
        Result result = Result.STOP.negate();
        Assert.assertFalse((boolean)result.isPass());
        Assert.assertFalse((boolean)result.isDescend());
    }

    @Test(timeout=1000L)
    public void equalsPass() {
        Result one = Result.PASS;
        Result two = Result.PASS.combine(Result.PASS);
        Assert.assertEquals((Object)one, (Object)two);
    }

    @Test(timeout=1000L)
    public void equalsFail() {
        Result one = Result.FAIL;
        Result two = Result.FAIL.combine(Result.FAIL);
        Assert.assertEquals((Object)one, (Object)two);
    }

    @Test(timeout=1000L)
    public void equalsStop() {
        Result one = Result.STOP;
        Result two = Result.STOP.combine(Result.STOP);
        Assert.assertEquals((Object)one, (Object)two);
    }

    @Test(timeout=1000L)
    public void notEquals() {
        Assert.assertFalse((boolean)Result.PASS.equals((Object)Result.FAIL));
        Assert.assertFalse((boolean)Result.PASS.equals((Object)Result.STOP));
        Assert.assertFalse((boolean)Result.FAIL.equals((Object)Result.PASS));
        Assert.assertFalse((boolean)Result.FAIL.equals((Object)Result.STOP));
        Assert.assertFalse((boolean)Result.STOP.equals((Object)Result.PASS));
        Assert.assertFalse((boolean)Result.STOP.equals((Object)Result.FAIL));
    }
}

