/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.metrics2.impl;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import org.apache.hadoop.metrics2.AbstractMetric;
import org.apache.hadoop.metrics2.MetricsRecord;
import org.apache.hadoop.metrics2.MetricsTag;
import org.junit.Assert;

public class MetricsRecords {
    public static void assertTag(MetricsRecord record, String tagName, String expectedValue) {
        MetricsTag processIdTag = MetricsRecords.getFirstTagByName(record, tagName);
        Assert.assertNotNull((Object)processIdTag);
        Assert.assertEquals((Object)expectedValue, (Object)processIdTag.value());
    }

    public static void assertMetric(MetricsRecord record, String metricName, Number expectedValue) {
        AbstractMetric resourceLimitMetric = MetricsRecords.getFirstMetricByName(record, metricName);
        Assert.assertNotNull((Object)resourceLimitMetric);
        Assert.assertEquals((Object)expectedValue, (Object)resourceLimitMetric.value());
    }

    private static MetricsTag getFirstTagByName(MetricsRecord record, String name) {
        return (MetricsTag)Iterables.getFirst((Iterable)Iterables.filter((Iterable)record.tags(), (Predicate)new MetricsTagPredicate(name)), null);
    }

    private static AbstractMetric getFirstMetricByName(MetricsRecord record, String name) {
        return (AbstractMetric)Iterables.getFirst((Iterable)Iterables.filter((Iterable)record.metrics(), (Predicate)new AbstractMetricPredicate(name)), null);
    }

    private static class AbstractMetricPredicate
    implements Predicate<AbstractMetric> {
        private String metricName;

        public AbstractMetricPredicate(String metricName) {
            this.metricName = metricName;
        }

        public boolean apply(AbstractMetric input) {
            return input.name().equals(this.metricName);
        }
    }

    private static class MetricsTagPredicate
    implements Predicate<MetricsTag> {
        private String tagName;

        public MetricsTagPredicate(String tagName) {
            this.tagName = tagName;
        }

        public boolean apply(MetricsTag input) {
            return input.name().equals(this.tagName);
        }
    }
}

