/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.net;

import java.io.IOException;
import java.net.ServerSocket;
import java.util.Random;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ServerSocketUtil {
    private static final Log LOG = LogFactory.getLog(ServerSocketUtil.class);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int getPort(int port, int retries) throws IOException {
        Random rand = new Random();
        int tryPort = port;
        int tries = 0;
        while (true) {
            if (tries > 0) {
                tryPort = port + rand.nextInt(65535 - port);
            }
            LOG.info((Object)("Using port " + tryPort));
            try (ServerSocket s = new ServerSocket(tryPort);){
                int n = tryPort;
                return n;
            }
            catch (IOException e) {
                if (++tries >= retries) {
                    LOG.info((Object)"Port is already in use; giving up");
                    throw e;
                }
                LOG.info((Object)"Port is already in use; trying again");
                continue;
            }
            break;
        }
    }

    public static int[] getPorts(int numPorts) throws IOException {
        ServerSocket[] sockets = new ServerSocket[numPorts];
        int[] ports = new int[numPorts];
        for (int i = 0; i < numPorts; ++i) {
            ServerSocket sock;
            sockets[i] = sock = new ServerSocket(0);
            ports[i] = sock.getLocalPort();
        }
        for (ServerSocket sock : sockets) {
            sock.close();
        }
        return ports;
    }
}

