/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.test;

import org.apache.hadoop.test.GenericTestUtils;
import org.junit.Test;

public class TestGenericTestUtils
extends GenericTestUtils {
    @Test
    public void testAssertExceptionContainsNullEx() throws Throwable {
        block2: {
            try {
                TestGenericTestUtils.assertExceptionContains("", null);
            }
            catch (AssertionError e) {
                if (((Throwable)((Object)e)).toString().contains(E_NULL_THROWABLE)) break block2;
                throw e;
            }
        }
    }

    @Test
    public void testAssertExceptionContainsNullString() throws Throwable {
        block2: {
            try {
                TestGenericTestUtils.assertExceptionContains("", new BrokenException());
            }
            catch (AssertionError e) {
                if (((Throwable)((Object)e)).toString().contains(E_NULL_THROWABLE_STRING)) break block2;
                throw e;
            }
        }
    }

    @Test
    public void testAssertExceptionContainsWrongText() throws Throwable {
        block3: {
            try {
                TestGenericTestUtils.assertExceptionContains("Expected", new Exception("(actual)"));
            }
            catch (AssertionError e) {
                String s = ((Throwable)((Object)e)).toString();
                if (!s.contains(E_UNEXPECTED_EXCEPTION) || !s.contains("(actual)")) {
                    throw e;
                }
                if (((Throwable)((Object)e)).getCause() != null) break block3;
                throw new AssertionError("No nested cause in assertion", (Throwable)((Object)e));
            }
        }
    }

    @Test
    public void testAssertExceptionContainsWorking() throws Throwable {
        TestGenericTestUtils.assertExceptionContains("Expected", new Exception("Expected"));
    }

    private static class BrokenException
    extends Exception {
        @Override
        public String toString() {
            return null;
        }
    }
}

