/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.hadoop.http;

import java.io.IOException;

import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.mortbay.jetty.servlet.DefaultServlet;

/**
 * General servlet which is admin-authorized.
 *
 */
public class AdminAuthorizedServlet extends DefaultServlet {

  private static final long serialVersionUID = 1L;

  @Override
  protected void doGet(HttpServletRequest request, HttpServletResponse response)
      throws ServletException, IOException {
    // If user is a static user and auth Type is null, that means
    // there is a non-security environment and no need authorization,
    // otherwise, do the authorization.
    final ServletContext servletContext = getServletContext();
    if (HttpServer2.isStaticUserAndNoneAuthType(servletContext, request) ||
        HttpServer2.hasAdministratorAccess(servletContext, request,
        response)) {
      // Authorization is done. Just call super.
      super.doGet(request, response);
    }
  }
}
