/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.conf;

import com.google.common.base.Strings;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.hadoop.conf.ConfServlet;
import org.apache.hadoop.conf.Configuration;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.mockito.Mockito;
import org.mortbay.util.ajax.JSON;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class TestConfServlet {
    private static final String TEST_KEY = "testconfservlet.key";
    private static final String TEST_VAL = "testval";
    private static final Map<String, String> TEST_PROPERTIES = new HashMap<String, String>();
    private static final Map<String, String> TEST_FORMATS = new HashMap<String, String>();

    @BeforeClass
    public static void initTestProperties() {
        TEST_PROPERTIES.put("test.key1", "value1");
        TEST_PROPERTIES.put("test.key2", "value2");
        TEST_PROPERTIES.put("test.key3", "value3");
        TEST_FORMATS.put("xml", "application/xml");
        TEST_FORMATS.put("json", "application/json");
    }

    private Configuration getTestConf() {
        Configuration testConf = new Configuration();
        testConf.set(TEST_KEY, TEST_VAL);
        return testConf;
    }

    private Configuration getMultiPropertiesConf() {
        Configuration testConf = new Configuration(false);
        for (String key : TEST_PROPERTIES.keySet()) {
            testConf.set(key, TEST_PROPERTIES.get(key));
        }
        return testConf;
    }

    @Test
    public void testParseHeaders() throws Exception {
        HashMap<String, String> verifyMap = new HashMap<String, String>();
        verifyMap.put("text/plain", "xml");
        verifyMap.put(null, "xml");
        verifyMap.put("text/xml", "xml");
        verifyMap.put("application/xml", "xml");
        verifyMap.put("application/json", "json");
        HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        for (String contentTypeExpected : verifyMap.keySet()) {
            String contenTypeActual = (String)verifyMap.get(contentTypeExpected);
            Mockito.when((Object)request.getHeader("Accept")).thenReturn((Object)contentTypeExpected);
            Assert.assertEquals((Object)contenTypeActual, (Object)ConfServlet.parseAccecptHeader((HttpServletRequest)request));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void verifyGetProperty(Configuration conf, String format, String propertyName) throws Exception {
        StringWriter sw = null;
        PrintWriter pw = null;
        ConfServlet service = null;
        try {
            service = new ConfServlet();
            ServletConfig servletConf = (ServletConfig)Mockito.mock(ServletConfig.class);
            ServletContext context = (ServletContext)Mockito.mock(ServletContext.class);
            service.init(servletConf);
            Mockito.when((Object)context.getAttribute("hadoop.conf")).thenReturn((Object)conf);
            Mockito.when((Object)service.getServletContext()).thenReturn((Object)context);
            HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
            Mockito.when((Object)request.getHeader("Accept")).thenReturn((Object)TEST_FORMATS.get(format));
            Mockito.when((Object)request.getParameter("name")).thenReturn((Object)propertyName);
            HttpServletResponse response = (HttpServletResponse)Mockito.mock(HttpServletResponse.class);
            sw = new StringWriter();
            pw = new PrintWriter(sw);
            Mockito.when((Object)response.getWriter()).thenReturn((Object)pw);
            service.doGet(request, response);
            String result = sw.toString().trim();
            if (Strings.isNullOrEmpty((String)propertyName)) {
                for (String key : TEST_PROPERTIES.keySet()) {
                    Assert.assertTrue((result.contains(key) && result.contains(TEST_PROPERTIES.get(key)) ? 1 : 0) != 0);
                }
            } else if (conf.get(propertyName) != null) {
                Assert.assertTrue((boolean)result.contains(propertyName));
                for (String key : TEST_PROPERTIES.keySet()) {
                    if (key.equals(propertyName)) continue;
                    Assert.assertFalse((boolean)result.contains(key));
                }
            } else {
                ((HttpServletResponse)Mockito.verify((Object)response)).sendError(Mockito.eq((int)404), (String)Mockito.eq((Object)("Property " + propertyName + " not found")));
            }
        }
        finally {
            if (sw != null) {
                sw.close();
            }
            if (pw != null) {
                pw.close();
            }
            if (service != null) {
                service.destroy();
            }
        }
    }

    @Test
    public void testGetProperty() throws Exception {
        Configuration configurations = this.getMultiPropertiesConf();
        String[] testKeys = new String[]{"test.key1", "test.unknown.key", "", "test.key2", null};
        for (String format : TEST_FORMATS.keySet()) {
            for (String key : testKeys) {
                this.verifyGetProperty(configurations, format, key);
            }
        }
    }

    @Test
    public void testWriteJson() throws Exception {
        Object[] properties;
        StringWriter sw = new StringWriter();
        ConfServlet.writeResponse((Configuration)this.getTestConf(), (Writer)sw, (String)"json");
        String json = sw.toString();
        boolean foundSetting = false;
        Object parsed = JSON.parse((String)json);
        for (Object o : properties = (Object[])((Map)parsed).get("properties")) {
            Map propertyInfo = (Map)o;
            String key = (String)propertyInfo.get("key");
            String val = (String)propertyInfo.get("value");
            String resource = (String)propertyInfo.get("resource");
            System.err.println("k: " + key + " v: " + val + " r: " + resource);
            if (!TEST_KEY.equals(key) || !TEST_VAL.equals(val) || !"programatically".equals(resource)) continue;
            foundSetting = true;
        }
        Assert.assertTrue((boolean)foundSetting);
    }

    @Test
    public void testWriteXml() throws Exception {
        StringWriter sw = new StringWriter();
        ConfServlet.writeResponse((Configuration)this.getTestConf(), (Writer)sw, (String)"xml");
        String xml = sw.toString();
        DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = docBuilderFactory.newDocumentBuilder();
        Document doc = builder.parse(new InputSource(new StringReader(xml)));
        NodeList nameNodes = doc.getElementsByTagName("name");
        boolean foundSetting = false;
        for (int i = 0; i < nameNodes.getLength(); ++i) {
            Node nameNode = nameNodes.item(i);
            String key = nameNode.getTextContent();
            if (!TEST_KEY.equals(key)) continue;
            foundSetting = true;
            Element propertyElem = (Element)nameNode.getParentNode();
            String val = propertyElem.getElementsByTagName("value").item(0).getTextContent();
            Assert.assertEquals((Object)TEST_VAL, (Object)val);
        }
        Assert.assertTrue((boolean)foundSetting);
    }

    @Test
    public void testBadFormat() throws Exception {
        StringWriter sw = new StringWriter();
        try {
            ConfServlet.writeResponse((Configuration)this.getTestConf(), (Writer)sw, (String)"not a format");
            Assert.fail((String)"writeResponse with bad format didn't throw!");
        }
        catch (ConfServlet.BadFormatException badFormatException) {
            // empty catch block
        }
        Assert.assertEquals((Object)"", (Object)sw.toString());
    }
}

