/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs;

import java.net.URI;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.AbstractFileSystem;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.UnsupportedFileSystemException;
import org.junit.Assert;
import org.junit.Test;

public class TestDelegateToFileSystem {
    private static final String FTP_DUMMYHOST = "ftp://dummyhost";
    private static final URI FTP_URI_NO_PORT = URI.create("ftp://dummyhost");
    private static final URI FTP_URI_WITH_PORT = URI.create("ftp://dummyhost:21");

    private void testDefaultUriInternal(String defaultUri) throws UnsupportedFileSystemException {
        Configuration conf = new Configuration();
        FileSystem.setDefaultUri((Configuration)conf, (String)defaultUri);
        AbstractFileSystem ftpFs = AbstractFileSystem.get((URI)FTP_URI_NO_PORT, (Configuration)conf);
        Assert.assertEquals((Object)FTP_URI_WITH_PORT, (Object)ftpFs.getUri());
    }

    @Test
    public void testDefaultURIwithOutPort() throws Exception {
        this.testDefaultUriInternal("hdfs://dummyhost");
    }

    @Test
    public void testDefaultURIwithPort() throws Exception {
        this.testDefaultUriInternal("hdfs://dummyhost:8020");
    }
}

