/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.io;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.DataInputBuffer;
import org.apache.hadoop.io.DataOutputBuffer;
import org.apache.hadoop.io.WritableUtils;
import org.junit.Assert;
import org.junit.Test;

public class TestWritableUtils {
    private static final Log LOG = LogFactory.getLog(TestWritableUtils.class);

    private void testValue(int val, int vintlen) throws IOException {
        DataOutputBuffer buf = new DataOutputBuffer();
        DataInputBuffer inbuf = new DataInputBuffer();
        WritableUtils.writeVInt((DataOutput)buf, (int)val);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Value = " + val));
            BytesWritable printer = new BytesWritable();
            printer.set(buf.getData(), 0, buf.getLength());
            LOG.debug((Object)("Buffer = " + printer));
        }
        inbuf.reset(buf.getData(), 0, buf.getLength());
        Assert.assertEquals((long)val, (long)WritableUtils.readVInt((DataInput)inbuf));
        Assert.assertEquals((long)vintlen, (long)buf.getLength());
        Assert.assertEquals((long)vintlen, (long)WritableUtils.getVIntSize((long)val));
        Assert.assertEquals((long)vintlen, (long)WritableUtils.decodeVIntSize((byte)buf.getData()[0]));
    }

    private void testReadInRange(long val, int lower, int upper, boolean expectSuccess) throws IOException {
        block3: {
            DataOutputBuffer buf = new DataOutputBuffer();
            DataInputBuffer inbuf = new DataInputBuffer();
            WritableUtils.writeVLong((DataOutput)buf, (long)val);
            try {
                inbuf.reset(buf.getData(), 0, buf.getLength());
                long val2 = WritableUtils.readVIntInRange((DataInput)inbuf, (int)lower, (int)upper);
                if (!expectSuccess) {
                    Assert.fail((String)"expected readVIntInRange to throw an exception");
                }
                Assert.assertEquals((long)val, (long)val2);
            }
            catch (IOException e) {
                if (!expectSuccess) break block3;
                LOG.error((Object)"unexpected exception:", (Throwable)e);
                Assert.fail((String)"readVIntInRange threw an unexpected exception");
            }
        }
    }

    @Test
    public void testVInt() throws Exception {
        this.testValue(12, 1);
        this.testValue(127, 1);
        this.testValue(-112, 1);
        this.testValue(-113, 2);
        this.testValue(-128, 2);
        this.testValue(128, 2);
        this.testValue(-129, 2);
        this.testValue(255, 2);
        this.testValue(-256, 2);
        this.testValue(256, 3);
        this.testValue(-257, 3);
        this.testValue(65535, 3);
        this.testValue(-65536, 3);
        this.testValue(65536, 4);
        this.testValue(-65537, 4);
        this.testReadInRange(123L, 122, 123, true);
        this.testReadInRange(123L, 0, 100, false);
        this.testReadInRange(0L, 0, 100, true);
        this.testReadInRange(-1L, 0, 100, false);
        this.testReadInRange(0x10000000000L, 0, Integer.MAX_VALUE, false);
    }
}

