/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.security;

import java.io.IOException;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.security.ShellBasedUnixGroupsMapping;
import org.apache.hadoop.util.Shell;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class TestShellBasedUnixGroupsMapping {
    private static final Log LOG = LogFactory.getLog(TestShellBasedUnixGroupsMapping.class);

    @Test
    public void testGetGroupsNonexistentUser() throws Exception {
        TestGroupUserNotExist mapping = new TestGroupUserNotExist();
        List groups = mapping.getGroups("foobarusernotexist");
        Assert.assertTrue((boolean)groups.isEmpty());
    }

    @Test
    public void testGetGroupsNotResolvable() throws Exception {
        TestGroupNotResolvable mapping = new TestGroupNotResolvable();
        List groups = mapping.getGroups("user");
        Assert.assertTrue((groups.size() == 2 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)groups.contains("abc"));
        Assert.assertTrue((boolean)groups.contains("def"));
    }

    @Test
    public void testGetNumericGroupsResolvable() throws Exception {
        TestNumericGroupResolvable mapping = new TestNumericGroupResolvable();
        List groups = mapping.getGroups("user");
        Assert.assertTrue((groups.size() == 3 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)groups.contains("23"));
        Assert.assertTrue((boolean)groups.contains("groupname"));
        Assert.assertTrue((boolean)groups.contains("zzz"));
    }

    @Test
    public void testGetGroupsResolvable() throws Exception {
        TestGroupResolvable mapping = new TestGroupResolvable();
        List groups = mapping.getGroups("user");
        Assert.assertTrue((groups.size() == 3 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)groups.contains("abc"));
        Assert.assertTrue((boolean)groups.contains("def"));
        Assert.assertTrue((boolean)groups.contains("hij"));
    }

    private class TestGroupResolvable
    extends ShellBasedUnixGroupsMapping {
        private TestGroupResolvable() {
        }

        protected Shell.ShellCommandExecutor createGroupExecutor(String userName) {
            Shell.ShellCommandExecutor executor = (Shell.ShellCommandExecutor)Mockito.mock(Shell.ShellCommandExecutor.class);
            try {
                ((Shell.ShellCommandExecutor)Mockito.doNothing().when((Object)executor)).execute();
                Mockito.when((Object)executor.getOutput()).thenReturn((Object)"abc\ndef abc hij");
            }
            catch (IOException e) {
                LOG.warn((Object)e.getMessage());
            }
            return executor;
        }

        protected Shell.ShellCommandExecutor createGroupIDExecutor(String userName) {
            Shell.ShellCommandExecutor executor = (Shell.ShellCommandExecutor)Mockito.mock(Shell.ShellCommandExecutor.class);
            try {
                ((Shell.ShellCommandExecutor)Mockito.doNothing().when((Object)executor)).execute();
                Mockito.when((Object)executor.getOutput()).thenReturn((Object)"1\n1 2 3");
            }
            catch (IOException e) {
                LOG.warn((Object)e.getMessage());
            }
            return executor;
        }
    }

    private class TestNumericGroupResolvable
    extends ShellBasedUnixGroupsMapping {
        private TestNumericGroupResolvable() {
        }

        protected Shell.ShellCommandExecutor createGroupExecutor(String userName) {
            Shell.ShellCommandExecutor executor = (Shell.ShellCommandExecutor)Mockito.mock(Shell.ShellCommandExecutor.class);
            try {
                ((Shell.ShellCommandExecutor)Mockito.doNothing().when((Object)executor)).execute();
                Mockito.when((Object)executor.getOutput()).thenReturn((Object)"23\n23 groupname zzz");
            }
            catch (IOException e) {
                LOG.warn((Object)e.getMessage());
            }
            return executor;
        }

        protected Shell.ShellCommandExecutor createGroupIDExecutor(String userName) {
            Shell.ShellCommandExecutor executor = (Shell.ShellCommandExecutor)Mockito.mock(Shell.ShellCommandExecutor.class);
            try {
                ((Shell.ShellCommandExecutor)Mockito.doNothing().when((Object)executor)).execute();
                Mockito.when((Object)executor.getOutput()).thenReturn((Object)"111\n111 112 113");
            }
            catch (IOException e) {
                LOG.warn((Object)e.getMessage());
            }
            return executor;
        }
    }

    private class TestGroupNotResolvable
    extends ShellBasedUnixGroupsMapping {
        private TestGroupNotResolvable() {
        }

        protected Shell.ShellCommandExecutor createGroupExecutor(String userName) {
            Shell.ShellCommandExecutor executor = (Shell.ShellCommandExecutor)Mockito.mock(Shell.ShellCommandExecutor.class);
            try {
                ((Shell.ShellCommandExecutor)Mockito.doThrow((Throwable)new Shell.ExitCodeException(1, "cannot find name for group ID 9999")).when((Object)executor)).execute();
                Mockito.when((Object)executor.getOutput()).thenReturn((Object)"9999\n9999 abc def");
            }
            catch (IOException e) {
                LOG.warn((Object)e.getMessage());
            }
            return executor;
        }

        protected Shell.ShellCommandExecutor createGroupIDExecutor(String userName) {
            Shell.ShellCommandExecutor executor = (Shell.ShellCommandExecutor)Mockito.mock(Shell.ShellCommandExecutor.class);
            Mockito.when((Object)executor.getOutput()).thenReturn((Object)"9999\n9999 1 2");
            return executor;
        }
    }

    private class TestGroupUserNotExist
    extends ShellBasedUnixGroupsMapping {
        private TestGroupUserNotExist() {
        }

        protected Shell.ShellCommandExecutor createGroupExecutor(String userName) {
            Shell.ShellCommandExecutor executor = (Shell.ShellCommandExecutor)Mockito.mock(Shell.ShellCommandExecutor.class);
            try {
                ((Shell.ShellCommandExecutor)Mockito.doThrow((Throwable)new Shell.ExitCodeException(1, "id: foobarusernotexist: No such user")).when((Object)executor)).execute();
                Mockito.when((Object)executor.getOutput()).thenReturn((Object)"");
            }
            catch (IOException e) {
                LOG.warn((Object)e.getMessage());
            }
            return executor;
        }
    }
}

