/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.util;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Random;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.util.LightWeightGSet;
import org.junit.Assert;
import org.junit.Test;

public class TestLightWeightGSet {
    public static final Log LOG = LogFactory.getLog(TestLightWeightGSet.class);

    private static ArrayList<Integer> getRandomList(int length, int randomSeed) {
        Random random = new Random(randomSeed);
        ArrayList<Integer> list = new ArrayList<Integer>(length);
        for (int i = 0; i < length; ++i) {
            list.add(random.nextInt());
        }
        return list;
    }

    @Test(timeout=60000L)
    public void testRemoveAllViaIterator() {
        ArrayList<Integer> list = TestLightWeightGSet.getRandomList(100, 123);
        LightWeightGSet set = new LightWeightGSet(16);
        for (Integer i : list) {
            set.put((Object)new TestElement(i));
        }
        Iterator iter = set.iterator();
        while (iter.hasNext()) {
            iter.next();
            iter.remove();
        }
        Assert.assertEquals((long)0L, (long)set.size());
    }

    @Test(timeout=60000L)
    public void testRemoveSomeViaIterator() {
        ArrayList<Integer> list = TestLightWeightGSet.getRandomList(100, 123);
        LightWeightGSet set = new LightWeightGSet(16);
        for (Integer i : list) {
            set.put((Object)new TestElement(i));
        }
        long sum = 0L;
        Iterator iter = set.iterator();
        while (iter.hasNext()) {
            sum += (long)((TestElement)iter.next()).getVal();
        }
        long mode = sum / (long)set.size();
        LOG.info((Object)("Removing all elements above " + mode));
        Iterator iter2 = set.iterator();
        while (iter2.hasNext()) {
            int item = ((TestElement)iter2.next()).getVal();
            if ((long)item <= mode) continue;
            iter2.remove();
        }
        iter2 = set.iterator();
        while (iter2.hasNext()) {
            Assert.assertTrue(((long)((TestElement)iter2.next()).getVal() <= mode ? 1 : 0) != 0);
        }
    }

    private static class TestElement
    implements LightWeightGSet.LinkedElement {
        private final int val;
        private LightWeightGSet.LinkedElement next;

        TestElement(int val) {
            this.val = val;
            this.next = null;
        }

        public int getVal() {
            return this.val;
        }

        public void setNext(LightWeightGSet.LinkedElement next) {
            this.next = next;
        }

        public LightWeightGSet.LinkedElement getNext() {
            return this.next;
        }
    }
}

