/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.util;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import junit.framework.TestCase;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.hadoop.util.ApplicationClassLoader;
import org.apache.hadoop.util.ClassLoaderCheckMain;
import org.apache.hadoop.util.ClassLoaderCheckThird;
import org.apache.hadoop.util.RunJar;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class TestRunJar
extends TestCase {
    private File TEST_ROOT_DIR;
    private static final String TEST_JAR_NAME = "test-runjar.jar";
    private static final String TEST_JAR_2_NAME = "test-runjar2.jar";
    private static final long MOCKED_NOW = 1460389972000L;
    private static final long MOCKED_NOW_PLUS_TWO_SEC = 1460389974000L;

    @Before
    protected void setUp() throws Exception {
        this.TEST_ROOT_DIR = GenericTestUtils.getTestDir(((Object)((Object)this)).getClass().getSimpleName());
        if (!this.TEST_ROOT_DIR.exists()) {
            this.TEST_ROOT_DIR.mkdirs();
        }
        this.makeTestJar();
    }

    @After
    protected void tearDown() {
        FileUtil.fullyDelete((File)this.TEST_ROOT_DIR);
    }

    private void makeTestJar() throws IOException {
        File jarFile = new File(this.TEST_ROOT_DIR, TEST_JAR_NAME);
        JarOutputStream jstream = new JarOutputStream(new FileOutputStream(jarFile));
        ZipEntry zipEntry1 = new ZipEntry("foobar.txt");
        zipEntry1.setTime(1460389972000L);
        jstream.putNextEntry(zipEntry1);
        jstream.closeEntry();
        ZipEntry zipEntry2 = new ZipEntry("foobaz.txt");
        zipEntry2.setTime(1460389974000L);
        jstream.putNextEntry(zipEntry2);
        jstream.closeEntry();
        jstream.close();
    }

    @Test
    public void testUnJar() throws Exception {
        File unjarDir = new File(this.TEST_ROOT_DIR, "unjar-all");
        TestRunJar.assertFalse((String)"unjar dir shouldn't exist at test start", (boolean)new File(unjarDir, "foobar.txt").exists());
        RunJar.unJar((File)new File(this.TEST_ROOT_DIR, TEST_JAR_NAME), (File)unjarDir);
        TestRunJar.assertTrue((String)"foobar unpacked", (boolean)new File(unjarDir, "foobar.txt").exists());
        TestRunJar.assertTrue((String)"foobaz unpacked", (boolean)new File(unjarDir, "foobaz.txt").exists());
    }

    public void testUnJarWithPattern() throws Exception {
        File unjarDir = new File(this.TEST_ROOT_DIR, "unjar-pattern");
        TestRunJar.assertFalse((String)"unjar dir shouldn't exist at test start", (boolean)new File(unjarDir, "foobar.txt").exists());
        RunJar.unJar((File)new File(this.TEST_ROOT_DIR, TEST_JAR_NAME), (File)unjarDir, (Pattern)Pattern.compile(".*baz.*"));
        TestRunJar.assertFalse((String)"foobar not unpacked", (boolean)new File(unjarDir, "foobar.txt").exists());
        TestRunJar.assertTrue((String)"foobaz unpacked", (boolean)new File(unjarDir, "foobaz.txt").exists());
    }

    public void testUnJarDoesNotLooseLastModify() throws Exception {
        File unjarDir = new File(this.TEST_ROOT_DIR, "unjar-lastmod");
        TestRunJar.assertFalse((String)"unjar dir shouldn't exist at test start", (boolean)new File(unjarDir, "foobar.txt").exists());
        RunJar.unJar((File)new File(this.TEST_ROOT_DIR, TEST_JAR_NAME), (File)unjarDir);
        TestRunJar.assertEquals((String)"Last modify time was lost during unJar", (long)1460389972000L, (long)new File(unjarDir, "foobar.txt").lastModified());
        TestRunJar.assertEquals((String)"Last modify time was lost during unJar", (long)1460389974000L, (long)new File(unjarDir, "foobaz.txt").lastModified());
    }

    @Test
    public void testClientClassLoader() throws Throwable {
        RunJar runJar = (RunJar)Mockito.spy((Object)new RunJar());
        Mockito.when((Object)runJar.useClientClassLoader()).thenReturn((Object)true);
        String mainCls = ClassLoaderCheckMain.class.getName();
        String thirdCls = ClassLoaderCheckThird.class.getName();
        String systemClasses = "-" + mainCls + "," + "-" + thirdCls + "," + ApplicationClassLoader.SYSTEM_CLASSES_DEFAULT;
        Mockito.when((Object)runJar.getSystemClasses()).thenReturn((Object)systemClasses);
        File testJar = this.makeClassLoaderTestJar(mainCls, thirdCls);
        String[] args = new String[3];
        args[0] = testJar.getAbsolutePath();
        args[1] = mainCls;
        runJar.run(args);
    }

    private File makeClassLoaderTestJar(String ... clsNames) throws IOException {
        File jarFile = new File(this.TEST_ROOT_DIR, TEST_JAR_2_NAME);
        JarOutputStream jstream = new JarOutputStream(new FileOutputStream(jarFile));
        for (String clsName : clsNames) {
            int count;
            String name = clsName.replace('.', '/') + ".class";
            InputStream entryInputStream = ((Object)((Object)this)).getClass().getResourceAsStream("/" + name);
            ZipEntry entry = new ZipEntry(name);
            jstream.putNextEntry(entry);
            BufferedInputStream bufInputStream = new BufferedInputStream(entryInputStream, 2048);
            byte[] data = new byte[2048];
            while ((count = bufInputStream.read(data, 0, 2048)) != -1) {
                jstream.write(data, 0, count);
            }
            jstream.closeEntry();
        }
        jstream.close();
        return jarFile;
    }

    @Test
    public void testUnJar2() throws IOException {
        File jarFile = new File(this.TEST_ROOT_DIR, TEST_JAR_NAME);
        JarOutputStream jstream = new JarOutputStream(new FileOutputStream(jarFile));
        JarEntry je = new JarEntry("META-INF/MANIFEST.MF");
        byte[] data = "Manifest-Version: 1.0\nCreated-By: 1.8.0_1 (Manual)".getBytes(StandardCharsets.UTF_8);
        je.setSize(data.length);
        jstream.putNextEntry(je);
        jstream.write(data);
        jstream.closeEntry();
        je = new JarEntry("../outside.path");
        data = "any data here".getBytes(StandardCharsets.UTF_8);
        je.setSize(data.length);
        jstream.putNextEntry(je);
        jstream.write(data);
        jstream.closeEntry();
        jstream.close();
        File unjarDir = new File(this.TEST_ROOT_DIR, "unjar-path");
        try {
            RunJar.unJar((File)jarFile, (File)unjarDir);
            TestRunJar.fail((String)"unJar should throw IOException.");
        }
        catch (IOException e) {
            GenericTestUtils.assertExceptionContains("would create file outside of", e);
        }
    }
}

