/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.crypto;

import java.io.EOFException;
import java.io.FileDescriptor;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.EnumSet;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.crypto.CryptoCodec;
import org.apache.hadoop.crypto.CryptoInputStream;
import org.apache.hadoop.crypto.CryptoOutputStream;
import org.apache.hadoop.crypto.CryptoStreamsTestBase;
import org.apache.hadoop.fs.ByteBufferReadable;
import org.apache.hadoop.fs.CanSetDropBehind;
import org.apache.hadoop.fs.CanSetReadahead;
import org.apache.hadoop.fs.CanUnbuffer;
import org.apache.hadoop.fs.HasEnhancedByteBufferAccess;
import org.apache.hadoop.fs.HasFileDescriptor;
import org.apache.hadoop.fs.PositionedReadable;
import org.apache.hadoop.fs.ReadOption;
import org.apache.hadoop.fs.Seekable;
import org.apache.hadoop.fs.StreamCapabilities;
import org.apache.hadoop.fs.Syncable;
import org.apache.hadoop.io.ByteBufferPool;
import org.apache.hadoop.io.DataInputBuffer;
import org.apache.hadoop.io.DataOutputBuffer;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestCryptoStreams
extends CryptoStreamsTestBase {
    private byte[] buf;
    private int bufLen;

    @BeforeClass
    public static void init() throws Exception {
        Configuration conf = new Configuration();
        codec = CryptoCodec.getInstance((Configuration)conf);
    }

    @AfterClass
    public static void shutdown() throws Exception {
    }

    @Override
    protected OutputStream getOutputStream(int bufferSize, byte[] key, byte[] iv) throws IOException {
        DataOutputBuffer out = new DataOutputBuffer(){

            public void flush() throws IOException {
                TestCryptoStreams.access$002(TestCryptoStreams.this, this.getData());
                TestCryptoStreams.this.bufLen = this.getLength();
            }

            public void close() throws IOException {
                TestCryptoStreams.access$002(TestCryptoStreams.this, this.getData());
                TestCryptoStreams.this.bufLen = this.getLength();
            }
        };
        return new CryptoOutputStream((OutputStream)new FakeOutputStream(out), codec, bufferSize, key, iv);
    }

    @Override
    protected InputStream getInputStream(int bufferSize, byte[] key, byte[] iv) throws IOException {
        DataInputBuffer in = new DataInputBuffer();
        in.reset(this.buf, 0, this.bufLen);
        return new CryptoInputStream((InputStream)new FakeInputStream(in), codec, bufferSize, key, iv);
    }

    @Test(timeout=120000L)
    public void testHasCapability() throws Exception {
        CryptoOutputStream cos = (CryptoOutputStream)this.getOutputStream(defaultBufferSize, key, iv);
        Assert.assertTrue((boolean)(cos instanceof StreamCapabilities));
        Assert.assertTrue((boolean)cos.hasCapability("hflush"));
        Assert.assertTrue((boolean)cos.hasCapability("hsync"));
        Assert.assertTrue((boolean)cos.hasCapability("dropbehind"));
        Assert.assertFalse((boolean)cos.hasCapability("in:readahead"));
        Assert.assertFalse((boolean)cos.hasCapability("in:unbuffer"));
        CryptoInputStream cis = (CryptoInputStream)this.getInputStream(defaultBufferSize, key, iv);
        Assert.assertTrue((boolean)(cis instanceof StreamCapabilities));
        Assert.assertTrue((boolean)cis.hasCapability("dropbehind"));
        Assert.assertTrue((boolean)cis.hasCapability("in:readahead"));
        Assert.assertTrue((boolean)cis.hasCapability("in:unbuffer"));
        Assert.assertFalse((boolean)cis.hasCapability("hflush"));
        Assert.assertFalse((boolean)cis.hasCapability("hsync"));
    }

    static /* synthetic */ byte[] access$002(TestCryptoStreams x0, byte[] x1) {
        x0.buf = x1;
        return x1;
    }

    static class FakeInputStream
    extends InputStream
    implements Seekable,
    PositionedReadable,
    ByteBufferReadable,
    HasFileDescriptor,
    CanSetDropBehind,
    CanSetReadahead,
    HasEnhancedByteBufferAccess,
    CanUnbuffer,
    StreamCapabilities {
        private final byte[] oneByteBuf = new byte[1];
        private int pos = 0;
        private final byte[] data;
        private final int length;
        private boolean closed = false;

        FakeInputStream(DataInputBuffer in) {
            this.data = in.getData();
            this.length = in.getLength();
        }

        public void seek(long pos) throws IOException {
            if (pos > (long)this.length) {
                throw new IOException("Cannot seek after EOF.");
            }
            if (pos < 0L) {
                throw new IOException("Cannot seek to negative offset.");
            }
            this.checkStream();
            this.pos = (int)pos;
        }

        public long getPos() throws IOException {
            return this.pos;
        }

        @Override
        public int available() throws IOException {
            return this.length - this.pos;
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            if (b == null) {
                throw new NullPointerException();
            }
            if (off < 0 || len < 0 || len > b.length - off) {
                throw new IndexOutOfBoundsException();
            }
            if (len == 0) {
                return 0;
            }
            this.checkStream();
            if (this.pos < this.length) {
                int n = Math.min(len, this.length - this.pos);
                System.arraycopy(this.data, this.pos, b, off, n);
                this.pos += n;
                return n;
            }
            return -1;
        }

        private void checkStream() throws IOException {
            if (this.closed) {
                throw new IOException("Stream is closed!");
            }
        }

        public int read(ByteBuffer buf) throws IOException {
            this.checkStream();
            if (this.pos < this.length) {
                int n = Math.min(buf.remaining(), this.length - this.pos);
                if (n > 0) {
                    buf.put(this.data, this.pos, n);
                }
                this.pos += n;
                return n;
            }
            return -1;
        }

        @Override
        public long skip(long n) throws IOException {
            this.checkStream();
            if (n > 0L) {
                if (n + (long)this.pos > (long)this.length) {
                    n = this.length - this.pos;
                }
                this.pos = (int)((long)this.pos + n);
                return n;
            }
            return n < 0L ? -1L : 0L;
        }

        @Override
        public void close() throws IOException {
            this.closed = true;
        }

        public int read(long position, byte[] b, int off, int len) throws IOException {
            if (b == null) {
                throw new NullPointerException();
            }
            if (off < 0 || len < 0 || len > b.length - off) {
                throw new IndexOutOfBoundsException();
            }
            if (len == 0) {
                return 0;
            }
            if (position > (long)this.length) {
                throw new IOException("Cannot read after EOF.");
            }
            if (position < 0L) {
                throw new IOException("Cannot read to negative offset.");
            }
            this.checkStream();
            if (position < (long)this.length) {
                int n = (int)Math.min((long)len, (long)this.length - position);
                System.arraycopy(this.data, (int)position, b, off, n);
                return n;
            }
            return -1;
        }

        public void readFully(long position, byte[] b, int off, int len) throws IOException {
            if (b == null) {
                throw new NullPointerException();
            }
            if (off < 0 || len < 0 || len > b.length - off) {
                throw new IndexOutOfBoundsException();
            }
            if (len == 0) {
                return;
            }
            if (position > (long)this.length) {
                throw new IOException("Cannot read after EOF.");
            }
            if (position < 0L) {
                throw new IOException("Cannot read to negative offset.");
            }
            this.checkStream();
            if (position + (long)len > (long)this.length) {
                throw new EOFException("Reach the end of stream.");
            }
            System.arraycopy(this.data, (int)position, b, off, len);
        }

        public void readFully(long position, byte[] buffer) throws IOException {
            this.readFully(position, buffer, 0, buffer.length);
        }

        public ByteBuffer read(ByteBufferPool bufferPool, int maxLength, EnumSet<ReadOption> opts) throws IOException, UnsupportedOperationException {
            if (bufferPool == null) {
                throw new IOException("Please specify buffer pool.");
            }
            ByteBuffer buffer = bufferPool.getBuffer(true, maxLength);
            int pos = buffer.position();
            int n = this.read(buffer);
            if (n >= 0) {
                buffer.position(pos);
                return buffer;
            }
            return null;
        }

        public void releaseBuffer(ByteBuffer buffer) {
        }

        public void setReadahead(Long readahead) throws IOException, UnsupportedOperationException {
        }

        public void setDropBehind(Boolean dropCache) throws IOException, UnsupportedOperationException {
        }

        public void unbuffer() {
        }

        public boolean hasCapability(String capability) {
            switch (capability.toLowerCase()) {
                case "in:readahead": 
                case "dropbehind": 
                case "in:unbuffer": {
                    return true;
                }
            }
            return false;
        }

        public FileDescriptor getFileDescriptor() throws IOException {
            return null;
        }

        public boolean seekToNewSource(long targetPos) throws IOException {
            if (targetPos > (long)this.length) {
                throw new IOException("Attempted to read past end of file.");
            }
            if (targetPos < 0L) {
                throw new IOException("Cannot seek after EOF.");
            }
            this.checkStream();
            this.pos = (int)targetPos;
            return false;
        }

        @Override
        public int read() throws IOException {
            int ret = this.read(this.oneByteBuf, 0, 1);
            return ret <= 0 ? -1 : this.oneByteBuf[0] & 0xFF;
        }
    }

    private class FakeOutputStream
    extends OutputStream
    implements Syncable,
    CanSetDropBehind,
    StreamCapabilities {
        private final byte[] oneByteBuf = new byte[1];
        private final DataOutputBuffer out;
        private boolean closed;

        public FakeOutputStream(DataOutputBuffer out) {
            this.out = out;
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            if (b == null) {
                throw new NullPointerException();
            }
            if (off < 0 || len < 0 || len > b.length - off) {
                throw new IndexOutOfBoundsException();
            }
            if (len == 0) {
                return;
            }
            this.checkStream();
            this.out.write(b, off, len);
        }

        @Override
        public void flush() throws IOException {
            this.checkStream();
            this.out.flush();
        }

        @Override
        public void close() throws IOException {
            if (this.closed) {
                return;
            }
            this.out.close();
            this.closed = true;
        }

        @Override
        public void write(int b) throws IOException {
            this.oneByteBuf[0] = (byte)(b & 0xFF);
            this.write(this.oneByteBuf, 0, this.oneByteBuf.length);
        }

        public void setDropBehind(Boolean dropCache) throws IOException, UnsupportedOperationException {
        }

        public void sync() throws IOException {
            this.hflush();
        }

        public void hflush() throws IOException {
            this.checkStream();
            this.flush();
        }

        public void hsync() throws IOException {
            this.checkStream();
            this.flush();
        }

        public boolean hasCapability(String capability) {
            switch (capability.toLowerCase()) {
                case "hflush": 
                case "hsync": 
                case "dropbehind": {
                    return true;
                }
            }
            return false;
        }

        private void checkStream() throws IOException {
            if (this.closed) {
                throw new IOException("Stream is closed!");
            }
        }
    }
}

