/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.security.ssl;

import java.io.File;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.ByteBuffer;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.Map;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLSession;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.security.ssl.KeyStoreTestUtil;
import org.apache.hadoop.security.ssl.SSLFactory;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.hadoop.util.StringUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.event.Level;

public class TestSSLFactory {
    private static final Logger LOG = LoggerFactory.getLogger(TestSSLFactory.class);
    private static final String BASEDIR = GenericTestUtils.getTempPath(TestSSLFactory.class.getSimpleName());
    private static final String KEYSTORES_DIR = new File(BASEDIR).getAbsolutePath();
    private String sslConfsDir;
    private static final String excludeCiphers = "TLS_ECDHE_RSA_WITH_RC4_128_SHA,SSL_DHE_RSA_EXPORT_WITH_DES40_CBC_SHA,  \nSSL_RSA_WITH_DES_CBC_SHA,SSL_DHE_RSA_WITH_DES_CBC_SHA,  SSL_RSA_EXPORT_WITH_RC4_40_MD5,\t \nSSL_RSA_EXPORT_WITH_DES40_CBC_SHA,SSL_RSA_WITH_RC4_128_MD5";

    @BeforeClass
    public static void setUp() throws Exception {
        File base = new File(BASEDIR);
        FileUtil.fullyDelete((File)base);
        base.mkdirs();
    }

    private Configuration createConfiguration(boolean clientCert, boolean trustStore) throws Exception {
        Configuration conf = new Configuration();
        KeyStoreTestUtil.setupSSLConfig(KEYSTORES_DIR, this.sslConfsDir, conf, clientCert, trustStore, excludeCiphers);
        return conf;
    }

    @After
    @Before
    public void cleanUp() throws Exception {
        this.sslConfsDir = KeyStoreTestUtil.getClasspathDir(TestSSLFactory.class);
        KeyStoreTestUtil.cleanupSSLConfig(KEYSTORES_DIR, this.sslConfsDir);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(expected=IllegalStateException.class)
    public void clientMode() throws Exception {
        Configuration conf = this.createConfiguration(false, true);
        SSLFactory sslFactory = new SSLFactory(SSLFactory.Mode.CLIENT, conf);
        try {
            sslFactory.init();
            Assert.assertNotNull((Object)sslFactory.createSSLSocketFactory());
            Assert.assertNotNull((Object)sslFactory.getHostnameVerifier());
            sslFactory.createSSLServerSocketFactory();
        }
        finally {
            sslFactory.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void serverMode(boolean clientCert, boolean socket) throws Exception {
        Configuration conf = this.createConfiguration(clientCert, true);
        SSLFactory sslFactory = new SSLFactory(SSLFactory.Mode.SERVER, conf);
        try {
            sslFactory.init();
            Assert.assertNotNull((Object)sslFactory.createSSLServerSocketFactory());
            Assert.assertEquals((Object)clientCert, (Object)sslFactory.isClientCertRequired());
            if (socket) {
                sslFactory.createSSLSocketFactory();
            } else {
                sslFactory.getHostnameVerifier();
            }
        }
        finally {
            sslFactory.destroy();
        }
    }

    @Test(expected=IllegalStateException.class)
    public void serverModeWithoutClientCertsSocket() throws Exception {
        this.serverMode(false, true);
    }

    @Test(expected=IllegalStateException.class)
    public void serverModeWithClientCertsSocket() throws Exception {
        this.serverMode(true, true);
    }

    @Test(expected=IllegalStateException.class)
    public void serverModeWithoutClientCertsVerifier() throws Exception {
        this.serverMode(false, false);
    }

    @Test(expected=IllegalStateException.class)
    public void serverModeWithClientCertsVerifier() throws Exception {
        this.serverMode(true, false);
    }

    private void runDelegatedTasks(SSLEngineResult result, SSLEngine engine) throws Exception {
        if (result.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.NEED_TASK) {
            Runnable runnable;
            while ((runnable = engine.getDelegatedTask()) != null) {
                LOG.info("running delegated task...");
                runnable.run();
            }
            SSLEngineResult.HandshakeStatus hsStatus = engine.getHandshakeStatus();
            if (hsStatus == SSLEngineResult.HandshakeStatus.NEED_TASK) {
                throw new Exception("handshake shouldn't need additional tasks");
            }
        }
    }

    private static boolean isEngineClosed(SSLEngine engine) {
        return engine.isOutboundDone() && engine.isInboundDone();
    }

    private static void checkTransfer(ByteBuffer a, ByteBuffer b) throws Exception {
        a.flip();
        b.flip();
        Assert.assertTrue((String)"transfer did not complete", (boolean)a.equals(b));
        a.position(a.limit());
        b.position(b.limit());
        a.limit(a.capacity());
        b.limit(b.capacity());
    }

    @Test
    public void testServerWeakCiphers() throws Exception {
        GenericTestUtils.setLogLevel(SSLFactory.LOG, Level.DEBUG);
        Configuration conf = this.createConfiguration(true, true);
        SSLFactory serverSSLFactory = new SSLFactory(SSLFactory.Mode.SERVER, conf);
        SSLFactory clientSSLFactory = new SSLFactory(SSLFactory.Mode.CLIENT, conf);
        serverSSLFactory.init();
        clientSSLFactory.init();
        SSLEngine serverSSLEngine = serverSSLFactory.createSSLEngine();
        SSLEngine clientSSLEngine = clientSSLFactory.createSSLEngine();
        clientSSLEngine.setEnabledCipherSuites(StringUtils.getTrimmedStrings((String)excludeCiphers));
        SSLSession session = clientSSLEngine.getSession();
        int appBufferMax = session.getApplicationBufferSize();
        int netBufferMax = session.getPacketBufferSize();
        ByteBuffer clientOut = ByteBuffer.wrap("client".getBytes());
        ByteBuffer clientIn = ByteBuffer.allocate(appBufferMax);
        ByteBuffer serverOut = ByteBuffer.wrap("server".getBytes());
        ByteBuffer serverIn = ByteBuffer.allocate(appBufferMax);
        ByteBuffer cTOs = ByteBuffer.allocateDirect(netBufferMax);
        ByteBuffer sTOc = ByteBuffer.allocateDirect(netBufferMax);
        boolean dataDone = false;
        try {
            while (!TestSSLFactory.isEngineClosed(clientSSLEngine) || !TestSSLFactory.isEngineClosed(serverSSLEngine)) {
                LOG.info("client wrap " + this.wrap(clientSSLEngine, clientOut, cTOs));
                LOG.info("server wrap " + this.wrap(serverSSLEngine, serverOut, sTOc));
                cTOs.flip();
                sTOc.flip();
                LOG.info("client unwrap " + this.unwrap(clientSSLEngine, sTOc, clientIn));
                LOG.info("server unwrap " + this.unwrap(serverSSLEngine, cTOs, serverIn));
                cTOs.compact();
                sTOc.compact();
                if (dataDone || clientOut.limit() != serverIn.position() || serverOut.limit() != clientIn.position()) continue;
                TestSSLFactory.checkTransfer(serverOut, clientIn);
                TestSSLFactory.checkTransfer(clientOut, serverIn);
                LOG.info("closing client");
                clientSSLEngine.closeOutbound();
                dataDone = true;
            }
            Assert.fail((String)"The exception was not thrown");
        }
        catch (SSLHandshakeException e) {
            GenericTestUtils.assertExceptionContains("no cipher suites in common", e);
        }
    }

    private SSLEngineResult wrap(SSLEngine engine, ByteBuffer from, ByteBuffer to) throws Exception {
        SSLEngineResult result = engine.wrap(from, to);
        this.runDelegatedTasks(result, engine);
        return result;
    }

    private SSLEngineResult unwrap(SSLEngine engine, ByteBuffer from, ByteBuffer to) throws Exception {
        SSLEngineResult result = engine.unwrap(from, to);
        this.runDelegatedTasks(result, engine);
        return result;
    }

    @Test
    public void validHostnameVerifier() throws Exception {
        Configuration conf = this.createConfiguration(false, true);
        conf.unset("hadoop.ssl.hostname.verifier");
        SSLFactory sslFactory = new SSLFactory(SSLFactory.Mode.CLIENT, conf);
        sslFactory.init();
        Assert.assertEquals((Object)"DEFAULT", (Object)sslFactory.getHostnameVerifier().toString());
        sslFactory.destroy();
        conf.set("hadoop.ssl.hostname.verifier", "ALLOW_ALL");
        sslFactory = new SSLFactory(SSLFactory.Mode.CLIENT, conf);
        sslFactory.init();
        Assert.assertEquals((Object)"ALLOW_ALL", (Object)sslFactory.getHostnameVerifier().toString());
        sslFactory.destroy();
        conf.set("hadoop.ssl.hostname.verifier", "DEFAULT_AND_LOCALHOST");
        sslFactory = new SSLFactory(SSLFactory.Mode.CLIENT, conf);
        sslFactory.init();
        Assert.assertEquals((Object)"DEFAULT_AND_LOCALHOST", (Object)sslFactory.getHostnameVerifier().toString());
        sslFactory.destroy();
        conf.set("hadoop.ssl.hostname.verifier", "STRICT");
        sslFactory = new SSLFactory(SSLFactory.Mode.CLIENT, conf);
        sslFactory.init();
        Assert.assertEquals((Object)"STRICT", (Object)sslFactory.getHostnameVerifier().toString());
        sslFactory.destroy();
        conf.set("hadoop.ssl.hostname.verifier", "STRICT_IE6");
        sslFactory = new SSLFactory(SSLFactory.Mode.CLIENT, conf);
        sslFactory.init();
        Assert.assertEquals((Object)"STRICT_IE6", (Object)sslFactory.getHostnameVerifier().toString());
        sslFactory.destroy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(expected=GeneralSecurityException.class)
    public void invalidHostnameVerifier() throws Exception {
        Configuration conf = this.createConfiguration(false, true);
        conf.set("hadoop.ssl.hostname.verifier", "foo");
        SSLFactory sslFactory = new SSLFactory(SSLFactory.Mode.CLIENT, conf);
        try {
            sslFactory.init();
        }
        finally {
            sslFactory.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testConnectionConfigurator() throws Exception {
        Configuration conf = this.createConfiguration(false, true);
        conf.set("hadoop.ssl.hostname.verifier", "STRICT_IE6");
        SSLFactory sslFactory = new SSLFactory(SSLFactory.Mode.CLIENT, conf);
        try {
            sslFactory.init();
            HttpsURLConnection sslConn = (HttpsURLConnection)new URL("https://foo").openConnection();
            Assert.assertNotSame((Object)"STRICT_IE6", (Object)sslConn.getHostnameVerifier().toString());
            sslFactory.configure((HttpURLConnection)sslConn);
            Assert.assertEquals((Object)"STRICT_IE6", (Object)sslConn.getHostnameVerifier().toString());
        }
        finally {
            sslFactory.destroy();
        }
    }

    @Test
    public void testServerDifferentPasswordAndKeyPassword() throws Exception {
        this.checkSSLFactoryInitWithPasswords(SSLFactory.Mode.SERVER, "password", "keyPassword", "password", "keyPassword");
    }

    @Test
    public void testServerKeyPasswordDefaultsToPassword() throws Exception {
        this.checkSSLFactoryInitWithPasswords(SSLFactory.Mode.SERVER, "password", "password", "password", null);
    }

    @Test
    public void testClientDifferentPasswordAndKeyPassword() throws Exception {
        this.checkSSLFactoryInitWithPasswords(SSLFactory.Mode.CLIENT, "password", "keyPassword", "password", "keyPassword");
    }

    @Test
    public void testClientKeyPasswordDefaultsToPassword() throws Exception {
        this.checkSSLFactoryInitWithPasswords(SSLFactory.Mode.CLIENT, "password", "password", "password", null);
    }

    @Test
    public void testServerCredProviderPasswords() throws Exception {
        KeyStoreTestUtil.provisionPasswordsToCredentialProvider();
        this.checkSSLFactoryInitWithPasswords(SSLFactory.Mode.SERVER, "storepass", "keypass", null, null, true);
    }

    private void checkSSLFactoryInitWithPasswords(SSLFactory.Mode mode, String password, String keyPassword, String confPassword, String confKeyPassword) throws Exception {
        this.checkSSLFactoryInitWithPasswords(mode, password, keyPassword, confPassword, confKeyPassword, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkSSLFactoryInitWithPasswords(SSLFactory.Mode mode, String password, String keyPassword, String confPassword, String confKeyPassword, boolean useCredProvider) throws Exception {
        Configuration sslConf;
        String sslConfFileName;
        String keystore = new File(KEYSTORES_DIR, "keystore.jks").getAbsolutePath();
        String truststore = new File(KEYSTORES_DIR, "truststore.jks").getAbsolutePath();
        String trustPassword = "trustP";
        KeyPair keyPair = KeyStoreTestUtil.generateKeyPair("RSA");
        X509Certificate cert = KeyStoreTestUtil.generateCertificate("CN=Test", keyPair, 30, "SHA1withRSA");
        KeyStoreTestUtil.createKeyStore(keystore, password, keyPassword, "Test", keyPair.getPrivate(), cert);
        Map<String, X509Certificate> certs = Collections.singletonMap("server", cert);
        KeyStoreTestUtil.createTrustStore(truststore, trustPassword, certs);
        if (useCredProvider) {
            confPassword = null;
            confKeyPassword = null;
        }
        if (mode == SSLFactory.Mode.SERVER) {
            sslConfFileName = "ssl-server.xml";
            sslConf = KeyStoreTestUtil.createServerSSLConfig(keystore, confPassword, confKeyPassword, truststore);
            if (useCredProvider) {
                File testDir = GenericTestUtils.getTestDir();
                Path jksPath = new Path(testDir.toString(), "test.jks");
                String ourUrl = "jceks://file" + jksPath.toUri();
                sslConf.set("hadoop.security.credential.provider.path", ourUrl);
            }
        } else {
            sslConfFileName = "ssl-client.xml";
            sslConf = KeyStoreTestUtil.createClientSSLConfig(keystore, confPassword, confKeyPassword, truststore);
        }
        KeyStoreTestUtil.saveConfig(new File(this.sslConfsDir, sslConfFileName), sslConf);
        Configuration conf = new Configuration();
        conf.setBoolean("hadoop.ssl.require.client.cert", true);
        SSLFactory sslFactory = new SSLFactory(mode, conf);
        try {
            sslFactory.init();
        }
        finally {
            sslFactory.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNoClientCertsInitialization() throws Exception {
        Configuration conf = this.createConfiguration(false, true);
        conf.unset("hadoop.ssl.require.client.cert");
        SSLFactory sslFactory = new SSLFactory(SSLFactory.Mode.CLIENT, conf);
        try {
            sslFactory.init();
        }
        finally {
            sslFactory.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNoTrustStore() throws Exception {
        Configuration conf = this.createConfiguration(false, false);
        conf.unset("hadoop.ssl.require.client.cert");
        SSLFactory sslFactory = new SSLFactory(SSLFactory.Mode.SERVER, conf);
        try {
            sslFactory.init();
        }
        finally {
            sslFactory.destroy();
        }
    }
}

