/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.io.erasurecode.coder;

import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.io.erasurecode.CodecUtil;
import org.apache.hadoop.io.erasurecode.ECBlock;
import org.apache.hadoop.io.erasurecode.ECBlockGroup;
import org.apache.hadoop.io.erasurecode.ECSchema;
import org.apache.hadoop.io.erasurecode.ErasureCoderOptions;
import org.apache.hadoop.io.erasurecode.coder.AbstractErasureDecoder;
import org.apache.hadoop.io.erasurecode.coder.ErasureCodingStep;
import org.apache.hadoop.io.erasurecode.coder.ErasureDecodingStep;
import org.apache.hadoop.io.erasurecode.rawcoder.RawErasureDecoder;

@InterfaceAudience.Private
public class RSErasureDecoder
extends AbstractErasureDecoder {
    private RawErasureDecoder rsRawDecoder;

    public RSErasureDecoder(int numDataUnits, int numParityUnits) {
        super(numDataUnits, numParityUnits);
    }

    public RSErasureDecoder(ECSchema schema) {
        super(schema);
    }

    @Override
    protected ErasureCodingStep prepareDecodingStep(ECBlockGroup blockGroup) {
        ECBlock[] inputBlocks = this.getInputBlocks(blockGroup);
        ECBlock[] outputBlocks = this.getOutputBlocks(blockGroup);
        RawErasureDecoder rawDecoder = this.checkCreateRSRawDecoder();
        return new ErasureDecodingStep(inputBlocks, this.getErasedIndexes(inputBlocks), outputBlocks, rawDecoder);
    }

    private RawErasureDecoder checkCreateRSRawDecoder() {
        if (this.rsRawDecoder == null) {
            ErasureCoderOptions coderOptions = new ErasureCoderOptions(this.getNumDataUnits(), this.getNumParityUnits());
            this.rsRawDecoder = CodecUtil.createRawDecoder(this.getConf(), "rs-default", coderOptions);
        }
        return this.rsRawDecoder;
    }

    @Override
    public void release() {
        if (this.rsRawDecoder != null) {
            this.rsRawDecoder.release();
        }
    }
}

